/*
 * Decompiled with CFR 0.152.
 */
package org.droolsjbpm.services.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.droolsjbpm.services.api.Domain;
import org.droolsjbpm.services.api.KnowledgeDomainService;
import org.droolsjbpm.services.api.RulesNotificationService;
import org.droolsjbpm.services.api.SessionManager;
import org.droolsjbpm.services.api.bpmn2.BPMN2DataService;
import org.droolsjbpm.services.impl.SimpleDomainImpl;
import org.droolsjbpm.services.impl.event.listeners.CDIKbaseEventListener;
import org.droolsjbpm.services.impl.event.listeners.CDIProcessEventListener;
import org.droolsjbpm.services.impl.example.MoveFileWorkItemHandler;
import org.droolsjbpm.services.impl.example.NotificationWorkItemHandler;
import org.droolsjbpm.services.impl.example.TriggerTestsWorkItemHandler;
import org.jbpm.shared.services.api.FileException;
import org.jbpm.shared.services.api.FileService;
import org.jbpm.task.api.TaskServiceEntryPoint;
import org.jbpm.task.wih.CDIHTWorkItemHandler;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.file.Path;
import org.kie.runtime.StatefulKnowledgeSession;
import org.kie.runtime.process.WorkItem;
import org.kie.runtime.process.WorkItemHandler;
import org.kie.runtime.process.WorkItemManager;

@ApplicationScoped
public class KnowledgeDomainServiceImpl
implements KnowledgeDomainService {
    private Map<String, StatefulKnowledgeSession> ksessions = new HashMap<String, StatefulKnowledgeSession>();
    @Inject
    private CDIHTWorkItemHandler handler;
    @Inject
    private CDIProcessEventListener processListener;
    @Inject
    private CDIKbaseEventListener kbaseEventListener;
    @Inject
    private BPMN2DataService bpmn2Service;
    @Inject
    private FileService fs;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private TaskServiceEntryPoint taskService;
    @Inject
    private SessionManager sessionManager;
    @Inject
    private MoveFileWorkItemHandler moveFilesWIHandler;
    @Inject
    private TriggerTestsWorkItemHandler triggerTestsWorkItemHandler;
    @Inject
    private NotificationWorkItemHandler notificationWorkItemHandler;
    @Inject
    private RulesNotificationService rulesNotificationService;
    private Domain domain = new SimpleDomainImpl("myDomain");

    @Override
    @PostConstruct
    public void createDomain() {
        String processString;
        String kSessionName;
        this.sessionManager.setDomain(this.domain);
        Iterable releaseProcessesFiles = null;
        Iterable releaseRulesFiles = null;
        Iterable exampleProcessesFiles = null;
        try {
            releaseProcessesFiles = this.fs.loadFilesByType("examples/release/", "bpmn");
            releaseRulesFiles = this.fs.loadFilesByType("examples/release/", "drl");
            exampleProcessesFiles = this.fs.loadFilesByType("examples/general/", "bpmn");
        }
        catch (FileException ex) {
            Logger.getLogger(KnowledgeDomainServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        for (Path p : releaseProcessesFiles) {
            kSessionName = "releaseSession";
            this.domain.addProcessDefinitionToKsession(kSessionName, p);
            System.out.println(" >>> Adding Path to ReleaseSession- > " + p.toString());
            processString = new String(this.ioService.readAllBytes(p));
            this.domain.addProcessBPMN2ContentToKsession(kSessionName, this.bpmn2Service.findProcessId(processString), processString);
        }
        for (Path p : releaseRulesFiles) {
            kSessionName = "releaseSession";
            System.out.println(" >>> Adding Path to ReleaseSession- > " + p.toString());
            this.domain.addRulesDefinitionToKsession(kSessionName, p);
        }
        for (Path p : exampleProcessesFiles) {
            kSessionName = "generalSession";
            this.domain.addProcessDefinitionToKsession("generalSession", p);
            System.out.println(" >>> Adding Path to GeneralSession - > " + p.toString());
            processString = new String(this.ioService.readAllBytes(p));
            this.domain.addProcessBPMN2ContentToKsession(kSessionName, this.bpmn2Service.findProcessId(processString), processString);
        }
        this.sessionManager.buildSessions(true);
        this.sessionManager.addKsessionHandler("releaseSession", "MoveToStagingArea", this.moveFilesWIHandler);
        this.sessionManager.addKsessionHandler("releaseSession", "MoveToTest", this.moveFilesWIHandler);
        this.sessionManager.addKsessionHandler("releaseSession", "TriggerTests", this.triggerTestsWorkItemHandler);
        this.sessionManager.addKsessionHandler("releaseSession", "MoveBackToStaging", this.moveFilesWIHandler);
        this.sessionManager.addKsessionHandler("releaseSession", "MoveToProduction", this.moveFilesWIHandler);
        this.sessionManager.addKsessionHandler("releaseSession", "Email", this.notificationWorkItemHandler);
        this.sessionManager.registerHandlersForSession("releaseSession");
        this.sessionManager.registerRuleListenerForSession("releaseSession");
        this.sessionManager.getKsessionByName("releaseSession").setGlobal("rulesNotificationService", (Object)this.rulesNotificationService);
        this.sessionManager.getKsessionByName("releaseSession").setGlobal("taskService", (Object)this.taskService);
    }

    @Override
    public Collection<String> getSessionsNames() {
        return this.sessionManager.getAllSessionsNames();
    }

    @Override
    public int getAmountOfSessions() {
        return this.sessionManager.getAllSessionsNames().size();
    }

    @Override
    public Map<String, String> getAvailableProcesses() {
        return this.domain.getAllProcesses();
    }

    @Override
    public StatefulKnowledgeSession getSessionByName(String ksessionName) {
        return this.sessionManager.getKsessionByName(ksessionName);
    }

    @Override
    public String getProcessInSessionByName(String processDefId) {
        return this.sessionManager.getProcessInSessionByName(processDefId);
    }

    private class MockTestWorkItemHandler
    implements WorkItemHandler {
        private MockTestWorkItemHandler() {
        }

        public void executeWorkItem(WorkItem wi, WorkItemManager wim) {
            for (String k : wi.getParameters().keySet()) {
                System.out.println("Key = " + k + " - value = " + wi.getParameter(k));
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("out_test_successful", "true");
            params.put("out_test_report", "All Test were SUCCESSFULY executed!");
            System.out.println("######### Test Output");
            System.out.println(" out_test_successful = " + params.get("out_test_successful"));
            System.out.println(" out_test_report = " + params.get("out_test_report"));
            System.out.println("#####################");
            wim.completeWorkItem(wi.getId(), params);
        }

        public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
        }
    }

    private class DoNothingWorkItemHandler
    implements WorkItemHandler {
        private DoNothingWorkItemHandler() {
        }

        public void executeWorkItem(WorkItem wi, WorkItemManager wim) {
            for (String k : wi.getParameters().keySet()) {
                System.out.println("Key = " + k + " - value = " + wi.getParameter(k));
            }
            wim.completeWorkItem(wi.getId(), null);
        }

        public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
        }
    }
}

