/*
 * Decompiled with CFR 0.152.
 */
package org.droolsjbpm.services.impl.example;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jbpm.shared.services.api.FileService;
import org.kie.runtime.process.WorkItem;
import org.kie.runtime.process.WorkItemHandler;
import org.kie.runtime.process.WorkItemManager;

public class MoveFileWorkItemHandler
implements WorkItemHandler {
    public static final String WIP_INPUT_RELEASE = "in_release_path";
    public static final String WIP_INPUT_SOURCE = "in_source_dir";
    public static final String WIP_INPUT_TARGET = "in_target_dir";
    public static final String WIP_INPUT_FILES = "in_files";
    public static final String WIP_INPUT_KEEP_ORIGINAL_FILES = "in_keep_original_files";
    public static final String WIP_OUTPUT_ERRORS = "out_errors";
    public static final boolean KEEP_ORIGINAL_FILES_DEFAULT_VALUE = false;
    @Inject
    private FileService fs;

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        boolean keepOriginalFiles;
        System.out.println("############ Work Item Parameters");
        for (String k : workItem.getParameters().keySet()) {
            System.out.println("Key = " + k + " - value = " + workItem.getParameter(k));
        }
        System.out.println("#################################");
        LinkedHashMap<String, String> errors = new LinkedHashMap<String, String>();
        String release = (String)workItem.getParameter(WIP_INPUT_RELEASE);
        String source = (String)workItem.getParameter(WIP_INPUT_SOURCE);
        String filesNames = (String)workItem.getParameter(WIP_INPUT_FILES);
        String destination = (String)workItem.getParameter(WIP_INPUT_TARGET);
        boolean bl = keepOriginalFiles = workItem.getParameter("WIP_INPUT_KEEP_ORIGINAL_FILES") != null ? Boolean.parseBoolean(workItem.getParameter("WIP_INPUT_KEEP_ORIGINAL_FILES").toString()) : false;
        if (filesNames == null || filesNames.isEmpty()) {
            throw new IllegalArgumentException("'in_files' parameter is mandatory!");
        }
        if (destination == null || destination.isEmpty()) {
            throw new IllegalArgumentException("'in_target_dir' parameter is mandatory!");
        }
        if (source == null || source.isEmpty()) {
            throw new IllegalArgumentException("'in_source_dir' parameter is mandatory!");
        }
        if (release == null || release.isEmpty()) {
            throw new IllegalArgumentException("'in_release_path' parameter is mandatory!");
        }
        List<String> files = Arrays.asList(filesNames.trim().split(","));
        source = release + "/" + source;
        destination = release + "/" + destination;
        if (this.fs.exists(destination)) {
            for (String file : files) {
                String fqn = source + "/" + file.trim();
                try {
                    if (!this.fs.exists(fqn)) {
                        errors.put(fqn, "Doesn't exist");
                        continue;
                    }
                    if (keepOriginalFiles) {
                        this.fs.copy(fqn, destination + "/" + file.trim());
                        continue;
                    }
                    this.fs.move(fqn, destination + "/" + file.trim());
                }
                catch (Exception e) {
                    errors.put(fqn, e.getMessage());
                }
            }
        } else {
            errors.put("destination", "Doesn't exist");
        }
        StringBuilder errorsString = new StringBuilder("");
        for (Map.Entry entry : errors.entrySet()) {
            if (errorsString.length() != 0) {
                errorsString.append(",");
            }
            errorsString.append("[").append((String)entry.getKey()).append("] -> ").append((String)entry.getValue());
        }
        HashMap<String, String> results = new HashMap<String, String>();
        results.put(WIP_OUTPUT_ERRORS, errorsString.toString());
        System.out.println("############ Work Item Outputs");
        System.out.println(" ERRORS: " + errorsString.toString());
        System.out.println("#################################");
        manager.completeWorkItem(workItem.getId(), results);
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }
}

