/*
 * Copyright 2013 JBoss by Red Hat.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.droolsjbpm.services.api;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.droolsjbpm.services.domain.entities.Domain;
import org.droolsjbpm.services.domain.entities.Organization;
import org.droolsjbpm.services.impl.model.ProcessDesc;
import org.kie.internal.runtime.manager.Runtime;
import org.kie.internal.runtime.manager.RuntimeManager;
/**
 *
 * @author salaboy
 */
public interface DomainManagerService {
    
    List<Organization> getAllOrganizations();
    long storeOrganization(Organization organization);
    void removeOrganization(long organizationId);
    
    Organization getOrganizationById(long organizationId);
    Domain getDomainById(long domainId);
    
    List<Domain> getAllDomains();
    List<Domain> getAllDomainsByOrganization(long organizationId);
    Domain getDomainByName(String domainName);
    
    long storeDomain(Domain domain);
    void removeDomain(long domainId);
    
    void initOrganization(long organizationId);
    void initDomain(long domainId);
    
    Map<String, RuntimeManager> getDomainsMap();
    RuntimeManager getRuntimesByDomain(String domainName);
    
    Collection<ProcessDesc> getProcessesByDomainName(String domainName);
    
    
}
