/*
 * Decompiled with CFR 0.152.
 */
package org.droolsjbpm.services.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.droolsjbpm.services.api.RuntimeDataService;
import org.droolsjbpm.services.impl.model.NodeInstanceDesc;
import org.droolsjbpm.services.impl.model.ProcessDesc;
import org.droolsjbpm.services.impl.model.ProcessInstanceDesc;
import org.droolsjbpm.services.impl.model.VariableStateDesc;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.services.task.wih.RuntimeFinder;
import org.jbpm.shared.services.api.JbpmServicesPersistenceManager;

@ApplicationScoped
@Transactional
public class RuntimeDataServiceImpl
implements RuntimeDataService,
RuntimeFinder {
    @Inject
    private JbpmServicesPersistenceManager pm;

    public void setPm(JbpmServicesPersistenceManager pm) {
        this.pm = pm;
    }

    @Override
    public Collection<ProcessDesc> getProcessesByDomainName(String domainName) {
        List processes = (List)this.pm.queryWithParametersInTransaction("getProcessesByDomainName", (Map)this.pm.addParametersToMap(new Object[]{"domainName", domainName}));
        return processes;
    }

    @Override
    public Collection<ProcessDesc> getProcessesByFilter(String filter) {
        List processes = (List)this.pm.queryWithParametersInTransaction("getProcessesByFilter", (Map)this.pm.addParametersToMap(new Object[]{"filter", filter + "%"}));
        return processes;
    }

    @Override
    public ProcessDesc getProcessById(String processId) {
        return (ProcessDesc)((List)this.pm.queryWithParametersInTransaction("getProcessById", (Map)this.pm.addParametersToMap(new Object[]{"processId", processId}))).get(0);
    }

    @Override
    public Collection<ProcessDesc> getProcesses() {
        List processes = (List)this.pm.queryInTransaction("getProcesses");
        return processes;
    }

    @Override
    public Collection<ProcessInstanceDesc> getProcessInstances() {
        List processInstances = (List)this.pm.queryInTransaction("getProcessInstances");
        return processInstances;
    }

    @Override
    public Collection<ProcessInstanceDesc> getProcessInstances(List<Integer> states, String initiator) {
        List processInstances = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("states", states);
        if (initiator == null) {
            processInstances = (List)this.pm.queryWithParametersInTransaction("getProcessInstancesByStatus", params);
        } else {
            params.put("initiator", initiator);
            processInstances = (List)this.pm.queryWithParametersInTransaction("getProcessInstancesByStatusAndInitiator", params);
        }
        return processInstances;
    }

    @Override
    public Collection<ProcessInstanceDesc> getProcessInstancesByDomainId(String domainId) {
        List processInstances = (List)this.pm.queryStringWithParametersInTransaction("getProcessInstancesByDomainId", (Map)this.pm.addParametersToMap(new Object[]{"domainId", domainId}));
        return processInstances;
    }

    @Override
    public Collection<ProcessInstanceDesc> getProcessInstancesByProcessDefinition(String processDefId) {
        List processInstances = (List)this.pm.queryWithParametersInTransaction("getProcessInstancesByProcessDefinition", (Map)this.pm.addParametersToMap(new Object[]{"processDefId", processDefId}));
        return processInstances;
    }

    @Override
    public ProcessInstanceDesc getProcessInstanceById(long processId) {
        List processInstances = (List)this.pm.queryWithParametersInTransaction("getProcessInstanceById", (Map)this.pm.addParametersToMap(new Object[]{"processId", processId, "maxResults", 1}));
        return (ProcessInstanceDesc)processInstances.get(0);
    }

    @Override
    public Collection<ProcessInstanceDesc> getProcessInstancesByProcessId(List<Integer> states, String processId, String initiator) {
        List processInstances = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("states", states);
        params.put("processId", processId + "%");
        if (initiator == null) {
            processInstances = (List)this.pm.queryWithParametersInTransaction("getProcessInstancesByProcessIdAndStatus", params);
        } else {
            params.put("initiator", initiator);
            processInstances = (List)this.pm.queryWithParametersInTransaction("getProcessInstancesByProcessIdAndStatusAndInitiator", params);
        }
        return processInstances;
    }

    @Override
    public Collection<ProcessInstanceDesc> getProcessInstancesByProcessName(List<Integer> states, String processName, String initiator) {
        List processInstances = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("states", states);
        params.put("processName", processName + "%");
        if (initiator == null) {
            processInstances = (List)this.pm.queryWithParametersInTransaction("getProcessInstancesByProcessNameAndStatus", params);
        } else {
            params.put("initiator", initiator);
            processInstances = (List)this.pm.queryWithParametersInTransaction("getProcessInstancesByProcessNameAndStatusAndInitiator", params);
        }
        return processInstances;
    }

    @Override
    public Collection<NodeInstanceDesc> getProcessInstanceHistory(String domainId, long processId) {
        return this.getProcessInstanceHistory(domainId, processId, false);
    }

    @Override
    public Collection<NodeInstanceDesc> getProcessInstanceHistory(String domainId, long processId, boolean completed) {
        HashMap params = this.pm.addParametersToMap(new Object[]{"processId", processId, "domainId", domainId});
        if (completed) {
            params.put("type", 1);
        } else {
            params.put("type", 0);
        }
        List nodeInstances = (List)this.pm.queryWithParametersInTransaction("getProcessInstanceHistory", (Map)params);
        return nodeInstances;
    }

    @Override
    public Collection<NodeInstanceDesc> getProcessInstanceFullHistory(String domainId, long processId) {
        List nodeInstances = (List)this.pm.queryWithParametersInTransaction("getProcessInstanceFullHistory", (Map)this.pm.addParametersToMap(new Object[]{"processId", processId, "domainId", domainId}));
        return nodeInstances;
    }

    @Override
    public Collection<NodeInstanceDesc> getProcessInstanceActiveNodes(String domainId, long processId) {
        List activeNodeInstances = (List)this.pm.queryWithParametersInTransaction("getProcessInstanceActiveNodes", (Map)this.pm.addParametersToMap(new Object[]{"processId", processId, "domainId", domainId}));
        return activeNodeInstances;
    }

    @Override
    public Collection<NodeInstanceDesc> getProcessInstanceCompletedNodes(String domainId, long processId) {
        List completedNodeInstances = (List)this.pm.queryWithParametersInTransaction("getProcessInstanceCompletedNodes", (Map)this.pm.addParametersToMap(new Object[]{"processId", processId, "domainId", domainId}));
        return completedNodeInstances;
    }

    @Override
    public Collection<VariableStateDesc> getVariablesCurrentState(long processInstanceId) {
        List variablesState = (List)this.pm.queryWithParametersInTransaction("getVariablesCurrentState", (Map)this.pm.addParametersToMap(new Object[]{"processInstanceId", processInstanceId}));
        return variablesState;
    }

    @Override
    public Collection<VariableStateDesc> getVariableHistory(long processInstanceId, String variableId) {
        List variablesState = (List)this.pm.queryWithParametersInTransaction("getVariableHistory", (Map)this.pm.addParametersToMap(new Object[]{"processInstanceId", processInstanceId, "variableId", variableId}));
        return variablesState;
    }

    public String findName(long id) {
        ProcessInstanceDesc piDesc = this.getProcessInstanceById(id);
        return piDesc.getDomainId();
    }
}

