/*
 * Decompiled with CFR 0.152.
 */
package org.droolsjbpm.services.impl.example;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.jbpm.shared.services.api.FileException;
import org.jbpm.shared.services.api.FileService;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.commons.java.nio.file.Path;

public class TriggerTestsWorkItemHandler
implements WorkItemHandler {
    public static final String WIP_INPUT_RELEASE = "in_release_path";
    public static final String WIP_INPUT_TEST = "in_test_dir";
    public static final String WIP_INPUT_MIN_CONTENT_LENGTH = "in_min_lenght";
    public static final String WIP_INPUT_MAX_CONTENT_LENGTH = "in_max_lenght";
    public static final String WIP_OUTPUT_SUCCESSFUL = "out_test_successful";
    public static final String WIP_OUTPUT_REPORT = "out_test_report";
    private static final int DEFAULT_MIN_CONTENT_LENGTH = 10;
    private static final int DEFAULT_MAX_CONTENT_LENGTH = 50;
    @Inject
    private FileService fs;

    public void executeWorkItem(final WorkItem workItem, final WorkItemManager manager) {
        int maxLength;
        Boolean success = true;
        Boolean sleep = false;
        StringBuilder report = null;
        String releasePath = (String)workItem.getParameter(WIP_INPUT_RELEASE);
        String testDir = (String)workItem.getParameter(WIP_INPUT_TEST);
        int minLength = workItem.getParameter(WIP_INPUT_MIN_CONTENT_LENGTH) != null ? Integer.parseInt(workItem.getParameter(WIP_INPUT_MIN_CONTENT_LENGTH).toString()) : 10;
        int n = maxLength = workItem.getParameter(WIP_INPUT_MAX_CONTENT_LENGTH) != null ? Integer.parseInt(workItem.getParameter(WIP_INPUT_MAX_CONTENT_LENGTH).toString()) : 50;
        if (releasePath == null || releasePath.isEmpty()) {
            throw new IllegalArgumentException("'in_release_path' parameter is mandatory!");
        }
        if (testDir == null || testDir.isEmpty()) {
            throw new IllegalArgumentException("'in_test_dir' parameter is mandatory!");
        }
        String testPath = releasePath + "/" + testDir;
        if (!this.fs.exists(testPath)) {
            throw new IllegalArgumentException(testPath + " doesn't exist!");
        }
        report = new StringBuilder("");
        try {
            Iterable txtFiles = this.fs.loadFilesByType(testPath, "txt");
            if (txtFiles == null || !txtFiles.iterator().hasNext()) {
                report.append("EE ").append(testPath).append(" doesn't contain any .txt file!\n");
                success = false;
            } else {
                for (Path path : txtFiles) {
                    String content = new String(this.fs.loadFile(path));
                    if (content == null || content.isEmpty()) {
                        report.append("EE ").append(path).append(" is empty!\n");
                        success = false;
                        continue;
                    }
                    if (content.length() < minLength) {
                        report.append("EE ").append(path).append(" -> Content is shorter than ").append(minLength).append(" -> '").append(content).append("'");
                        success = false;
                    }
                    if (content.length() > maxLength) {
                        report.append("WW ").append(path).append(" -> Took too much time! \n");
                        sleep = true;
                        continue;
                    }
                    report.append("II ").append(path).append(" -> OK\n");
                }
            }
        }
        catch (FileException ex) {
            throw new RuntimeException(ex);
        }
        final HashMap<String, String> results = new HashMap<String, String>();
        results.put(WIP_OUTPUT_SUCCESSFUL, (success + "").toLowerCase());
        results.put(WIP_OUTPUT_REPORT, report.toString());
        if (sleep.booleanValue()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        for (int i = 0; i < 11; ++i) {
                            System.out.println(">>> Running Tests ... ");
                            Thread.sleep(1000L);
                        }
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(TriggerTestsWorkItemHandler.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    manager.completeWorkItem(workItem.getId(), results);
                }
            }).start();
        } else {
            System.out.println(">>> Running Tests ... ");
            manager.completeWorkItem(workItem.getId(), results);
        }
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }
}

