/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.jbpm.process.audit.event.AuditEvent;

@Entity
@SequenceGenerator(name="nodeInstanceLogIdSeq", sequenceName="NODE_INST_LOG_ID_SEQ", allocationSize=1)
public class NodeInstanceLog
implements Serializable,
AuditEvent,
org.kie.api.runtime.manager.audit.NodeInstanceLog {
    private static final long serialVersionUID = 510L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="nodeInstanceLogIdSeq")
    private long id;
    private long processInstanceId;
    private String processId;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="log_date")
    private Date date;
    private int type;
    private String nodeInstanceId;
    private String nodeId;
    private String nodeName;
    private String nodeType;
    private Long workItemId;
    private String connection;
    private String externalId;

    public NodeInstanceLog() {
    }

    public NodeInstanceLog(int type, long processInstanceId, String processId, String nodeInstanceId, String nodeId, String nodeName) {
        this.type = type;
        this.processInstanceId = processInstanceId;
        this.processId = processId;
        this.nodeInstanceId = nodeInstanceId;
        this.nodeId = nodeId;
        this.nodeName = nodeName;
        this.date = new Date();
    }

    public int getType() {
        return this.type;
    }

    void setType(int type) {
        this.type = type;
    }

    public long getId() {
        return this.id;
    }

    void setId(long id) {
        this.id = id;
    }

    public long getProcessInstanceId() {
        return this.processInstanceId;
    }

    void setProcessInstanceId(long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getProcessId() {
        return this.processId;
    }

    void setProcessId(String processId) {
        this.processId = processId;
    }

    public String getNodeInstanceId() {
        return this.nodeInstanceId;
    }

    void setNodeInstanceId(String nodeInstanceId) {
        this.nodeInstanceId = nodeInstanceId;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public Date getDate() {
        return this.date;
    }

    void setDate(Date date) {
        this.date = date;
    }

    public String toString() {
        return (this.type == 0 ? "Triggered " : "Left ") + "Node Instance '" + this.processId + "#" + this.nodeId + "' (" + this.nodeName + ") [" + this.processInstanceId + "#" + this.nodeInstanceId + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.date == null ? 0 : this.date.hashCode());
        result = 31 * result + (int)this.id;
        result = 31 * result + (this.nodeId == null ? 0 : this.nodeId.hashCode());
        result = 31 * result + (this.nodeInstanceId == null ? 0 : this.nodeInstanceId.hashCode());
        result = 31 * result + (this.processId == null ? 0 : this.processId.hashCode());
        result = 31 * result + (int)this.processInstanceId;
        result = 31 * result + this.type;
        result = 31 * result + (this.nodeType == null ? 0 : this.nodeType.hashCode());
        result = 31 * result + (this.workItemId == null ? 0 : this.workItemId.hashCode());
        result = 31 * result + (this.connection == null ? 0 : this.connection.hashCode());
        result = 31 * result + (this.externalId == null ? 0 : this.externalId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeInstanceLog other = (NodeInstanceLog)obj;
        if (this.date == null ? other.date != null : !this.date.equals(other.date)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.nodeId == null ? other.nodeId != null : !this.nodeId.equals(other.nodeId)) {
            return false;
        }
        if (this.nodeInstanceId == null ? other.nodeInstanceId != null : !this.nodeInstanceId.equals(other.nodeInstanceId)) {
            return false;
        }
        if (this.processId == null ? other.processId != null : !this.processId.equals(other.processId)) {
            return false;
        }
        if (this.processInstanceId != other.processInstanceId) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        if (this.nodeType == null ? other.nodeType != null : !this.nodeType.equals(other.nodeType)) {
            return false;
        }
        if (this.workItemId == null ? other.workItemId != null : !this.workItemId.equals(other.workItemId)) {
            return false;
        }
        if (this.connection == null ? other.connection != null : !this.connection.equals(other.connection)) {
            return false;
        }
        return !(this.externalId == null ? other.externalId != null : !this.externalId.equals(other.externalId));
    }

    public Long getWorkItemId() {
        return this.workItemId;
    }

    public void setWorkItemId(Long workItemId) {
        this.workItemId = workItemId;
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String domainId) {
        this.externalId = domainId;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }
}

