/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit.jms;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.jbpm.process.audit.ArchiveLoggerProvider;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.kie.soup.xstream.XStreamUtils;

public class AsyncAuditLogReceiver
implements MessageListener {
    private EntityManagerFactory entityManagerFactory;
    private XStream xstream;
    private List<ArchiveLoggerProvider> archiveLoggerProvider;

    public AsyncAuditLogReceiver(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
        this.initXStream();
        this.initArchiveLoggerProvider();
    }

    private void initXStream() {
        if (this.xstream == null) {
            this.xstream = XStreamUtils.createTrustingXStream();
            String[] voidDeny = new String[]{"void.class", "Void.class"};
            this.xstream.denyTypes(voidDeny);
        }
    }

    private void initArchiveLoggerProvider() {
        this.archiveLoggerProvider = new ArrayList<ArchiveLoggerProvider>();
        ServiceLoader.load(ArchiveLoggerProvider.class).forEach(e -> this.archiveLoggerProvider.add((ArchiveLoggerProvider)e));
    }

    public void onMessage(Message message) {
        if (message instanceof TextMessage) {
            EntityManager em = this.getEntityManager();
            TextMessage textMessage = (TextMessage)message;
            try {
                String messageContent = textMessage.getText();
                Integer eventType = textMessage.getIntProperty("EventType");
                Object event = this.xstream.fromXML(messageContent);
                switch (eventType) {
                    case 5: {
                        List result;
                        NodeInstanceLog nodeAfterEnterEvent = (NodeInstanceLog)event;
                        if (nodeAfterEnterEvent.getWorkItemId() == null || (result = em.createQuery("from NodeInstanceLog as log where log.nodeInstanceId = :nodeId and log.type = 0").setParameter("nodeId", (Object)nodeAfterEnterEvent.getNodeInstanceId()).getResultList()) == null || result.size() == 0) break;
                        NodeInstanceLog log = (NodeInstanceLog)result.get(result.size() - 1);
                        log.setWorkItemId(nodeAfterEnterEvent.getWorkItemId());
                        em.merge((Object)log);
                        break;
                    }
                    case 3: {
                        ProcessInstanceLog processCompletedEvent = (ProcessInstanceLog)event;
                        List result = em.createQuery("from ProcessInstanceLog as log where log.processInstanceId = :piId and log.end is null").setParameter("piId", (Object)processCompletedEvent.getProcessInstanceId()).getResultList();
                        if (result == null || result.size() == 0) break;
                        ProcessInstanceLog log = (ProcessInstanceLog)result.get(result.size() - 1);
                        log.setOutcome(processCompletedEvent.getOutcome());
                        log.setStatus(processCompletedEvent.getStatus());
                        log.setEnd(processCompletedEvent.getEnd());
                        log.setDuration(processCompletedEvent.getDuration());
                        em.merge((Object)log);
                        this.archiveLoggerProvider.stream().forEach(archiver -> archiver.archive(em, log));
                        break;
                    }
                    default: {
                        em.persist(event);
                    }
                }
                em.flush();
                em.close();
            }
            catch (JMSException e) {
                e.printStackTrace();
                throw new RuntimeException("Exception when receiving audit event event", e);
            }
        }
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public EntityManager getEntityManager() {
        return this.entityManagerFactory.createEntityManager();
    }
}

