/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.SingularAttribute;
import org.jbpm.process.audit.JPAService;
import org.jbpm.process.audit.NodeInstanceLog_;
import org.jbpm.process.audit.ProcessInstanceLog_;
import org.jbpm.process.audit.VariableInstanceLog;
import org.jbpm.process.audit.VariableInstanceLog_;
import org.jbpm.query.jpa.data.QueryCriteria;
import org.jbpm.query.jpa.data.QueryParameterIdentifiersUtil;
import org.jbpm.query.jpa.data.QueryWhere;
import org.jbpm.query.jpa.impl.QueryCriteriaUtil;
import org.kie.internal.query.QueryParameterIdentifiers;

public class AuditQueryCriteriaUtil
extends QueryCriteriaUtil {
    public static final Map<Class, Map<String, Attribute>> criteriaAttributes = new ConcurrentHashMap<Class, Map<String, Attribute>>();
    protected JPAService jpaService;

    protected synchronized boolean initializeCriteriaAttributes() {
        if (ProcessInstanceLog_.correlationKey == null) {
            return false;
        }
        if (!criteriaAttributes.isEmpty()) {
            return true;
        }
        AuditQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.PROCESS_INSTANCE_ID_LIST, ProcessInstanceLog_.processInstanceId);
        AuditQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.PROCESS_ID_LIST, ProcessInstanceLog_.processId);
        AuditQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.START_DATE_LIST, ProcessInstanceLog_.start);
        AuditQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.END_DATE_LIST, ProcessInstanceLog_.end);
        AuditQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.PROCESS_INSTANCE_STATUS_LIST, ProcessInstanceLog_.status);
        AuditQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.PROCESS_INSTANCE_PARENT_ID_LIST, ProcessInstanceLog_.parentProcessInstanceId);
        AuditQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.OUTCOME_LIST, ProcessInstanceLog_.outcome);
        AuditQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.DURATION_LIST, ProcessInstanceLog_.duration);
        AuditQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.IDENTITY_LIST, ProcessInstanceLog_.identity);
        AuditQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.PROCESS_VERSION_LIST, ProcessInstanceLog_.processVersion);
        AuditQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.PROCESS_NAME_LIST, ProcessInstanceLog_.processName);
        AuditQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.CORRELATION_KEY_LIST, ProcessInstanceLog_.correlationKey);
        AuditQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.EXTERNAL_ID_LIST, ProcessInstanceLog_.externalId);
        AuditQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.PROCESS_INSTANCE_ID_LIST, NodeInstanceLog_.processInstanceId);
        AuditQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.PROCESS_ID_LIST, NodeInstanceLog_.processId);
        AuditQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.EXTERNAL_ID_LIST, NodeInstanceLog_.externalId);
        AuditQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.DATE_LIST, NodeInstanceLog_.date);
        AuditQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.NODE_INSTANCE_ID_LIST, NodeInstanceLog_.nodeInstanceId);
        AuditQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.NODE_ID_LIST, NodeInstanceLog_.nodeId);
        AuditQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.NODE_NAME_LIST, NodeInstanceLog_.nodeName);
        AuditQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.TYPE_LIST, NodeInstanceLog_.nodeType);
        AuditQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.WORK_ITEM_ID_LIST, NodeInstanceLog_.workItemId);
        AuditQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.PROCESS_INSTANCE_ID_LIST, VariableInstanceLog_.processInstanceId);
        AuditQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.PROCESS_ID_LIST, VariableInstanceLog_.processId);
        AuditQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.DATE_LIST, VariableInstanceLog_.date);
        AuditQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.EXTERNAL_ID_LIST, VariableInstanceLog_.externalId);
        AuditQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.VARIABLE_INSTANCE_ID_LIST, VariableInstanceLog_.variableInstanceId);
        AuditQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.VARIABLE_ID_LIST, VariableInstanceLog_.variableId);
        AuditQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.VALUE_LIST, VariableInstanceLog_.value);
        AuditQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.OLD_VALUE_LIST, VariableInstanceLog_.oldValue);
        return true;
    }

    public AuditQueryCriteriaUtil(JPAService service) {
        super(criteriaAttributes);
        this.jpaService = service;
    }

    protected AuditQueryCriteriaUtil(Map<Class, Map<String, Attribute>> criteriaAttributes, JPAService service) {
        super(criteriaAttributes);
        this.jpaService = service;
    }

    protected EntityManager getEntityManager() {
        return this.jpaService.getEntityManager();
    }

    protected Object joinTransaction(EntityManager em) {
        return this.jpaService.joinTransaction(em);
    }

    protected void closeEntityManager(EntityManager em, Object transaction) {
        this.jpaService.closeEntityManager(em, transaction);
    }

    protected CriteriaBuilder getCriteriaBuilder() {
        return this.getEntityManager().getCriteriaBuilder();
    }

    protected <T> List<T> createQueryAndCallApplyMetaCriteriaAndGetResult(QueryWhere queryWhere, CriteriaQuery<T> criteriaQuery, CriteriaBuilder builder) {
        EntityManager em = this.getEntityManager();
        Object newTx = this.joinTransaction(em);
        TypedQuery query = em.createQuery(criteriaQuery);
        AuditQueryCriteriaUtil.applyMetaCriteriaToQuery((Query)query, (QueryWhere)queryWhere);
        List result = query.getResultList();
        this.closeEntityManager(em, newTx);
        return result;
    }

    protected <R, T> Predicate implSpecificCreatePredicateFromSingleCriteria(CriteriaQuery<R> query, CriteriaBuilder builder, Class queryType, QueryCriteria criteria, QueryWhere queryWhere) {
        Root table = AuditQueryCriteriaUtil.getRoot(query, (Class)queryType);
        return AuditQueryCriteriaUtil.variableInstanceLogSpecificCreatePredicateFromSingleCriteria(query, builder, criteria, table);
    }

    public static <Q, T> Predicate variableInstanceLogSpecificCreatePredicateFromSingleCriteria(CriteriaQuery<Q> query, CriteriaBuilder builder, QueryCriteria criteria, Root<T> table) {
        CriteriaBuilder.In predicate;
        if (QueryParameterIdentifiers.LAST_VARIABLE_LIST.equals(criteria.getListId())) {
            Subquery maxIdSubQuery = query.subquery(VariableInstanceLog.class);
            Root from = maxIdSubQuery.from(VariableInstanceLog.class);
            maxIdSubQuery.select(builder.max((Expression)from.get(VariableInstanceLog_.id)));
            maxIdSubQuery.groupBy(new Expression[]{from.get(VariableInstanceLog_.variableId), from.get(VariableInstanceLog_.processInstanceId)});
            SingularAttribute<VariableInstanceLog, Long> varIdField = VariableInstanceLog_.id;
            if (!(varIdField instanceof SingularAttribute)) {
                throw new IllegalStateException("Unexpected " + varIdField.getClass().getName() + " when processing last variable query criteria!");
            }
            Path expr = table.get(varIdField);
            predicate = builder.in((Expression)expr).value((Expression)maxIdSubQuery);
        } else if (QueryParameterIdentifiers.VAR_VALUE_ID_LIST.equals(criteria.getListId())) {
            Predicate valPredicate;
            assert (criteria.getValues().size() == 1) : "Only 1 var id/value parameter expected!";
            Object varVal = criteria.getValues().get(0);
            String[] parts = ((String)varVal).split(":", 2);
            String varId = parts[1].substring(0, Integer.parseInt(parts[0]));
            String val = parts[1].substring(Integer.parseInt(parts[0]) + 1);
            SingularAttribute<VariableInstanceLog, String> varVarIdField = VariableInstanceLog_.variableId;
            Path varVarIdPath = table.get(varVarIdField);
            SingularAttribute<VariableInstanceLog, String> varValField = VariableInstanceLog_.value;
            Path varValIdPath = table.get(varValField);
            Predicate varIdPredicate = builder.equal((Expression)varVarIdPath, (Object)varId);
            if (QueryWhere.QueryCriteriaType.REGEXP.equals((Object)criteria.getType())) {
                val = AuditQueryCriteriaUtil.convertRegexToJPALikeExpression((String)val);
                valPredicate = builder.like((Expression)varValIdPath, val);
            } else {
                valPredicate = builder.equal((Expression)varValIdPath, (Object)val);
            }
            predicate = builder.and((Expression)varIdPredicate, (Expression)valPredicate);
        } else {
            throw new IllegalStateException("List id [" + (String)QueryParameterIdentifiersUtil.getQueryParameterIdNameMap().get(Integer.parseInt(criteria.getListId())) + "] is not supported for queries on " + table.getJavaType().getSimpleName() + ".");
        }
        return predicate;
    }
}

