/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.drools;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ResultType implements Enumerator
{
    ENUM(0, "enum", "enum"),
    MIN(1, "min", "min"),
    MAX(2, "max", "max"),
    MEAN(3, "mean", "mean"),
    COUNT(4, "count", "count"),
    SUM(5, "sum", "sum");

    public static final int ENUM_VALUE = 0;
    public static final int MIN_VALUE = 1;
    public static final int MAX_VALUE = 2;
    public static final int MEAN_VALUE = 3;
    public static final int COUNT_VALUE = 4;
    public static final int SUM_VALUE = 5;
    private static final ResultType[] VALUES_ARRAY;
    public static final List<ResultType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static ResultType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ResultType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static ResultType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ResultType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static ResultType get(int value) {
        switch (value) {
            case 0: {
                return ENUM;
            }
            case 1: {
                return MIN;
            }
            case 2: {
                return MAX;
            }
            case 3: {
                return MEAN;
            }
            case 4: {
                return COUNT;
            }
            case 5: {
                return SUM;
            }
        }
        return null;
    }

    private ResultType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new ResultType[]{ENUM, MIN, MAX, MEAN, COUNT, SUM};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

