/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.ArrayList;
import java.util.Map;
import org.drools.definition.process.Node;
import org.drools.xml.ExtensibleXmlParser;
import org.jbpm.bpmn2.core.Error;
import org.jbpm.bpmn2.core.Escalation;
import org.jbpm.bpmn2.xml.AbstractNodeHandler;
import org.jbpm.compiler.xml.ProcessBuildData;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.node.EventNode;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BoundaryEventHandler
extends AbstractNodeHandler {
    protected org.jbpm.workflow.core.Node createNode(Attributes attrs) {
        return new EventNode();
    }

    public Class generateNodeFor() {
        return EventNode.class;
    }

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        org.jbpm.workflow.core.Node node = (org.jbpm.workflow.core.Node)parser.getCurrent();
        String attachedTo = element.getAttribute("attachedToRef");
        String cancelActivityString = element.getAttribute("cancelActivity");
        boolean cancelActivity = true;
        if ("false".equals(cancelActivityString)) {
            cancelActivity = false;
        }
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("escalationEventDefinition".equals(nodeName)) {
                this.handleEscalationNode(node, element, uri, localName, parser, attachedTo, cancelActivity);
                break;
            }
            if ("errorEventDefinition".equals(nodeName)) {
                this.handleErrorNode(node, element, uri, localName, parser, attachedTo, cancelActivity);
                break;
            }
            if ("timerEventDefinition".equals(nodeName)) {
                this.handleTimerNode(node, element, uri, localName, parser, attachedTo, cancelActivity);
                break;
            }
            if (!"compensateEventDefinition".equals(nodeName)) continue;
            this.handleCompensationNode(node, element, uri, localName, parser, attachedTo, cancelActivity);
            break;
        }
        NodeContainer nodeContainer = (NodeContainer)parser.getParent();
        nodeContainer.addNode((Node)node);
        return node;
    }

    protected void handleEscalationNode(org.jbpm.workflow.core.Node node, Element element, String uri, String localName, ExtensibleXmlParser parser, String attachedTo, boolean cancelActivity) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        EventNode eventNode = (EventNode)node;
        eventNode.setMetaData("AttachedTo", (Object)attachedTo);
        eventNode.setMetaData("CancelActivity", (Object)cancelActivity);
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String escalationRef;
            String nodeName = xmlNode.getNodeName();
            if (!"escalationEventDefinition".equals(nodeName) || (escalationRef = ((Element)xmlNode).getAttribute("escalationRef")) == null || escalationRef.trim().length() <= 0) continue;
            Map escalations = (Map)((ProcessBuildData)parser.getData()).getMetaData("Escalations");
            if (escalations == null) {
                throw new IllegalArgumentException("No escalations found");
            }
            Escalation escalation = (Escalation)escalations.get(escalationRef);
            if (escalation == null) {
                throw new IllegalArgumentException("Could not find escalation " + escalationRef);
            }
            ArrayList<EventTypeFilter> eventFilters = new ArrayList<EventTypeFilter>();
            EventTypeFilter eventFilter = new EventTypeFilter();
            String type = escalation.getEscalationCode();
            eventFilter.setType("Escalation-" + attachedTo + "-" + type);
            eventFilters.add(eventFilter);
            eventNode.setEventFilters(eventFilters);
            eventNode.setMetaData("EscalationEvent", (Object)type);
        }
    }

    protected void handleErrorNode(org.jbpm.workflow.core.Node node, Element element, String uri, String localName, ExtensibleXmlParser parser, String attachedTo, boolean cancelActivity) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        EventNode eventNode = (EventNode)node;
        eventNode.setMetaData("AttachedTo", (Object)attachedTo);
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String errorRef;
            String nodeName = xmlNode.getNodeName();
            if (!"errorEventDefinition".equals(nodeName) || (errorRef = ((Element)xmlNode).getAttribute("errorRef")) == null || errorRef.trim().length() <= 0) continue;
            Map errors = (Map)((ProcessBuildData)parser.getData()).getMetaData("Errors");
            if (errors == null) {
                throw new IllegalArgumentException("No errors found");
            }
            Error error = (Error)errors.get(errorRef);
            if (error == null) {
                throw new IllegalArgumentException("Could not find error " + errorRef);
            }
            String type = error.getErrorCode();
            ArrayList<EventTypeFilter> eventFilters = new ArrayList<EventTypeFilter>();
            EventTypeFilter eventFilter = new EventTypeFilter();
            eventFilter.setType("Error-" + attachedTo + "-" + type);
            eventFilters.add(eventFilter);
            eventNode.setEventFilters(eventFilters);
            eventNode.setMetaData("ErrorEvent", (Object)type);
        }
    }

    protected void handleTimerNode(org.jbpm.workflow.core.Node node, Element element, String uri, String localName, ExtensibleXmlParser parser, String attachedTo, boolean cancelActivity) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        EventNode eventNode = (EventNode)node;
        eventNode.setMetaData("AttachedTo", (Object)attachedTo);
        eventNode.setMetaData("CancelActivity", (Object)cancelActivity);
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if (!"timerEventDefinition".equals(nodeName)) continue;
            String timeCycle = null;
            org.w3c.dom.Node subNode = xmlNode.getFirstChild();
            while (subNode instanceof Element) {
                String subNodeName = subNode.getNodeName();
                if ("timeCycle".equals(subNodeName)) {
                    timeCycle = subNode.getTextContent();
                    break;
                }
                subNode = subNode.getNextSibling();
            }
            if (timeCycle == null || timeCycle.trim().length() <= 0) continue;
            ArrayList<EventTypeFilter> eventFilters = new ArrayList<EventTypeFilter>();
            EventTypeFilter eventFilter = new EventTypeFilter();
            eventFilter.setType("Timer-" + attachedTo + "-" + timeCycle);
            eventFilters.add(eventFilter);
            eventNode.setEventFilters(eventFilters);
            eventNode.setMetaData("TimeCycle", (Object)timeCycle);
        }
    }

    protected void handleCompensationNode(org.jbpm.workflow.core.Node node, Element element, String uri, String localName, ExtensibleXmlParser parser, String attachedTo, boolean cancelActivity) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        EventNode eventNode = (EventNode)node;
        eventNode.setMetaData("AttachedTo", (Object)attachedTo);
        ArrayList<EventTypeFilter> eventFilters = new ArrayList<EventTypeFilter>();
        EventTypeFilter eventFilter = new EventTypeFilter();
        String eventType = "Compensate-";
        eventFilter.setType(eventType);
        eventFilters.add(eventFilter);
        ((EventNode)node).setEventFilters(eventFilters);
    }

    public void writeNode(org.jbpm.workflow.core.Node node, StringBuilder xmlDump, int metaDataType) {
        throw new IllegalArgumentException("Writing out should be handled by specific handlers");
    }
}

