/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.Map;
import org.drools.compiler.compiler.xml.XmlDumper;
import org.drools.core.xml.ExtensibleXmlParser;
import org.jbpm.bpmn2.xml.AbstractNodeHandler;
import org.jbpm.bpmn2.xml.XmlBPMNProcessDumper;
import org.jbpm.bpmn2.xml.elements.DataAssociationFactory;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.impl.ExtendedNodeImpl;
import org.jbpm.workflow.core.node.RuleSetNode;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BusinessRuleTaskHandler
extends AbstractNodeHandler {
    private static final String NAMESPACE_PROP = "namespace";
    private static final String MODEL_PROP = "model";
    private static final String DECISION_PROP = "decision";
    private static final String DECISION_SERVICE_PROP = "decisionService";

    @Override
    protected Node createNode(Attributes attrs) {
        return new RuleSetNode();
    }

    public Class<?> generateNodeFor() {
        return RuleSetNode.class;
    }

    @Override
    protected void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        String language;
        super.handleNode(node, element, uri, localName, parser);
        RuleSetNode ruleSetNode = (RuleSetNode)node;
        String ruleFlowGroup = element.getAttribute("ruleFlowGroup");
        if (ruleFlowGroup != null) {
            ruleSetNode.setRuleFlowGroup(ruleFlowGroup);
        }
        if ((language = element.getAttribute("implementation")) == null || language.equalsIgnoreCase("##unspecified") || language.isEmpty()) {
            language = "http://www.jboss.org/drools/rule";
        }
        ruleSetNode.setLanguage(language);
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("ioSpecification".equals(nodeName)) {
                this.readIoSpecification(xmlNode, this.dataInputs, this.dataOutputs);
                continue;
            }
            if ("dataInputAssociation".equals(nodeName)) {
                this.readDataInputAssociation(xmlNode, ruleSetNode, this.dataInputs);
                continue;
            }
            if (!"dataOutputAssociation".equals(nodeName)) continue;
            this.readDataOutputAssociation(xmlNode, ruleSetNode, this.dataOutputs);
        }
        ruleSetNode.setNamespace((String)ruleSetNode.removeParameter(NAMESPACE_PROP));
        ruleSetNode.setModel((String)ruleSetNode.removeParameter(MODEL_PROP));
        ruleSetNode.setDecision((String)ruleSetNode.removeParameter(DECISION_PROP));
        ruleSetNode.setDecisionService((String)ruleSetNode.removeParameter(DECISION_SERVICE_PROP));
        this.handleScript((ExtendedNodeImpl)ruleSetNode, element, "onEntry");
        this.handleScript((ExtendedNodeImpl)ruleSetNode, element, "onExit");
    }

    @Override
    public void writeNode(Node node, StringBuilder xmlDump, int metaDataType) {
        RuleSetNode ruleSetNode = (RuleSetNode)node;
        this.writeNode("businessRuleTask", (Node)ruleSetNode, xmlDump, metaDataType);
        if (ruleSetNode.getRuleFlowGroup() != null) {
            xmlDump.append("g:ruleFlowGroup=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(ruleSetNode.getRuleFlowGroup()) + "\" " + EOL);
        }
        xmlDump.append(" implementation=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(ruleSetNode.getLanguage()) + "\" >" + EOL);
        this.writeExtensionElements((Node)ruleSetNode, xmlDump);
        this.writeIO(ruleSetNode, xmlDump);
        this.endNode("businessRuleTask", xmlDump);
    }

    protected void readDataInputAssociation(org.w3c.dom.Node xmlNode, RuleSetNode ruleSetNode, Map<String, String> dataInputs) {
        DataAssociationFactory.readDataInputAssociation(xmlNode, dataInputs, (s, a) -> s == null, arg_0 -> ((RuleSetNode)ruleSetNode).addInAssociation(arg_0), (arg_0, arg_1) -> ((RuleSetNode)ruleSetNode).setParameter(arg_0, arg_1));
    }

    protected void readDataOutputAssociation(org.w3c.dom.Node xmlNode, RuleSetNode ruleSetNode, Map<String, String> dataOutputs) {
        ruleSetNode.addOutAssociation(DataAssociationFactory.readDataOutputAssociation(xmlNode, dataOutputs));
    }

    protected void writeIO(RuleSetNode ruleSetNode, StringBuilder xmlDump) {
        xmlDump.append("      <ioSpecification>" + EOL);
        for (Map.Entry entry : ruleSetNode.getInMappings().entrySet()) {
            xmlDump.append("        <dataInput id=\"" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)ruleSetNode) + "_" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "Input\" name=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "\" />" + EOL);
        }
        for (Map.Entry entry : ruleSetNode.getParameters().entrySet()) {
            if ("ActorId".equals(entry.getKey()) || entry.getValue() == null) continue;
            xmlDump.append("        <dataInput id=\"" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)ruleSetNode) + "_" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "Input\" name=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "\" />" + EOL);
        }
        for (Map.Entry entry : ruleSetNode.getOutMappings().entrySet()) {
            xmlDump.append("        <dataOutput id=\"" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)ruleSetNode) + "_" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "Output\" name=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "\" />" + EOL);
        }
        xmlDump.append("        <inputSet>" + EOL);
        for (Map.Entry entry : ruleSetNode.getInMappings().entrySet()) {
            xmlDump.append("          <dataInputRefs>" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)ruleSetNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Input</dataInputRefs>" + EOL);
        }
        for (Map.Entry entry : ruleSetNode.getParameters().entrySet()) {
            if ("ActorId".equals(entry.getKey()) || entry.getValue() == null) continue;
            xmlDump.append("          <dataInputRefs>" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)ruleSetNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Input</dataInputRefs>" + EOL);
        }
        xmlDump.append("        </inputSet>" + EOL);
        xmlDump.append("        <outputSet>" + EOL);
        for (Map.Entry entry : ruleSetNode.getOutMappings().entrySet()) {
            xmlDump.append("          <dataOutputRefs>" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)ruleSetNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Output</dataOutputRefs>" + EOL);
        }
        xmlDump.append("        </outputSet>" + EOL);
        xmlDump.append("      </ioSpecification>" + EOL);
        for (Map.Entry entry : ruleSetNode.getInMappings().entrySet()) {
            xmlDump.append("      <dataInputAssociation>" + EOL);
            xmlDump.append("        <sourceRef>" + XmlDumper.replaceIllegalChars((String)((String)entry.getValue())) + "</sourceRef>" + EOL + "        <targetRef>" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)ruleSetNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Input</targetRef>" + EOL);
            xmlDump.append("      </dataInputAssociation>" + EOL);
        }
        for (Map.Entry entry : ruleSetNode.getParameters().entrySet()) {
            if ("ActorId".equals(entry.getKey()) || entry.getValue() == null) continue;
            xmlDump.append("      <dataInputAssociation>" + EOL);
            xmlDump.append("        <targetRef>" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)ruleSetNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Input</targetRef>" + EOL + "        <assignment>" + EOL + "          <from xsi:type=\"tFormalExpression\">" + XmlDumper.replaceIllegalChars((String)entry.getValue().toString()) + "</from>" + EOL + "          <to xsi:type=\"tFormalExpression\">" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)ruleSetNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Input</to>" + EOL + "        </assignment>" + EOL);
            xmlDump.append("      </dataInputAssociation>" + EOL);
        }
        for (Map.Entry entry : ruleSetNode.getOutMappings().entrySet()) {
            xmlDump.append("      <dataOutputAssociation>" + EOL);
            xmlDump.append("        <sourceRef>" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)ruleSetNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Output</sourceRef>" + EOL + "        <targetRef>" + XmlDumper.replaceIllegalChars((String)((String)entry.getValue())) + "</targetRef>" + EOL);
            xmlDump.append("      </dataOutputAssociation>" + EOL);
        }
    }
}

