/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xpath;

import java.util.function.BiFunction;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.jbpm.process.instance.impl.AssignmentAction;
import org.jbpm.process.instance.impl.AssignmentProducer;
import org.jbpm.workflow.core.node.Assignment;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XPATHAssignmentAction
implements AssignmentAction {
    private Assignment assignment;
    private AssignmentProducer producer;
    private BiFunction<ProcessContext, NodeInstance, Object> source;
    private BiFunction<ProcessContext, NodeInstance, Object> target;
    private String sourceExpr;
    private String targetExpr;

    public XPATHAssignmentAction(Assignment assignment, String sourceExpr, String targetExpr, BiFunction<ProcessContext, NodeInstance, Object> source, BiFunction<ProcessContext, NodeInstance, Object> target, AssignmentProducer producer) {
        this.assignment = assignment;
        this.sourceExpr = sourceExpr;
        this.targetExpr = targetExpr;
        this.source = source;
        this.target = target;
        this.producer = producer;
    }

    public void execute(NodeInstance nodeInstance, ProcessContext context) throws Exception {
        Node parent;
        String from = this.assignment.getFrom();
        String to = this.assignment.getTo();
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpathFrom = factory.newXPath();
        XPathExpression exprFrom = xpathFrom.compile(from);
        XPath xpathTo = factory.newXPath();
        XPathExpression exprTo = xpathTo.compile(to);
        Object source = this.source.apply(context, nodeInstance);
        Object target = this.target.apply(context, nodeInstance);
        Object targetElem = null;
        if (target != null && (targetElem = exprTo.evaluate(parent = ((Node)target).getParentNode(), XPathConstants.NODE)) == null) {
            throw new RuntimeException("Nothing was selected by the to expression " + to + " on " + this.targetExpr);
        }
        NodeList nl = null;
        if (source instanceof Node) {
            nl = (NodeList)exprFrom.evaluate(source, XPathConstants.NODESET);
        } else if (source instanceof String) {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            Element temp = doc.createElementNS(null, "temp");
            temp.appendChild(doc.createTextNode((String)source));
            nl = temp.getChildNodes();
        } else if (source == null) {
            throw new RuntimeException("Source value was null for source " + this.sourceExpr);
        }
        if (nl == null || nl.getLength() == 0) {
            throw new RuntimeException("Nothing was selected by the from expression " + from + " on " + this.sourceExpr);
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!(targetElem instanceof Node)) {
                if (nl.item(i) instanceof Attr) {
                    targetElem = ((Attr)nl.item(i)).getValue();
                } else if (nl.item(i) instanceof Text) {
                    targetElem = ((Text)nl.item(i)).getWholeText();
                } else {
                    DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    Document doc = builder.newDocument();
                    targetElem = doc.importNode(nl.item(i), true);
                }
                target = targetElem;
                continue;
            }
            Node n = ((Node)targetElem).getOwnerDocument().importNode(nl.item(i), true);
            if (n instanceof Attr) {
                ((Element)targetElem).setAttributeNode((Attr)n);
                continue;
            }
            ((Node)targetElem).appendChild(n);
        }
        this.producer.accept(context, nodeInstance, target);
    }
}

