/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.cmmn.xml;

import java.util.HashSet;
import java.util.Map;
import org.drools.core.xml.BaseAbstractHandler;
import org.drools.core.xml.ExtensibleXmlParser;
import org.drools.core.xml.Handler;
import org.jbpm.casemgmt.cmmn.core.PlanItem;
import org.jbpm.casemgmt.cmmn.core.Sentry;
import org.jbpm.compiler.xml.ProcessBuildData;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SentryHandler
extends BaseAbstractHandler
implements Handler {
    private static final Logger logger = LoggerFactory.getLogger(SentryHandler.class);

    public SentryHandler() {
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet();
            this.validParents.add(RuleFlowProcess.class);
            this.validPeers = new HashSet();
            this.validPeers.add(null);
            this.validPeers.add(PlanItem.class);
            this.validPeers.add(Sentry.class);
            this.allowNesting = false;
        }
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        String id = attrs.getValue("id");
        ProcessBuildData buildData = (ProcessBuildData)parser.getData();
        Map sentries = (Map)buildData.getMetaData("Sentries");
        Sentry sentryStub = (Sentry)sentries.get(id);
        if (sentryStub == null) {
            sentryStub = new Sentry(id, null, null);
            sentries.put(id, sentryStub);
        }
        return sentryStub;
    }

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        Sentry sentry = (Sentry)parser.getCurrent();
        for (Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if (!"ifPart".equals(nodeName)) continue;
            for (Node subNode = xmlNode.getFirstChild(); subNode != null; subNode = subNode.getNextSibling()) {
                String subNodeName = subNode.getNodeName();
                if (!"condition".equals(subNodeName)) continue;
                String language = ((Element)subNode).getAttribute("language");
                String expression = ((Element)subNode).getTextContent();
                sentry.setLanguage(language);
                sentry.setExpression(expression);
            }
        }
        return sentry;
    }

    public Class<?> generateNodeFor() {
        return Sentry.class;
    }
}

