/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.cmmn.xml;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.drools.core.xml.ExtensibleXmlParser;
import org.jbpm.casemgmt.cmmn.core.PlanItem;
import org.jbpm.casemgmt.cmmn.xml.AbstractCaseNodeHandler;
import org.jbpm.compiler.xml.ProcessBuildData;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.node.DynamicNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class StageHandler
extends AbstractCaseNodeHandler {
    private static final Logger logger = LoggerFactory.getLogger(StageHandler.class);
    public static final String AUTOCOMPLETE_COMPLETION_CONDITION = "autocomplete";
    public static final List<String> AUTOCOMPLETE_EXPRESSIONS = Arrays.asList("getActivityInstanceAttribute(\"numberOfActiveInstances\") == 0", "autocomplete");

    @Override
    protected Node createNode(Attributes attrs) {
        DynamicNode result = new DynamicNode();
        VariableScope variableScope = new VariableScope();
        result.addContext((Context)variableScope);
        result.setDefaultContext((Context)variableScope);
        return result;
    }

    public Class generateNodeFor() {
        return DynamicNode.class;
    }

    @Override
    protected void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        DynamicNode stageNode = (DynamicNode)node;
        stageNode.setAutoComplete(false);
        stageNode.setLanguage("rule");
        ProcessBuildData buildData = (ProcessBuildData)parser.getData();
        Map planItems = (Map)buildData.getMetaData("PlanItems");
        PlanItem stagePlanItem = (PlanItem)planItems.get(stageNode.getMetaData("UniqueId"));
        if (stagePlanItem != null && stagePlanItem.getEntryCriterion() != null) {
            if ("autostart".equalsIgnoreCase(stagePlanItem.getEntryCriterion().getExpression())) {
                stageNode.setMetaData("customAutoStart", (Object)"true");
            } else {
                stageNode.setActivationExpression(stagePlanItem.getEntryCriterion().getExpression());
            }
        }
        if (stagePlanItem != null && stagePlanItem.getExitCriterion() != null) {
            if (AUTOCOMPLETE_EXPRESSIONS.contains(stagePlanItem.getExitCriterion().getExpression())) {
                stageNode.setAutoComplete(true);
            } else {
                stageNode.setCompletionExpression(stagePlanItem.getExitCriterion().getExpression());
            }
        }
    }
}

