/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.cmmn.xml;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.xml.ExtensibleXmlParser;
import org.jbpm.casemgmt.cmmn.xml.AbstractCaseNodeHandler;
import org.jbpm.process.core.Work;
import org.jbpm.process.core.impl.WorkImpl;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.node.DataAssociation;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CaseTaskHandler
extends AbstractCaseNodeHandler {
    private static final Logger logger = LoggerFactory.getLogger(CaseTaskHandler.class);

    @Override
    protected Node createNode(Attributes attrs) {
        return new WorkItemNode();
    }

    public Class generateNodeFor() {
        return WorkItemNode.class;
    }

    @Override
    protected void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        String caseDefinitionId = element.getAttribute("caseRef");
        if (caseDefinitionId == null) {
            throw new IllegalArgumentException("Case definition id is mandatory");
        }
        String isBlocking = element.getAttribute("isBlocking");
        if (isBlocking == null || isBlocking.isEmpty()) {
            isBlocking = "true";
        }
        WorkItemNode workItemNode = (WorkItemNode)node;
        WorkImpl work = new WorkImpl();
        work.setName("StartCaseInstance");
        workItemNode.setWork((Work)work);
        HashMap<String, String> inputs = new HashMap<String, String>();
        HashMap<String, String> outputs = new HashMap<String, String>();
        HashMap<String, String> inputTypes = new HashMap<String, String>();
        HashMap<String, String> outputTypes = new HashMap<String, String>();
        this.loadDataInputsAndOutputs(element, inputs, outputs, inputTypes, outputTypes, parser);
        workItemNode.setMetaData("DataInputs", inputTypes);
        workItemNode.setMetaData("DataOutputs", outputTypes);
        workItemNode.getWork().setParameter("CaseDefinitionId", (Object)caseDefinitionId);
        workItemNode.getWork().setParameter("Independent", (Object)isBlocking);
        for (Map.Entry entry : inputs.entrySet()) {
            workItemNode.addInAssociation(new DataAssociation((String)entry.getValue(), "Data_" + (String)entry.getKey(), Collections.emptyList(), null));
        }
        for (Map.Entry entry : outputs.entrySet()) {
            workItemNode.addOutAssociation(new DataAssociation((String)entry.getKey(), (String)entry.getValue(), Collections.emptyList(), null));
        }
    }
}

