/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.drools.core.ClassObjectFilter;
import org.jbpm.casemgmt.api.CaseNotFoundException;
import org.jbpm.casemgmt.api.CaseRuntimeDataService;
import org.jbpm.casemgmt.api.CaseService;
import org.jbpm.casemgmt.api.StageNotFoundException;
import org.jbpm.casemgmt.api.dynamic.TaskSpecification;
import org.jbpm.casemgmt.api.generator.CaseIdGenerator;
import org.jbpm.casemgmt.api.model.CaseDefinition;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.api.model.instance.CaseInstance;
import org.jbpm.casemgmt.api.model.instance.CaseRoleInstance;
import org.jbpm.casemgmt.api.model.instance.CommentInstance;
import org.jbpm.casemgmt.api.model.instance.CommentSortBy;
import org.jbpm.casemgmt.impl.command.AddDataCaseFileInstanceCommand;
import org.jbpm.casemgmt.impl.command.AddDynamicProcessCommand;
import org.jbpm.casemgmt.impl.command.AddDynamicProcessToStageCommand;
import org.jbpm.casemgmt.impl.command.AddDynamicTaskCommand;
import org.jbpm.casemgmt.impl.command.AddDynamicTaskToStageCommand;
import org.jbpm.casemgmt.impl.command.CancelCaseCommand;
import org.jbpm.casemgmt.impl.command.CaseCommentCommand;
import org.jbpm.casemgmt.impl.command.ModifyRoleAssignmentCommand;
import org.jbpm.casemgmt.impl.command.RemoveDataCaseFileInstanceCommand;
import org.jbpm.casemgmt.impl.command.StartCaseCommand;
import org.jbpm.casemgmt.impl.dynamic.HumanTaskSpecification;
import org.jbpm.casemgmt.impl.dynamic.WorkItemTaskSpecification;
import org.jbpm.casemgmt.impl.event.CaseEventSupport;
import org.jbpm.casemgmt.impl.model.instance.CaseFileInstanceImpl;
import org.jbpm.casemgmt.impl.model.instance.CaseInstanceImpl;
import org.jbpm.runtime.manager.impl.PerCaseRuntimeManager;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.kie.api.KieServices;
import org.kie.api.command.Command;
import org.kie.api.command.KieCommands;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.internal.KieInternalServices;
import org.kie.internal.process.CorrelationKeyFactory;
import org.kie.internal.query.QueryContext;
import org.kie.internal.runtime.manager.context.CaseContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseServiceImpl
implements CaseService {
    private static final Logger logger = LoggerFactory.getLogger(CaseServiceImpl.class);
    private CorrelationKeyFactory correlationKeyFactory = KieInternalServices.Factory.get().newCorrelationKeyFactory();
    private KieCommands commandsFactory = KieServices.Factory.get().getCommands();
    private CaseIdGenerator caseIdGenerator;
    private ProcessService processService;
    private RuntimeDataService runtimeDataService;
    private DeploymentService deploymentService;
    private CaseRuntimeDataService caseRuntimeDataService;
    private CaseEventSupport emptyCaseEventSupport = new CaseEventSupport(Collections.emptyList());

    public void setProcessService(ProcessService processService) {
        this.processService = processService;
    }

    public void setRuntimeDataService(RuntimeDataService runtimeDataService) {
        this.runtimeDataService = runtimeDataService;
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    public void setCaseRuntimeDataService(CaseRuntimeDataService caseRuntimeDataService) {
        this.caseRuntimeDataService = caseRuntimeDataService;
    }

    public void setCaseIdGenerator(CaseIdGenerator caseIdGenerator) {
        this.caseIdGenerator = caseIdGenerator;
    }

    public String startCase(String deploymentId, String caseDefinitionId) {
        return this.startCase(deploymentId, caseDefinitionId, null);
    }

    public String startCase(String deploymentId, String caseDefinitionId, CaseFileInstance caseFile) {
        CaseDefinition caseDef = this.caseRuntimeDataService.getCase(deploymentId, caseDefinitionId);
        if (caseDef == null) {
            throw new CaseNotFoundException("Case definition " + caseDefinitionId + " not found");
        }
        String caseId = this.caseIdGenerator.generate(caseDef.getIdentifierPrefix(), caseFile == null ? new HashMap() : caseFile.getData());
        logger.debug("Generated case id {} for case definition id {}", (Object)caseId, (Object)caseDefinitionId);
        if (caseFile == null) {
            caseFile = new CaseFileInstanceImpl(caseId);
            ((CaseFileInstanceImpl)caseFile).setupRoles(caseDef.getCaseRoles());
            logger.debug("CaseFile was not given, creating new empty one.");
        } else {
            ((CaseFileInstanceImpl)caseFile).setCaseId(caseId);
            logger.debug("CaseFile {} was given, associating it with case {}", (Object)caseFile, (Object)caseId);
        }
        this.processService.execute(deploymentId, (Context)CaseContext.get((String)caseId), (Command)new StartCaseCommand(caseId, deploymentId, caseDefinitionId, caseFile, this.processService));
        return caseId;
    }

    public CaseFileInstance getCaseFileInstance(String caseId) throws CaseNotFoundException {
        ProcessInstanceDesc pi = this.verifyCaseIdExists(caseId);
        return this.internalGetCaseFileInstance(caseId, pi);
    }

    public CaseInstance getCaseInstance(String caseId) throws CaseNotFoundException {
        return this.getCaseInstance(caseId, false, false, false, false);
    }

    public CaseInstance getCaseInstance(String caseId, boolean withData, boolean withRoles, boolean withMilestones, boolean withStages) throws CaseNotFoundException {
        ProcessInstanceDesc pi = this.verifyCaseIdExists(caseId);
        if (pi.getState().equals(1)) {
            CaseInstanceImpl caseInstance = new CaseInstanceImpl(caseId, pi.getProcessInstanceDescription(), pi.getProcessId(), pi.getState(), pi.getDeploymentId(), pi.getInitiator(), pi.getDataTimeStamp(), null, pi.getId(), "");
            if (withData) {
                CaseFileInstance caseFile = this.internalGetCaseFileInstance(caseId, pi);
                caseInstance.setCaseFile(caseFile);
            }
            if (withMilestones) {
                Collection milestones = this.caseRuntimeDataService.getCaseInstanceMilestones(caseId, false, new QueryContext(Integer.valueOf(0), Integer.valueOf(100)));
                caseInstance.setCaseMilestones(milestones);
            }
            if (withRoles) {
                Collection<CaseRoleInstance> roles = this.getCaseRoleAssignments(caseId);
                caseInstance.setCaseRoles(roles);
            }
            if (withStages) {
                Collection stages = this.caseRuntimeDataService.getCaseInstanceStages(caseId, true, new QueryContext(Integer.valueOf(0), Integer.valueOf(100)));
                caseInstance.setCaseStages(stages);
            }
            return caseInstance;
        }
        return null;
    }

    public void cancelCase(String caseId) throws CaseNotFoundException {
        logger.debug("About to abort case {}", (Object)caseId);
        ProcessInstanceDesc pi = this.verifyCaseIdExists(caseId);
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)pi.getId()), (Command)new CancelCaseCommand(caseId, this.processService, this.runtimeDataService, false));
    }

    public void destroyCase(String caseId) throws CaseNotFoundException {
        logger.debug("About to destroy permanently case {}", (Object)caseId);
        ProcessInstanceDesc pi = this.verifyCaseIdExists(caseId);
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)pi.getId()), (Command)new CancelCaseCommand(caseId, this.processService, this.runtimeDataService, true));
    }

    public void addDynamicTask(String caseId, TaskSpecification taskSpecification) throws CaseNotFoundException {
        ProcessInstanceDesc pi = this.verifyCaseIdExists(caseId);
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)pi.getId()), (Command)new AddDynamicTaskCommand(caseId, taskSpecification.getNodeType(), pi.getId(), taskSpecification.getParameters()));
    }

    public void addDynamicTask(Long processInstanceId, TaskSpecification taskSpecification) throws ProcessInstanceNotFoundException {
        ProcessInstanceDesc pi = this.runtimeDataService.getProcessInstanceById(processInstanceId.longValue());
        if (pi == null || !pi.getState().equals(1)) {
            throw new ProcessInstanceNotFoundException("No process instance found with id " + processInstanceId + " or it's not active anymore");
        }
        String caseId = pi.getCorrelationKey();
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)processInstanceId), (Command)new AddDynamicTaskCommand(caseId, taskSpecification.getNodeType(), pi.getId(), taskSpecification.getParameters()));
    }

    public void addDynamicTaskToStage(String caseId, String stageId, TaskSpecification taskSpecification) throws CaseNotFoundException, StageNotFoundException {
        ProcessInstanceDesc pi = this.verifyCaseIdExists(caseId);
        if (pi == null || !pi.getState().equals(1)) {
            throw new ProcessInstanceNotFoundException("No process instance found with id " + pi.getId() + " or it's not active anymore");
        }
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)pi.getId()), (Command)new AddDynamicTaskToStageCommand(caseId, taskSpecification.getNodeType(), pi.getId(), stageId, taskSpecification.getParameters()));
    }

    public void addDynamicTaskToStage(Long processInstanceId, String stageId, TaskSpecification taskSpecification) throws CaseNotFoundException, StageNotFoundException {
        ProcessInstanceDesc pi = this.runtimeDataService.getProcessInstanceById(processInstanceId.longValue());
        if (pi == null || !pi.getState().equals(1)) {
            throw new ProcessInstanceNotFoundException("No process instance found with id " + processInstanceId + " or it's not active anymore");
        }
        String caseId = pi.getCorrelationKey();
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)processInstanceId), (Command)new AddDynamicTaskToStageCommand(caseId, taskSpecification.getNodeType(), pi.getId(), stageId, taskSpecification.getParameters()));
    }

    public void addDynamicSubprocess(String caseId, String processId, Map<String, Object> parameters) throws CaseNotFoundException {
        ProcessInstanceDesc pi = this.verifyCaseIdExists(caseId);
        if (pi == null || !pi.getState().equals(1)) {
            throw new ProcessInstanceNotFoundException("No process instance found with id " + pi.getId() + " or it's not active anymore");
        }
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)pi.getId()), (Command)new AddDynamicProcessCommand(caseId, pi.getId(), processId, parameters));
    }

    public void addDynamicSubprocess(Long processInstanceId, String processId, Map<String, Object> parameters) throws CaseNotFoundException {
        ProcessInstanceDesc pi = this.runtimeDataService.getProcessInstanceById(processInstanceId.longValue());
        if (pi == null || !pi.getState().equals(1)) {
            throw new ProcessInstanceNotFoundException("No process instance found with id " + processInstanceId + " or it's not active anymore");
        }
        String caseId = pi.getCorrelationKey();
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)processInstanceId), (Command)new AddDynamicProcessCommand(caseId, pi.getId(), processId, parameters));
    }

    public void addDynamicSubprocessToStage(String caseId, String stageId, String processId, Map<String, Object> parameters) throws CaseNotFoundException {
        ProcessInstanceDesc pi = this.verifyCaseIdExists(caseId);
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)pi.getId()), (Command)new AddDynamicProcessToStageCommand(caseId, pi.getId(), stageId, processId, parameters));
    }

    public void addDynamicSubprocessToStage(Long processInstanceId, String stageId, String processId, Map<String, Object> parameters) throws CaseNotFoundException {
        ProcessInstanceDesc pi = this.runtimeDataService.getProcessInstanceById(processInstanceId.longValue());
        if (pi == null || !pi.getState().equals(1)) {
            throw new ProcessInstanceNotFoundException("No process instance found with id " + processInstanceId + " or it's not active anymore");
        }
        String caseId = pi.getCorrelationKey();
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)processInstanceId), (Command)new AddDynamicProcessToStageCommand(caseId, pi.getId(), stageId, processId, parameters));
    }

    public void triggerAdHocFragment(String caseId, String fragmentName, Object data) throws CaseNotFoundException {
        ProcessInstanceDesc pi = this.verifyCaseIdExists(caseId);
        this.triggerAdHocFragment(pi.getId(), fragmentName, data);
    }

    public void triggerAdHocFragment(Long processInstanceId, String fragmentName, Object data) throws CaseNotFoundException {
        this.processService.signalProcessInstance(processInstanceId, fragmentName, data);
    }

    public void addDataToCaseFile(String caseId, String name, Object value) throws CaseNotFoundException {
        ProcessInstanceDesc pi = this.verifyCaseIdExists(caseId);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(name, value);
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)pi.getId()), (Command)new AddDataCaseFileInstanceCommand(parameters));
    }

    public void addDataToCaseFile(String caseId, Map<String, Object> data) throws CaseNotFoundException {
        ProcessInstanceDesc pi = this.verifyCaseIdExists(caseId);
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)pi.getId()), (Command)new AddDataCaseFileInstanceCommand(data));
    }

    public void removeDataFromCaseFile(String caseId, String name) throws CaseNotFoundException {
        ProcessInstanceDesc pi = this.verifyCaseIdExists(caseId);
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)pi.getId()), (Command)new RemoveDataCaseFileInstanceCommand(Arrays.asList(name)));
    }

    public void removeDataFromCaseFile(String caseId, List<String> variableNames) throws CaseNotFoundException {
        ProcessInstanceDesc pi = this.verifyCaseIdExists(caseId);
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)pi.getId()), (Command)new RemoveDataCaseFileInstanceCommand(variableNames));
    }

    public void assignToCaseRole(String caseId, String role, OrganizationalEntity entity) throws CaseNotFoundException {
        ProcessInstanceDesc pi = this.verifyCaseIdExists(caseId);
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)pi.getId()), (Command)new ModifyRoleAssignmentCommand(role, entity, true));
    }

    public void removeFromCaseRole(String caseId, String role, OrganizationalEntity entity) throws CaseNotFoundException {
        ProcessInstanceDesc pi = this.verifyCaseIdExists(caseId);
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)pi.getId()), (Command)new ModifyRoleAssignmentCommand(role, entity, false));
    }

    public Collection<CaseRoleInstance> getCaseRoleAssignments(String caseId) throws CaseNotFoundException {
        ProcessInstanceDesc pi = this.verifyCaseIdExists(caseId);
        CaseFileInstance caseFile = this.internalGetCaseFileInstance(caseId, pi);
        return ((CaseFileInstanceImpl)caseFile).getAssignments();
    }

    public Collection<CommentInstance> getCaseComments(String caseId, QueryContext queryContext) throws CaseNotFoundException {
        ProcessInstanceDesc pi = this.verifyCaseIdExists(caseId);
        CaseFileInstance caseFile = this.internalGetCaseFileInstance(caseId, pi);
        return ((CaseFileInstanceImpl)caseFile).getComments();
    }

    public Collection<CommentInstance> getCaseComments(String caseId, CommentSortBy sortBy, QueryContext queryContext) throws CaseNotFoundException {
        Collection<CommentInstance> comments = this.getCaseComments(caseId, queryContext);
        return comments.stream().sorted((o1, o2) -> {
            int result = 0;
            switch (sortBy) {
                case Date: {
                    result = o1.getCreatedAt().compareTo(o2.getCreatedAt());
                    break;
                }
                case Author: {
                    result = o1.getAuthor().compareTo(o2.getAuthor());
                }
            }
            return result;
        }).collect(Collectors.toList());
    }

    public void addCaseComment(String caseId, String author, String comment) throws CaseNotFoundException {
        ProcessInstanceDesc pi = this.verifyCaseIdExists(caseId);
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)pi.getId()), (Command)new CaseCommentCommand(author, comment));
    }

    public void updateCaseComment(String caseId, String commentId, String author, String text) throws CaseNotFoundException {
        ProcessInstanceDesc pi = this.verifyCaseIdExists(caseId);
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)pi.getId()), (Command)new CaseCommentCommand(commentId, author, text));
    }

    public void removeCaseComment(String caseId, String commentId) throws CaseNotFoundException {
        ProcessInstanceDesc pi = this.verifyCaseIdExists(caseId);
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)pi.getId()), (Command)new CaseCommentCommand(commentId));
    }

    public CaseFileInstance newCaseFileInstance(String deploymentId, String caseDefinition, Map<String, Object> data) {
        CaseDefinition def = this.caseRuntimeDataService.getCase(deploymentId, caseDefinition);
        CaseFileInstanceImpl caseFile = new CaseFileInstanceImpl(data);
        caseFile.setupRoles(def.getCaseRoles());
        return caseFile;
    }

    public CaseFileInstance newCaseFileInstance(String deploymentId, String caseDefinition, Map<String, Object> data, Map<String, OrganizationalEntity> rolesAssignment) {
        CaseDefinition def = this.caseRuntimeDataService.getCase(deploymentId, caseDefinition);
        CaseFileInstanceImpl caseFile = new CaseFileInstanceImpl(data);
        caseFile.setupRoles(def.getCaseRoles());
        rolesAssignment.entrySet().stream().forEach(entry -> caseFile.assign((String)entry.getKey(), (OrganizationalEntity)entry.getValue()));
        return caseFile;
    }

    public TaskSpecification newHumanTaskSpec(String taskName, String description, String actorIds, String groupIds, Map<String, Object> parameters) {
        return new HumanTaskSpecification(taskName, actorIds, groupIds, description, parameters);
    }

    public TaskSpecification newTaskSpec(String nodeType, String nodeName, Map<String, Object> parameters) {
        return new WorkItemTaskSpecification(nodeType, nodeName, parameters);
    }

    protected CaseFileInstance internalGetCaseFileInstance(String caseId, ProcessInstanceDesc pi) {
        logger.debug("Retrieving case file from working memory for case " + caseId);
        Collection caseFiles = (Collection)this.processService.execute(pi.getDeploymentId(), (Context)CaseContext.get((String)caseId), this.commandsFactory.newGetObjects((ObjectFilter)new ClassObjectFilter(CaseFileInstance.class)));
        if (caseFiles.size() == 1) {
            CaseFileInstance caseFile = (CaseFileInstance)caseFiles.iterator().next();
            logger.debug("Single case file {} found in working memory", (Object)caseFile);
            return caseFile;
        }
        logger.warn("Multiple case files found in working memory (most likely not using PER_CASE strategy), trying to filter out...");
        CaseFileInstance caseFile = caseFiles.stream().filter(cf -> cf.getCaseId().equals(caseId)).findFirst().orElse(null);
        logger.warn("Case file {} after filtering {}", (Object)caseFile, (Object)(caseFile == null ? "not found" : "found"));
        return caseFile;
    }

    protected ProcessInstanceDesc verifyCaseIdExists(String caseId) throws CaseNotFoundException {
        ProcessInstanceDesc pi = this.runtimeDataService.getProcessInstanceByCorrelationKey(this.correlationKeyFactory.newCorrelationKey(caseId));
        if (pi == null) {
            throw new CaseNotFoundException("Case with id " + caseId + " was not found");
        }
        return pi;
    }

    protected CaseEventSupport getCaseEventSupport(String deploymentId) {
        CaseEventSupport caseEventSupport;
        RuntimeManager runtimeManager = this.deploymentService.getRuntimeManager(deploymentId);
        if (runtimeManager instanceof PerCaseRuntimeManager && (caseEventSupport = (CaseEventSupport)((PerCaseRuntimeManager)runtimeManager).getCaseEventSupport()) != null) {
            return caseEventSupport;
        }
        return this.emptyCaseEventSupport;
    }
}

