/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.event;

import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.core.event.AbstractEventSupport;
import org.jbpm.casemgmt.api.event.CaseCancelEvent;
import org.jbpm.casemgmt.api.event.CaseCommentEvent;
import org.jbpm.casemgmt.api.event.CaseDataEvent;
import org.jbpm.casemgmt.api.event.CaseDestroyEvent;
import org.jbpm.casemgmt.api.event.CaseDynamicSubprocessEvent;
import org.jbpm.casemgmt.api.event.CaseDynamicTaskEvent;
import org.jbpm.casemgmt.api.event.CaseEventListener;
import org.jbpm.casemgmt.api.event.CaseRoleAssignmentEvent;
import org.jbpm.casemgmt.api.event.CaseStartEvent;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.api.model.instance.CommentInstance;
import org.kie.api.task.model.OrganizationalEntity;

public class CaseEventSupport
extends AbstractEventSupport<CaseEventListener> {
    public CaseEventSupport(List<CaseEventListener> caseEventListeners) {
        if (caseEventListeners != null) {
            caseEventListeners.forEach(cvl -> this.addEventListener((EventListener)cvl));
        }
    }

    public void fireBeforeCaseStarted(String caseId, String deploymentId, String caseDefinitionId, CaseFileInstance caseFile) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            CaseStartEvent event = new CaseStartEvent(caseId, deploymentId, caseDefinitionId, caseFile);
            do {
                ((CaseEventListener)iter.next()).beforeCaseStarted(event);
            } while (iter.hasNext());
        }
    }

    public void fireAfterCaseStarted(String caseId, String deploymentId, String caseDefinitionId, CaseFileInstance caseFile, long processInstanceId) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            CaseStartEvent event = new CaseStartEvent(caseId, deploymentId, caseDefinitionId, caseFile, Long.valueOf(processInstanceId));
            do {
                ((CaseEventListener)iter.next()).afterCaseStarted(event);
            } while (iter.hasNext());
        }
    }

    public void fireBeforeCaseCancelled(String caseId, List<Long> processInstanceIds) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            CaseCancelEvent event = new CaseCancelEvent(caseId, processInstanceIds);
            do {
                ((CaseEventListener)iter.next()).beforeCaseCancelled(event);
            } while (iter.hasNext());
        }
    }

    public void fireAfterCaseCancelled(String caseId, List<Long> processInstanceIds) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            CaseCancelEvent event = new CaseCancelEvent(caseId, processInstanceIds);
            do {
                ((CaseEventListener)iter.next()).afterCaseCancelled(event);
            } while (iter.hasNext());
        }
    }

    public void fireBeforeCaseDestroyed(String caseId, List<Long> processInstanceIds) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            CaseDestroyEvent event = new CaseDestroyEvent(caseId, processInstanceIds);
            do {
                ((CaseEventListener)iter.next()).beforeCaseDestroyed(event);
            } while (iter.hasNext());
        }
    }

    public void fireAfterCaseDestroyed(String caseId, List<Long> processInstanceIds) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            CaseDestroyEvent event = new CaseDestroyEvent(caseId, processInstanceIds);
            do {
                ((CaseEventListener)iter.next()).afterCaseDestroyed(event);
            } while (iter.hasNext());
        }
    }

    public void fireBeforeCaseCommentAdded(String caseId, CommentInstance commentInstance) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            CaseCommentEvent event = new CaseCommentEvent(caseId, commentInstance);
            do {
                ((CaseEventListener)iter.next()).beforeCaseCommentAdded(event);
            } while (iter.hasNext());
        }
    }

    public void fireAfterCaseCommentAdded(String caseId, CommentInstance commentInstance) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            CaseCommentEvent event = new CaseCommentEvent(caseId, commentInstance);
            do {
                ((CaseEventListener)iter.next()).beforeCaseCommentAdded(event);
            } while (iter.hasNext());
        }
    }

    public void fireBeforeCaseCommentUpdated(String caseId, CommentInstance commentInstance) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            CaseCommentEvent event = new CaseCommentEvent(caseId, commentInstance);
            do {
                ((CaseEventListener)iter.next()).beforeCaseCommentUpdated(event);
            } while (iter.hasNext());
        }
    }

    public void fireAfterCaseCommentUpdated(String caseId, CommentInstance commentInstance) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            CaseCommentEvent event = new CaseCommentEvent(caseId, commentInstance);
            do {
                ((CaseEventListener)iter.next()).beforeCaseCommentUpdated(event);
            } while (iter.hasNext());
        }
    }

    public void fireBeforeCaseCommentRemoved(String caseId, CommentInstance commentInstance) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            CaseCommentEvent event = new CaseCommentEvent(caseId, commentInstance);
            do {
                ((CaseEventListener)iter.next()).beforeCaseCommentRemoved(event);
            } while (iter.hasNext());
        }
    }

    public void fireAfterCaseCommentRemoved(String caseId, CommentInstance commentInstance) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            CaseCommentEvent event = new CaseCommentEvent(caseId, commentInstance);
            do {
                ((CaseEventListener)iter.next()).beforeCaseCommentRemoved(event);
            } while (iter.hasNext());
        }
    }

    public void fireBeforeCaseRoleAssignmentAdded(String caseId, String role, OrganizationalEntity entity) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            CaseRoleAssignmentEvent event = new CaseRoleAssignmentEvent(caseId, role, entity);
            do {
                ((CaseEventListener)iter.next()).beforeCaseRoleAssignmentAdded(event);
            } while (iter.hasNext());
        }
    }

    public void fireAfterCaseRoleAssignmentAdded(String caseId, String role, OrganizationalEntity entity) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            CaseRoleAssignmentEvent event = new CaseRoleAssignmentEvent(caseId, role, entity);
            do {
                ((CaseEventListener)iter.next()).afterCaseRoleAssignmentAdded(event);
            } while (iter.hasNext());
        }
    }

    public void fireBeforeCaseRoleAssignmentRemoved(String caseId, String role, OrganizationalEntity entity) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            CaseRoleAssignmentEvent event = new CaseRoleAssignmentEvent(caseId, role, entity);
            do {
                ((CaseEventListener)iter.next()).beforeCaseRoleAssignmentRemoved(event);
            } while (iter.hasNext());
        }
    }

    public void fireAfterCaseRoleAssignmentRemoved(String caseId, String role, OrganizationalEntity entity) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            CaseRoleAssignmentEvent event = new CaseRoleAssignmentEvent(caseId, role, entity);
            do {
                ((CaseEventListener)iter.next()).afterCaseRoleAssignmentRemoved(event);
            } while (iter.hasNext());
        }
    }

    public void fireBeforeCaseDataAdded(String caseId, Map<String, Object> data) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            CaseDataEvent event = new CaseDataEvent(caseId, data);
            do {
                ((CaseEventListener)iter.next()).beforeCaseDataAdded(event);
            } while (iter.hasNext());
        }
    }

    public void fireAfterCaseDataAdded(String caseId, Map<String, Object> data) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            CaseDataEvent event = new CaseDataEvent(caseId, data);
            do {
                ((CaseEventListener)iter.next()).afterCaseDataAdded(event);
            } while (iter.hasNext());
        }
    }

    public void fireBeforeCaseDataRemoved(String caseId, Map<String, Object> data) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            CaseDataEvent event = new CaseDataEvent(caseId, data);
            do {
                ((CaseEventListener)iter.next()).beforeCaseDataRemoved(event);
            } while (iter.hasNext());
        }
    }

    public void fireAfterCaseDataRemoved(String caseId, Map<String, Object> data) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            CaseDataEvent event = new CaseDataEvent(caseId, data);
            do {
                ((CaseEventListener)iter.next()).afterCaseDataRemoved(event);
            } while (iter.hasNext());
        }
    }

    public void fireBeforeDynamicTaskAdded(String caseId, long processInstanceId, String nodeType, Map<String, Object> parameters) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            CaseDynamicTaskEvent event = new CaseDynamicTaskEvent(caseId, nodeType, parameters, processInstanceId);
            do {
                ((CaseEventListener)iter.next()).beforeDynamicTaskAdded(event);
            } while (iter.hasNext());
        }
    }

    public void fireAfterDynamicTaskAdded(String caseId, long processInstanceId, String nodeType, Map<String, Object> parameters) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            CaseDynamicTaskEvent event = new CaseDynamicTaskEvent(caseId, nodeType, parameters, processInstanceId);
            do {
                ((CaseEventListener)iter.next()).afterDynamicTaskAdded(event);
            } while (iter.hasNext());
        }
    }

    public void fireBeforeDynamicProcessAdded(String caseId, long processInstanceId, String processId, Map<String, Object> parameters) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            CaseDynamicSubprocessEvent event = new CaseDynamicSubprocessEvent(caseId, processId, parameters, processInstanceId);
            do {
                ((CaseEventListener)iter.next()).beforeDynamicProcessAdded(event);
            } while (iter.hasNext());
        }
    }

    public void fireAfterDynamicProcessAdded(String caseId, long processInstanceId, String processId, Map<String, Object> parameters, long subProcessInstanceId) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            CaseDynamicSubprocessEvent event = new CaseDynamicSubprocessEvent(caseId, processId, parameters, processInstanceId, subProcessInstanceId);
            do {
                ((CaseEventListener)iter.next()).afterDynamicProcessAdded(event);
            } while (iter.hasNext());
        }
    }

    public void reset() {
        this.clear();
    }
}

