/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.command;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jbpm.casemgmt.api.CaseNotFoundException;
import org.jbpm.casemgmt.impl.command.CaseCommand;
import org.jbpm.casemgmt.impl.event.CaseEventSupport;
import org.jbpm.runtime.manager.impl.PerCaseRuntimeManager;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.RuntimeDataService;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.query.QueryContext;
import org.kie.internal.KieInternalServices;
import org.kie.internal.command.Context;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.process.CorrelationKeyFactory;
import org.kie.internal.runtime.manager.context.CaseContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CancelCaseCommand
extends CaseCommand<Void> {
    private static final long serialVersionUID = 6811181095390934149L;
    private static final Logger logger = LoggerFactory.getLogger(CancelCaseCommand.class);
    private static CorrelationKeyFactory correlationKeyFactory = KieInternalServices.Factory.get().newCorrelationKeyFactory();
    private String caseId;
    private transient ProcessService processService;
    private transient RuntimeDataService runtimeDataService;
    private boolean destroy;

    public CancelCaseCommand(String caseId, ProcessService processService, RuntimeDataService runtimeDataService, boolean destroy) {
        this.caseId = caseId;
        this.processService = processService;
        this.runtimeDataService = runtimeDataService;
        this.destroy = destroy;
    }

    public Void execute(Context context) {
        RuntimeManager runtimeManager;
        CorrelationKey correlationKey = correlationKeyFactory.newCorrelationKey(this.caseId);
        Collection caseProcesses = this.runtimeDataService.getProcessInstancesByCorrelationKey(correlationKey, new QueryContext(Integer.valueOf(0), Integer.valueOf(1000)));
        if (caseProcesses.isEmpty()) {
            throw new CaseNotFoundException("Case with id " + this.caseId + " was not found");
        }
        List<Long> processInstanceIds = caseProcesses.stream().filter(pi -> pi.getState().equals(1)).sorted((o1, o2) -> Long.valueOf(o2.getParentId()).compareTo((long)o1.getParentId())).map(pi -> pi.getId()).collect(Collectors.toList());
        CaseEventSupport caseEventSupport = this.getCaseEventSupport(context);
        caseEventSupport.fireBeforeCaseCancelled(this.caseId, processInstanceIds);
        logger.debug("Case {} consists of following process instances (ids) {}", (Object)this.caseId, processInstanceIds);
        this.processService.abortProcessInstances(processInstanceIds);
        caseEventSupport.fireAfterCaseCancelled(this.caseId, processInstanceIds);
        if (this.destroy && (runtimeManager = this.getRuntimeManager(context)) instanceof PerCaseRuntimeManager) {
            caseEventSupport.fireBeforeCaseDestroyed(this.caseId, processInstanceIds);
            logger.debug("Case {} aborted, destroying case data including per case runtime engine (including working memory)", (Object)this.caseId);
            ((PerCaseRuntimeManager)runtimeManager).destroyCase(CaseContext.get((String)this.caseId));
            caseEventSupport.fireAfterCaseDestroyed(this.caseId, processInstanceIds);
        }
        return null;
    }

    public void setProcessService(ProcessService processService) {
        this.processService = processService;
    }
}

