/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.command;

import java.util.Collection;
import org.drools.core.ClassObjectFilter;
import org.drools.core.command.impl.RegistryContext;
import org.jbpm.casemgmt.api.CaseCommentNotFoundException;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.api.model.instance.CommentInstance;
import org.jbpm.casemgmt.impl.command.CaseCommand;
import org.jbpm.casemgmt.impl.event.CaseEventSupport;
import org.jbpm.casemgmt.impl.model.instance.CaseFileInstanceImpl;
import org.jbpm.casemgmt.impl.model.instance.CommentInstanceImpl;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.identity.IdentityProvider;

public class CaseCommentCommand
extends CaseCommand<Void> {
    private static final long serialVersionUID = 6345222909719335923L;
    private String author;
    private String comment;
    private boolean add;
    private boolean update;
    private boolean remove;
    private String commentId;
    private String updatedText;

    public CaseCommentCommand(IdentityProvider identityProvider, String author, String comment) {
        super(identityProvider);
        this.author = author;
        this.comment = comment;
        this.add = true;
    }

    public CaseCommentCommand(IdentityProvider identityProvider, String commentId) {
        super(identityProvider);
        this.commentId = commentId;
        this.remove = true;
    }

    public CaseCommentCommand(IdentityProvider identityProvider, String commentId, String author, String updatedText) {
        super(identityProvider);
        this.commentId = commentId;
        this.author = author;
        this.updatedText = updatedText;
        this.update = true;
    }

    public Void execute(Context context) {
        KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        Collection caseFiles = ksession.getObjects((ObjectFilter)new ClassObjectFilter(CaseFileInstance.class));
        if (caseFiles.size() != 1) {
            throw new IllegalStateException("Not able to find distinct case file - found case files " + caseFiles.size());
        }
        CaseFileInstance caseFile = (CaseFileInstance)caseFiles.iterator().next();
        FactHandle factHandle = ksession.getFactHandle((Object)caseFile);
        CaseEventSupport caseEventSupport = this.getCaseEventSupport(context);
        if (this.add) {
            CommentInstanceImpl commentInstance = new CommentInstanceImpl(this.author, this.comment);
            caseEventSupport.fireBeforeCaseCommentAdded(caseFile.getCaseId(), commentInstance);
            ((CaseFileInstanceImpl)caseFile).addComment(commentInstance);
            caseEventSupport.fireAfterCaseCommentAdded(caseFile.getCaseId(), commentInstance);
        } else if (this.update) {
            CommentInstance toUpdate = ((CaseFileInstanceImpl)caseFile).getComments().stream().filter(c -> c.getId().equals(this.commentId)).findFirst().orElseThrow(() -> new CaseCommentNotFoundException("Cannot find comment with id " + this.commentId));
            if (!this.author.equals(toUpdate.getAuthor())) {
                throw new IllegalStateException("Only original author can update comment");
            }
            caseEventSupport.fireBeforeCaseCommentUpdated(caseFile.getCaseId(), toUpdate);
            ((CommentInstanceImpl)toUpdate).setComment(this.updatedText);
            caseEventSupport.fireBeforeCaseCommentUpdated(caseFile.getCaseId(), toUpdate);
        } else if (this.remove) {
            CommentInstance toRemove = ((CaseFileInstanceImpl)caseFile).getComments().stream().filter(c -> c.getId().equals(this.commentId)).findFirst().orElseThrow(() -> new CaseCommentNotFoundException("Cannot find comment with id " + this.commentId));
            caseEventSupport.fireBeforeCaseCommentRemoved(caseFile.getCaseId(), toRemove);
            ((CaseFileInstanceImpl)caseFile).removeComment(toRemove);
            caseEventSupport.fireBeforeCaseCommentRemoved(caseFile.getCaseId(), toRemove);
        }
        ksession.update(factHandle, (Object)caseFile);
        return null;
    }
}

