/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.command;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.drools.core.ClassObjectFilter;
import org.drools.core.command.impl.RegistryContext;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.impl.command.CaseCommand;
import org.jbpm.casemgmt.impl.event.CaseEventSupport;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.identity.IdentityProvider;

public class RemoveDataCaseFileInstanceCommand
extends CaseCommand<Void> {
    private static final long serialVersionUID = 6345222909719335953L;
    private List<String> variableNames;

    public RemoveDataCaseFileInstanceCommand(IdentityProvider identityProvider, List<String> variableNames) {
        super(identityProvider);
        this.variableNames = variableNames;
    }

    public Void execute(Context context) {
        KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        Collection caseFiles = ksession.getObjects((ObjectFilter)new ClassObjectFilter(CaseFileInstance.class));
        if (caseFiles.size() != 1) {
            throw new IllegalStateException("Not able to find distinct case file - found case files " + caseFiles.size());
        }
        CaseFileInstance caseFile = (CaseFileInstance)caseFiles.iterator().next();
        FactHandle factHandle = ksession.getFactHandle((Object)caseFile);
        HashMap<String, Object> remove = new HashMap<String, Object>();
        this.variableNames.forEach(p -> remove.put((String)p, caseFile.getData(p)));
        CaseEventSupport caseEventSupport = this.getCaseEventSupport(context);
        caseEventSupport.fireBeforeCaseDataRemoved(caseFile.getCaseId(), caseFile.getDefinitionId(), remove);
        this.variableNames.forEach(p -> caseFile.remove(p));
        caseEventSupport.fireAfterCaseDataRemoved(caseFile.getCaseId(), caseFile.getDefinitionId(), remove);
        ksession.update(factHandle, (Object)caseFile);
        return null;
    }
}

