/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.event.ProcessEventSupport;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.impl.command.CaseCommand;
import org.jbpm.casemgmt.impl.event.CaseEventSupport;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.services.api.ProcessService;
import org.kie.api.KieServices;
import org.kie.api.command.BatchExecutionCommand;
import org.kie.api.command.Command;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.command.KieCommands;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.DefaultAgendaEventListener;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.KieInternalServices;
import org.kie.internal.command.RegistryContext;
import org.kie.internal.identity.IdentityProvider;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.process.CorrelationKeyFactory;
import org.kie.internal.runtime.manager.context.CaseContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartCaseCommand
extends CaseCommand<Void> {
    private static final long serialVersionUID = 6811181095390934146L;
    private static final Logger logger = LoggerFactory.getLogger(StartCaseCommand.class);
    private static CorrelationKeyFactory correlationKeyFactory = KieInternalServices.Factory.get().newCorrelationKeyFactory();
    private static KieCommands commandsFactory = KieServices.Factory.get().getCommands();
    private String caseId;
    private String deploymentId;
    private String caseDefinitionId;
    private CaseFileInstance caseFile;
    private transient ProcessService processService;

    public StartCaseCommand(IdentityProvider identityProvider, String caseId, String deploymentId, String caseDefinitionId, CaseFileInstance caseFile, ProcessService processService) {
        super(identityProvider);
        this.caseId = caseId;
        this.deploymentId = deploymentId;
        this.caseDefinitionId = caseDefinitionId;
        this.caseFile = caseFile;
        this.processService = processService;
    }

    public Void execute(org.kie.api.runtime.Context context) {
        CaseEventSupport caseEventSupport = this.getCaseEventSupport(context);
        caseEventSupport.fireBeforeCaseStarted(this.caseId, this.deploymentId, this.caseDefinitionId, this.caseFile);
        final HashMap capturedEvents = new HashMap();
        logger.debug("Inserting case file into working memory");
        ArrayList<1> commands = new ArrayList<1>();
        commands.add(new ExecutableCommand<Void>(){
            private static final long serialVersionUID = 8516665043577142587L;

            public Void execute(org.kie.api.runtime.Context context) {
                KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
                ksession.addEventListener((AgendaEventListener)new DefaultAgendaEventListener(){

                    public void matchCreated(MatchCreatedEvent event) {
                        String ruleName;
                        String ruleFlowGroup = ((RuleImpl)event.getMatch().getRule()).getRuleFlowGroup();
                        if ("DROOLS_SYSTEM".equals(ruleFlowGroup) && (ruleName = event.getMatch().getRule().getName()).startsWith("RuleFlow-AdHocActivate-")) {
                            ArrayList<MatchCreatedEvent> events = (ArrayList<MatchCreatedEvent>)capturedEvents.get(ruleName);
                            if (events == null) {
                                events = new ArrayList<MatchCreatedEvent>();
                                capturedEvents.put(ruleName, events);
                            }
                            events.add(event);
                        }
                    }
                });
                return null;
            }
        });
        commands.add(commandsFactory.newInsert((Object)this.caseFile));
        commands.add(commandsFactory.newFireAllRules());
        BatchExecutionCommand batch = commandsFactory.newBatchExecution(commands);
        this.processService.execute(this.deploymentId, (Context)CaseContext.get((String)this.caseId), (Command)batch);
        logger.debug("Starting process instance for case {} and case definition {}", (Object)this.caseId, (Object)this.caseDefinitionId);
        CorrelationKey correlationKey = correlationKeyFactory.newCorrelationKey(this.caseId);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("CaseId", this.caseId);
        final long processInstanceId = this.processService.startProcess(this.deploymentId, this.caseDefinitionId, correlationKey, params);
        logger.debug("Case {} successfully started (process instance id {})", (Object)this.caseId, (Object)processInstanceId);
        final Map caseData = this.caseFile.getData();
        this.processService.execute(this.deploymentId, (Context)CaseContext.get((String)this.caseId), (Command)new ExecutableCommand<Void>(){
            private static final long serialVersionUID = -7093369406457484236L;

            public Void execute(org.kie.api.runtime.Context context) {
                KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
                ProcessInstance pi = ksession.getProcessInstance(processInstanceId);
                if (pi != null) {
                    for (Map.Entry entry : capturedEvents.entrySet()) {
                        for (Object event : (List)entry.getValue()) {
                            pi.signalEvent((String)entry.getKey(), event);
                        }
                    }
                    if (caseData == null) {
                        return null;
                    }
                    ProcessEventSupport processEventSupport = ((InternalProcessRuntime)((InternalKnowledgeRuntime)ksession).getProcessRuntime()).getProcessEventSupport();
                    for (Map.Entry entry : caseData.entrySet()) {
                        String name = "caseFile_" + (String)entry.getKey();
                        processEventSupport.fireAfterVariableChanged(name, name, null, entry.getValue(), pi, (KieRuntime)ksession);
                    }
                }
                return null;
            }
        });
        caseEventSupport.fireAfterCaseStarted(this.caseId, this.deploymentId, this.caseDefinitionId, this.caseFile, processInstanceId);
        return null;
    }

    public void setProcessService(ProcessService processService) {
        this.processService = processService;
    }
}

