/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.command;

import java.util.Map;
import org.jbpm.casemgmt.api.StageNotFoundException;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.impl.command.CaseCommand;
import org.jbpm.casemgmt.impl.event.CaseEventSupport;
import org.jbpm.services.api.ProcessDefinitionNotFoundException;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.DynamicNodeInstance;
import org.jbpm.workflow.instance.node.DynamicUtils;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.command.RegistryContext;
import org.kie.internal.identity.IdentityProvider;

public class AddDynamicProcessToStageCommand
extends CaseCommand<Long> {
    private static final long serialVersionUID = 6345222909719335953L;
    private String caseId;
    private String processId;
    private String stage;
    private long processInstanceId;
    private Map<String, Object> parameters;

    public AddDynamicProcessToStageCommand(IdentityProvider identityProvider, String caseId, Long processInstanceId, String stage, String processId, Map<String, Object> parameters) {
        super(identityProvider);
        this.caseId = caseId;
        this.processInstanceId = processInstanceId;
        this.stage = stage;
        this.processId = processId;
        this.parameters = parameters;
        if (processInstanceId == null || processId == null || stage == null) {
            throw new IllegalArgumentException("Mandatory parameters are missing - process instance id / process id / stage id");
        }
    }

    public Long execute(Context context) {
        KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        ProcessInstance processInstance = ksession.getProcessInstance(this.processInstanceId);
        if (processInstance == null) {
            throw new ProcessInstanceNotFoundException("No process instance found with id " + this.processInstanceId);
        }
        DynamicNodeInstance dynamicContext = ((WorkflowProcessInstanceImpl)processInstance).getNodeInstances(true).stream().filter(ni -> ni instanceof DynamicNodeInstance && this.stage.equals(ni.getNode().getMetaData().get("UniqueId")) || this.stage.equals(ni.getNodeName())).findFirst().orElse(null);
        if (dynamicContext == null) {
            throw new StageNotFoundException("No stage found with id " + this.stage);
        }
        try {
            CaseFileInstance caseFile = this.getCaseFile(ksession, this.caseId);
            CaseEventSupport caseEventSupport = this.getCaseEventSupport(context);
            caseEventSupport.fireBeforeDynamicProcessAdded(this.caseId, caseFile, this.processInstanceId, this.processId, this.parameters);
            long subProcessInstanceId = DynamicUtils.addDynamicSubProcess((DynamicNodeInstance)dynamicContext, (KieRuntime)ksession, (String)this.processId, this.parameters);
            if (subProcessInstanceId < 0L) {
                throw new ProcessDefinitionNotFoundException("No process definition found with id: " + this.processId);
            }
            caseEventSupport.fireAfterDynamicProcessAdded(this.caseId, caseFile, this.processInstanceId, this.processId, this.parameters, subProcessInstanceId);
            return subProcessInstanceId;
        }
        catch (IllegalArgumentException e) {
            throw new ProcessDefinitionNotFoundException(e.getMessage());
        }
    }
}

