/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.command;

import java.util.Collections;
import org.drools.core.command.impl.ExecutableCommand;
import org.drools.core.command.impl.RegistryContext;
import org.drools.core.common.InternalAgenda;
import org.jbpm.casemgmt.impl.event.CaseEventSupport;
import org.jbpm.runtime.manager.impl.PerCaseRuntimeManager;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.internal.identity.IdentityProvider;

public abstract class CaseCommand<T>
implements ExecutableCommand<T> {
    private static final long serialVersionUID = 4116744986913465571L;
    private CaseEventSupport emptyCaseEventSupport;
    private IdentityProvider identityProvider;

    public CaseCommand(IdentityProvider identityProvider) {
        this.identityProvider = identityProvider;
        this.emptyCaseEventSupport = new CaseEventSupport(identityProvider, Collections.emptyList());
    }

    protected CaseEventSupport getCaseEventSupport(Context context) {
        CaseEventSupport caseEventSupport;
        RuntimeManager runtimeManager = this.getRuntimeManager(context);
        if (runtimeManager instanceof PerCaseRuntimeManager && (caseEventSupport = (CaseEventSupport)((PerCaseRuntimeManager)runtimeManager).getCaseEventSupport()) != null) {
            return caseEventSupport;
        }
        return this.emptyCaseEventSupport;
    }

    protected RuntimeManager getRuntimeManager(Context context) {
        KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        RuntimeManager runtimeManager = (RuntimeManager)ksession.getEnvironment().get("RuntimeManager");
        return runtimeManager;
    }

    public IdentityProvider getIdentityProvider() {
        return this.identityProvider;
    }

    protected void triggerRules(KieSession ksession) {
        InternalAgenda agenda = (InternalAgenda)ksession.getAgenda();
        if (agenda.focusStackSize() > 0) {
            agenda.setFocus("MAIN");
        }
        ksession.fireAllRules();
    }
}

