/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.audit;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import javax.persistence.EntityManagerFactory;
import org.jbpm.casemgmt.impl.audit.CaseFileDataLogDeleteBuilder;
import org.jbpm.casemgmt.impl.audit.CaseFileDataLogDeleteBuilderImpl;
import org.jbpm.casemgmt.impl.audit.CaseRoleAssignmentLogDeleteBuilder;
import org.jbpm.casemgmt.impl.audit.CaseRoleAssignmentLogDeleteBuilderImpl;
import org.jbpm.executor.commands.LogCleanupCommand;
import org.jbpm.executor.impl.jpa.ExecutorJPAAuditService;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.core.timer.DateTimeUtils;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutionResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseLogCleanupCommand
extends LogCleanupCommand {
    private static final Logger logger = LoggerFactory.getLogger(CaseLogCleanupCommand.class);

    public ExecutionResults execute(CommandContext ctx) throws Exception {
        String emfName;
        SimpleDateFormat formatToUse = this.dateFormat;
        String dataFormat = (String)ctx.getData("DateFormat");
        if (dataFormat != null) {
            formatToUse = new SimpleDateFormat(dataFormat);
        }
        if ((emfName = (String)ctx.getData("EmfName")) == null) {
            emfName = "org.jbpm.domain";
        }
        String forCaseDefId = (String)ctx.getData("ForCaseDefId");
        String forDeployment = (String)ctx.getData("ForDeployment");
        String statusFilter = (String)ctx.getData("Status");
        Integer[] status = null;
        if (statusFilter != null) {
            status = (Integer[])Arrays.stream(statusFilter.split(",")).map(e -> Integer.parseInt(e)).toArray(Integer[]::new);
        }
        String olderThanPeriod = (String)ctx.getData("OlderThanPeriod");
        String olderThan = (String)ctx.getData("OlderThan");
        if (olderThanPeriod != null) {
            long olderThanDuration = DateTimeUtils.parseDateAsDuration((String)olderThanPeriod);
            Date olderThanDate = new Date(System.currentTimeMillis() - olderThanDuration);
            olderThan = formatToUse.format(olderThanDate);
        }
        EntityManagerFactory emf = EntityManagerFactoryManager.get().getOrCreate(emfName);
        ExecutorJPAAuditService auditLogService = new ExecutorJPAAuditService(emf);
        CaseFileDataLogDeleteBuilderImpl deleteCaseFileDataLog = new CaseFileDataLogDeleteBuilderImpl((JPAAuditLogService)auditLogService);
        long caseFileDataLogsRemoved = ((CaseFileDataLogDeleteBuilder)((CaseFileDataLogDeleteBuilder)deleteCaseFileDataLog.dateRangeEnd(olderThan == null ? null : formatToUse.parse(olderThan)).logBelongsToProcessInDeployment(forDeployment)).logBelongsToProcessInStatus(status)).inCaseDefId(forCaseDefId).build().execute();
        ExecutionResults caseExecutionResults = new ExecutionResults();
        logger.info("CaseFileDataLog {}", (Object)caseFileDataLogsRemoved);
        caseExecutionResults.setData("CaseFileDataLog", (Object)caseFileDataLogsRemoved);
        CaseRoleAssignmentLogDeleteBuilderImpl deleteCaseRoleAssignmentLog = new CaseRoleAssignmentLogDeleteBuilderImpl((JPAAuditLogService)auditLogService);
        long caseRoleAssignmentLogsRemoved = ((CaseRoleAssignmentLogDeleteBuilder)((CaseRoleAssignmentLogDeleteBuilder)deleteCaseRoleAssignmentLog.logBelongsToProcessInDeployment(forDeployment)).logBelongsToProcessInStatus(status)).inCaseDefId(forCaseDefId).build().execute();
        logger.info("CaseRoleAssignmentLog {}", (Object)caseRoleAssignmentLogsRemoved);
        caseExecutionResults.setData("CaseRoleAssignmentLog", (Object)caseRoleAssignmentLogsRemoved);
        ctx.setData("ForProcess", (Object)forCaseDefId);
        ExecutionResults executionResults = super.execute(ctx);
        executionResults.getData().putAll(caseExecutionResults.getData());
        return executionResults;
    }
}

