/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.wih;

import java.util.Collection;
import org.drools.core.ClassObjectFilter;
import org.jbpm.casemgmt.api.CaseService;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.services.api.service.ServiceRegistry;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.SLAViolatedEvent;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.internal.runtime.Cacheable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartProcessSLAViolationListener
extends DefaultProcessEventListener
implements Cacheable {
    private static final Logger logger = LoggerFactory.getLogger(StartProcessSLAViolationListener.class);
    private String processId;

    public StartProcessSLAViolationListener(String processId) {
        this.processId = processId;
    }

    public void afterSLAViolated(SLAViolatedEvent event) {
        CaseFileInstance caseFile = this.getCaseFile((KieSession)event.getKieRuntime());
        if (caseFile != null) {
            String caseId = ((WorkflowProcessInstanceImpl)event.getProcessInstance()).getCorrelationKey();
            if (caseFile.getCaseId().equals(caseId)) {
                logger.debug("Case instance {} has SLA violation, escalating starting new process instance for {}", (Object)caseId, (Object)this.processId);
                CaseService caseService = (CaseService)ServiceRegistry.get().service("CaseService");
                Long slaViolationProcessInstanceId = caseService.addDynamicSubprocess(caseId, this.processId, null);
                logger.debug("Process instance with id {} was created to handle SLA violation for case {}", (Object)slaViolationProcessInstanceId, (Object)caseId);
            }
        }
    }

    protected CaseFileInstance getCaseFile(KieSession ksession) {
        Collection caseFiles = ksession.getObjects((ObjectFilter)new ClassObjectFilter(CaseFileInstance.class));
        if (caseFiles.size() == 0) {
            return null;
        }
        CaseFileInstance caseFile = (CaseFileInstance)caseFiles.iterator().next();
        return caseFile;
    }

    public void close() {
    }
}

