/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.audit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.ServiceLoader;
import org.jbpm.casemgmt.api.audit.CaseFileData;
import org.jbpm.casemgmt.api.audit.CaseVariableIndexer;
import org.jbpm.casemgmt.api.event.CaseEvent;
import org.jbpm.casemgmt.impl.audit.CaseFileDataLog;
import org.jbpm.casemgmt.impl.audit.StringCaseVariableIndexer;

public class CaseIndexerManager {
    private static ServiceLoader<CaseVariableIndexer> caseVariableIndexers = ServiceLoader.load(CaseVariableIndexer.class);
    private static CaseIndexerManager INSTANCE;
    private List<CaseVariableIndexer> indexers = new ArrayList<CaseVariableIndexer>();

    private CaseIndexerManager() {
        for (CaseVariableIndexer indexer : caseVariableIndexers) {
            this.indexers.add(indexer);
        }
        this.indexers.add(new StringCaseVariableIndexer());
    }

    public List<CaseFileData> index(CaseEvent caseEvent, String variableName, Object variable) {
        for (CaseVariableIndexer indexer : this.indexers) {
            List indexed;
            if (!indexer.accept(variable) || (indexed = indexer.index(variableName, variable)) == null) continue;
            ArrayList<CaseFileData> dataItems = new ArrayList<CaseFileData>();
            for (CaseFileData caseVariable : indexed) {
                CaseFileDataLog caseFileDataLog = new CaseFileDataLog(caseEvent.getCaseId(), caseEvent.getCaseFile().getDefinitionId(), caseVariable.getItemName());
                caseFileDataLog.setItemType(caseVariable.getItemType());
                caseFileDataLog.setItemValue(caseVariable.getItemValue());
                caseFileDataLog.setLastModified(new Date());
                caseFileDataLog.setLastModifiedBy(caseEvent.getUser());
                dataItems.add(caseFileDataLog);
            }
            return dataItems;
        }
        return null;
    }

    public List<String> getIndexNames(String variableName, Object variable) {
        if (variable == null) {
            return Collections.singletonList(variableName);
        }
        for (CaseVariableIndexer indexer : this.indexers) {
            if (!indexer.accept(variable)) continue;
            List indexed = indexer.getIndexNames(variableName);
            return indexed;
        }
        return null;
    }

    public static CaseIndexerManager get() {
        if (INSTANCE == null) {
            INSTANCE = new CaseIndexerManager();
        }
        return INSTANCE;
    }
}

