/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.cm.backend.server;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.console.ng.cm.backend.server.CaseCommentMapper;
import org.jbpm.console.ng.cm.backend.server.CaseDefinitionMapper;
import org.jbpm.console.ng.cm.backend.server.CaseInstanceMapper;
import org.jbpm.console.ng.cm.model.CaseCommentSummary;
import org.jbpm.console.ng.cm.model.CaseDefinitionSummary;
import org.jbpm.console.ng.cm.model.CaseInstanceSummary;
import org.jbpm.console.ng.cm.service.CaseManagementService;
import org.jbpm.console.ng.cm.util.CaseInstanceSearchRequest;
import org.jbpm.console.ng.cm.util.CaseInstanceSortBy;
import org.kie.server.client.CaseServicesClient;

@Service
@ApplicationScoped
public class RemoteCaseManagementServiceImpl
implements CaseManagementService {
    private static final int PAGE_SIZE_UNLIMITED = -1;
    @Inject
    private CaseServicesClient client;

    public List<CaseDefinitionSummary> getCaseDefinitions() {
        List caseDefinitions = this.client.getCaseDefinitions(Integer.valueOf(0), Integer.valueOf(-1));
        return caseDefinitions.stream().map(new CaseDefinitionMapper()).collect(Collectors.toList());
    }

    public CaseDefinitionSummary getCaseDefinition(String serverTemplateId, String containerId, String caseDefinitionId) {
        return Optional.ofNullable(this.client.getCaseDefinition(containerId, caseDefinitionId)).map(new CaseDefinitionMapper()).orElse(null);
    }

    public List<CaseInstanceSummary> getCaseInstances(CaseInstanceSearchRequest request) {
        List caseInstances = this.client.getCaseInstances(Collections.singletonList(request.getStatus()), Integer.valueOf(0), Integer.valueOf(-1));
        Comparator<CaseInstanceSummary> comparator = this.getCaseInstanceSummaryComparator(request);
        return caseInstances.stream().map(new CaseInstanceMapper()).sorted(comparator).collect(Collectors.toList());
    }

    protected Comparator<CaseInstanceSummary> getCaseInstanceSummaryComparator(CaseInstanceSearchRequest request) {
        Comparator<CaseInstanceSummary> comparator;
        switch (Optional.ofNullable(request.getSortBy()).orElse(CaseInstanceSortBy.CASE_ID)) {
            case START_TIME: {
                comparator = Comparator.comparing(CaseInstanceSummary::getStartedAt);
                break;
            }
            default: {
                comparator = Comparator.comparing(CaseInstanceSummary::getCaseId);
            }
        }
        return request.getSortByAsc() != false ? comparator : comparator.reversed();
    }

    public String startCaseInstance(String serverTemplateId, String containerId, String caseDefinitionId) {
        return this.client.startCase(containerId, caseDefinitionId);
    }

    public void cancelCaseInstance(String serverTemplateId, String containerId, String caseId) {
        this.client.cancelCaseInstance(containerId, caseId);
    }

    public void destroyCaseInstance(String serverTemplateId, String containerId, String caseId) {
        this.client.destroyCaseInstance(containerId, caseId);
    }

    public CaseInstanceSummary getCaseInstance(String serverTemplateId, String containerId, String caseId) {
        return Optional.ofNullable(this.client.getCaseInstance(containerId, caseId, true, true, true, true)).map(new CaseInstanceMapper()).orElse(null);
    }

    public void assignUserToRole(String serverTemplateId, String containerId, String caseId, String roleName, String user) {
        this.client.assignUserToRole(containerId, caseId, roleName, user);
    }

    public void assignGroupToRole(String serverTemplateId, String containerId, String caseId, String roleName, String group) {
        this.client.assignGroupToRole(containerId, caseId, roleName, group);
    }

    public void removeUserFromRole(String serverTemplateId, String containerId, String caseId, String roleName, String user) {
        this.client.removeUserFromRole(containerId, caseId, roleName, user);
    }

    public void removeGroupFromRole(String serverTemplateId, String containerId, String caseId, String roleName, String group) {
        this.client.removeGroupFromRole(containerId, caseId, roleName, group);
    }

    public List<CaseCommentSummary> getComments(String serverTemplateId, String containerId, String caseId) {
        List caseComments = this.client.getComments(containerId, caseId, Integer.valueOf(0), Integer.valueOf(-1));
        return caseComments.stream().map(new CaseCommentMapper()).collect(Collectors.toList());
    }

    public void addComment(String serverTemplateId, String containerId, String caseId, String author, String text) {
        this.client.addComment(containerId, caseId, author, text);
    }

    public void updateComment(String serverTemplateId, String containerId, String caseId, String commentId, String author, String text) {
        this.client.updateComment(containerId, caseId, commentId, author, text);
    }

    public void removeComment(String serverTemplateId, String containerId, String caseId, String commentId) {
        this.client.removeComment(containerId, caseId, commentId);
    }
}

