/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.es.client.editors.quicknewjob;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.ControlGroup;
import com.github.gwtbootstrap.client.ui.HelpBlock;
import com.github.gwtbootstrap.client.ui.HelpInline;
import com.github.gwtbootstrap.client.ui.IntegerBox;
import com.github.gwtbootstrap.client.ui.Label;
import com.github.gwtbootstrap.client.ui.Tab;
import com.github.gwtbootstrap.client.ui.TabPanel;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.github.gwtbootstrap.client.ui.constants.ButtonType;
import com.github.gwtbootstrap.client.ui.constants.ControlGroupType;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.cell.client.ActionCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CompositeCell;
import com.google.gwt.cell.client.EditTextCell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.HasCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.AbstractCellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.DataGrid;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.es.client.i18n.Constants;
import org.jbpm.console.ng.es.client.util.ResizableHeader;
import org.jbpm.console.ng.es.model.RequestParameterSummary;
import org.jbpm.console.ng.es.model.events.RequestChangedEvent;
import org.jbpm.console.ng.es.service.ExecutorServiceEntryPoint;
import org.jbpm.console.ng.gc.client.util.UTCDateBox;
import org.jbpm.console.ng.gc.client.util.UTCTimeBox;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.GenericModalFooter;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class QuickNewJobPopup
extends BaseModal {
    @UiField
    public TabPanel tabPanel;
    @UiField
    public Tab basicTab;
    @UiField
    public Tab advancedTab;
    @UiField
    public ControlGroup jobNameControlGroup;
    @UiField
    public TextBox jobNameText;
    @UiField
    HelpInline jobNameHelpInline;
    @UiField
    public ControlGroup jobDueDateControlGroup;
    @UiField
    public UTCDateBox jobDueDate;
    @UiField
    public UTCTimeBox jobDueDateTime;
    @UiField
    HelpBlock jobDueDateHelpBlock;
    @UiField
    public ControlGroup jobTypeControlGroup;
    @UiField
    public TextBox jobTypeText;
    @UiField
    HelpInline jobTypeHelpInline;
    @UiField
    public ControlGroup jobRetriesControlGroup;
    @UiField
    public IntegerBox jobRetriesNumber;
    @UiField
    HelpInline jobRetriesHelpInline;
    @UiField
    public Button newParametersButton;
    @UiField
    public DataGrid<RequestParameterSummary> myParametersGrid;
    @UiField
    public HelpBlock errorMessages;
    @UiField
    public ControlGroup errorMessagesGroup;
    @Inject
    private Event<NotificationEvent> notification;
    @Inject
    private Caller<ExecutorServiceEntryPoint> executorServices;
    @Inject
    private Event<RequestChangedEvent> requestCreatedEvent;
    private ListDataProvider<RequestParameterSummary> dataProvider = new ListDataProvider();
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);

    public QuickNewJobPopup() {
        this.setTitle(Constants.INSTANCE.New_Job());
        this.add((Widget)uiBinder.createAndBindUi((Object)this));
        this.init();
        GenericModalFooter footer = new GenericModalFooter();
        footer.addButton(Constants.INSTANCE.Create(), new Command(){

            public void execute() {
                QuickNewJobPopup.this.okButton();
            }
        }, IconType.PLUS_SIGN, ButtonType.PRIMARY);
        this.add((Widget)footer);
    }

    public void show() {
        this.cleanForm();
        super.show();
    }

    private void okButton() {
        if (this.validateForm()) {
            this.createJob();
        }
    }

    public void init() {
        this.newParametersButton.setText(Constants.INSTANCE.Add_Parameter());
        this.myParametersGrid.setHeight("200px");
        this.myParametersGrid.setEmptyTableWidget((Widget)new Label(Constants.INSTANCE.No_Parameters_added_yet()));
        this.initGridColumns();
        this.newParametersButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                QuickNewJobPopup.this.addNewParameter();
            }
        });
    }

    public void cleanForm() {
        this.tabPanel.selectTab(0);
        this.basicTab.setActive(true);
        this.advancedTab.setActive(false);
        long now = System.currentTimeMillis() + 120000L;
        this.jobDueDate.setEnabled(true);
        this.jobDueDate.setValue(Long.valueOf(now));
        this.jobDueDateTime.setValue(UTCDateBox.date2utc((Date)new Date(now)));
        this.jobNameText.setText("");
        this.jobTypeText.setText("");
        this.jobRetriesNumber.setText("0");
        this.dataProvider.getList().clear();
    }

    private void cleanErrorMessages() {
        this.jobNameControlGroup.setType(ControlGroupType.NONE);
        this.jobNameHelpInline.setText("");
        this.jobDueDateControlGroup.setType(ControlGroupType.NONE);
        this.jobDueDateHelpBlock.setText("");
        this.jobTypeControlGroup.setType(ControlGroupType.NONE);
        this.jobTypeHelpInline.setText("");
        this.jobRetriesControlGroup.setType(ControlGroupType.NONE);
        this.jobRetriesHelpInline.setText("");
    }

    public void closePopup() {
        this.cleanForm();
        this.hide();
        super.hide();
    }

    private boolean validateForm() {
        boolean valid = true;
        this.cleanErrorMessages();
        if (this.jobNameText.getText() == null || this.jobNameText.getText().trim().isEmpty()) {
            this.jobNameControlGroup.setType(ControlGroupType.ERROR);
            this.jobNameHelpInline.setText(Constants.INSTANCE.The_Job_Must_Have_A_Name());
            valid = false;
        } else {
            this.jobNameControlGroup.setType(ControlGroupType.SUCCESS);
        }
        if (UTCDateBox.utc2date((Long)(this.jobDueDate.getValue() + this.jobDueDateTime.getValue())).before(new Date())) {
            this.jobDueDateControlGroup.setType(ControlGroupType.ERROR);
            this.jobDueDateHelpBlock.setText(Constants.INSTANCE.The_Job_Must_Have_A_Due_Date_In_The_Future());
            valid = false;
        } else {
            this.jobDueDateControlGroup.setType(ControlGroupType.SUCCESS);
        }
        if (this.jobTypeText.getText() == null || this.jobTypeText.getText().trim().isEmpty()) {
            this.jobTypeControlGroup.setType(ControlGroupType.ERROR);
            this.jobTypeHelpInline.setText(Constants.INSTANCE.The_Job_Must_Have_A_Type());
            valid = false;
        } else {
            this.jobTypeControlGroup.setType(ControlGroupType.SUCCESS);
        }
        if (this.jobRetriesNumber.getValue() == null || (Integer)this.jobRetriesNumber.getValue() < 0) {
            this.jobRetriesControlGroup.setType(ControlGroupType.ERROR);
            this.jobRetriesHelpInline.setText(Constants.INSTANCE.The_Job_Must_Have_A_Positive_Number_Of_Reties());
            valid = false;
        } else {
            this.jobRetriesControlGroup.setType(ControlGroupType.SUCCESS);
        }
        if (!valid) {
            this.tabPanel.selectTab(0);
        }
        return valid;
    }

    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    public void makeRowEditable(RequestParameterSummary parameter) {
        this.myParametersGrid.getSelectionModel().setSelected((Object)parameter, true);
    }

    public void removeRow(RequestParameterSummary parameter) {
        this.dataProvider.getList().remove(parameter);
    }

    public void addRow(RequestParameterSummary parameter) {
        this.dataProvider.getList().add(parameter);
    }

    private void initGridColumns() {
        Column<RequestParameterSummary, String> paramKeyColumn = new Column<RequestParameterSummary, String>((Cell)new EditTextCell()){

            public String getValue(RequestParameterSummary rowObject) {
                return rowObject.getKey();
            }
        };
        paramKeyColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<RequestParameterSummary, String>(){

            public void update(int index, RequestParameterSummary object, String value) {
                object.setKey(value);
                QuickNewJobPopup.this.dataProvider.getList().set(index, object);
            }
        });
        this.myParametersGrid.addColumn((Column)paramKeyColumn, new ResizableHeader<RequestParameterSummary>("Key", (AbstractCellTable<RequestParameterSummary>)this.myParametersGrid, paramKeyColumn));
        Column<RequestParameterSummary, String> paramValueColumn = new Column<RequestParameterSummary, String>((Cell)new EditTextCell()){

            public String getValue(RequestParameterSummary rowObject) {
                return rowObject.getValue();
            }
        };
        paramValueColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<RequestParameterSummary, String>(){

            public void update(int index, RequestParameterSummary object, String value) {
                object.setValue(value);
                QuickNewJobPopup.this.dataProvider.getList().set(index, object);
            }
        });
        this.myParametersGrid.addColumn((Column)paramValueColumn, new ResizableHeader<RequestParameterSummary>("Value", (AbstractCellTable<RequestParameterSummary>)this.myParametersGrid, paramValueColumn));
        LinkedList<ActionHasCell> cells = new LinkedList<ActionHasCell>();
        cells.add(new ActionHasCell(Constants.INSTANCE.Remove(), new ActionCell.Delegate<RequestParameterSummary>(){

            public void execute(RequestParameterSummary parameter) {
                QuickNewJobPopup.this.removeParameter(parameter);
            }
        }));
        CompositeCell cell = new CompositeCell(cells);
        Column<RequestParameterSummary, RequestParameterSummary> actionsColumn = new Column<RequestParameterSummary, RequestParameterSummary>((Cell)cell){

            public RequestParameterSummary getValue(RequestParameterSummary object) {
                return object;
            }
        };
        this.myParametersGrid.addColumn((Column)actionsColumn, "Actions");
        this.myParametersGrid.setColumnWidth((Column)actionsColumn, "70px");
        this.dataProvider.addDataDisplay(this.myParametersGrid);
    }

    public void removeParameter(RequestParameterSummary parameter) {
        this.removeRow(parameter);
    }

    public void addNewParameter() {
        this.addRow(new RequestParameterSummary("click to edit", "click to edit"));
    }

    public void createJob() {
        this.createJob(this.jobNameText.getText(), UTCDateBox.utc2date((Long)(this.jobDueDate.getValue() + this.jobDueDateTime.getValue())), this.jobTypeText.getText(), (Integer)this.jobRetriesNumber.getValue(), this.dataProvider.getList());
    }

    public void createJob(String jobName, Date dueDate, String jobType, Integer numberOfTries, List<RequestParameterSummary> parameters) {
        HashMap<String, String> ctx = new HashMap<String, String>();
        if (parameters != null) {
            for (RequestParameterSummary param : parameters) {
                ctx.put(param.getKey(), param.getValue());
            }
        }
        ctx.put("retries", String.valueOf(numberOfTries));
        ctx.put("jobName", jobName);
        ((ExecutorServiceEntryPoint)this.executorServices.call((RemoteCallback)new RemoteCallback<Long>(){

            public void callback(Long requestId) {
                QuickNewJobPopup.this.cleanForm();
                QuickNewJobPopup.this.displayNotification("Request Schedulled: " + requestId);
                QuickNewJobPopup.this.requestCreatedEvent.fire((Object)new RequestChangedEvent(requestId));
                QuickNewJobPopup.this.closePopup();
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                if (throwable instanceof IllegalArgumentException) {
                    QuickNewJobPopup.this.jobTypeControlGroup.setType(ControlGroupType.ERROR);
                    QuickNewJobPopup.this.jobTypeHelpInline.setText(Constants.INSTANCE.The_Job_Must_Have_A_Valid_Type());
                    return true;
                }
                QuickNewJobPopup.this.errorMessages.setText(throwable.getMessage());
                QuickNewJobPopup.this.errorMessagesGroup.setType(ControlGroupType.ERROR);
                QuickNewJobPopup.this.tabPanel.selectTab(0);
                return true;
            }
        })).scheduleRequest(jobType, dueDate, ctx);
    }

    private class ActionHasCell
    implements HasCell<RequestParameterSummary, RequestParameterSummary> {
        private ActionCell<RequestParameterSummary> cell;

        public ActionHasCell(final String text, ActionCell.Delegate<RequestParameterSummary> delegate) {
            this.cell = new ActionCell<RequestParameterSummary>(text, delegate){

                public void render(Cell.Context context, RequestParameterSummary value, SafeHtmlBuilder sb) {
                    SafeHtmlBuilder mysb = new SafeHtmlBuilder();
                    mysb.appendHtmlConstant("<a href='javascript:;' class='btn btn-mini' style='margin-right:5px;' title='" + text + "'>" + text + "</a>");
                    sb.append(mysb.toSafeHtml());
                }
            };
        }

        public Cell<RequestParameterSummary> getCell() {
            return this.cell;
        }

        public FieldUpdater<RequestParameterSummary, RequestParameterSummary> getFieldUpdater() {
            return null;
        }

        public RequestParameterSummary getValue(RequestParameterSummary object) {
            return object;
        }
    }

    static interface Binder
    extends UiBinder<Widget, QuickNewJobPopup> {
    }
}

