/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.es.client.editors.requestlist;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.Range;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.es.client.i18n.Constants;
import org.jbpm.console.ng.es.model.RequestSummary;
import org.jbpm.console.ng.es.model.events.RequestChangedEvent;
import org.jbpm.console.ng.es.service.ExecutorServiceEntryPoint;
import org.jbpm.console.ng.ga.model.PortableQueryFilter;
import org.jbpm.console.ng.gc.client.list.base.AbstractListView;
import org.jbpm.console.ng.gc.client.list.base.AbstractScreenListPresenter;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberView;
import org.uberfire.paging.PageResponse;

@Dependent
@WorkbenchScreen(identifier="Requests List")
public class RequestListPresenter
extends AbstractScreenListPresenter<RequestSummary> {
    public static String FILTER_STATUSES_PARAM_NAME = "states";
    private Constants constants = (Constants)GWT.create(Constants.class);
    @Inject
    private RequestListView view;
    @Inject
    private Caller<ExecutorServiceEntryPoint> executorServices;
    @Inject
    private Event<RequestChangedEvent> requestChangedEvent;
    private List<String> currentActiveStates;

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.RequestsListTitle();
    }

    @WorkbenchPartView
    public UberView<RequestListPresenter> getView() {
        return this.view;
    }

    public void refreshRequests(List<String> statuses) {
        this.currentActiveStates = statuses;
        this.refreshGrid();
    }

    public void init() {
        ((ExecutorServiceEntryPoint)this.executorServices.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                RequestListPresenter.this.view.displayNotification("Executor Service Started ...");
            }
        })).init();
    }

    public void createRequest() {
        HashMap<String, String> ctx = new HashMap<String, String>();
        ctx.put("businessKey", "1234");
        ((ExecutorServiceEntryPoint)this.executorServices.call((RemoteCallback)new RemoteCallback<Long>(){

            public void callback(Long requestId) {
                RequestListPresenter.this.view.displayNotification("Request Schedulled: " + requestId);
            }
        })).scheduleRequest("PrintOutCmd", ctx);
    }

    protected AbstractListView.ListView getListView() {
        return this.view;
    }

    public void getData(Range visibleRange) {
        ColumnSortList columnSortList = this.view.getListGrid().getColumnSortList();
        if (this.currentFilter == null) {
            this.currentFilter = new PortableQueryFilter(visibleRange.getStart(), visibleRange.getLength(), false, "", columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "", columnSortList.size() > 0 ? columnSortList.get(0).isAscending() : true);
        }
        if (this.currentFilter.getParams() == null || this.currentFilter.getParams().isEmpty() || this.currentFilter.getParams().get("textSearch") == null || this.currentFilter.getParams().get("textSearch").equals("")) {
            this.currentFilter.setOffset(Integer.valueOf(visibleRange.getStart()));
            this.currentFilter.setCount(Integer.valueOf(visibleRange.getLength()));
        } else {
            this.currentFilter.setOffset(Integer.valueOf(0));
            this.currentFilter.setCount(Integer.valueOf(this.view.getListGrid().getPageSize()));
        }
        if (this.currentFilter.getParams() == null) {
            this.currentFilter.setParams(new HashMap());
        }
        this.currentFilter.getParams().put("states", this.currentActiveStates);
        this.currentFilter.setOrderBy(columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "");
        this.currentFilter.setIsAscending(Boolean.valueOf(columnSortList.size() > 0 ? columnSortList.get(0).isAscending() : true));
        ((ExecutorServiceEntryPoint)this.executorServices.call((RemoteCallback)new RemoteCallback<PageResponse<RequestSummary>>(){

            public void callback(PageResponse<RequestSummary> response) {
                RequestListPresenter.this.updateDataOnCallback(response);
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                RequestListPresenter.this.view.hideBusyIndicator();
                RequestListPresenter.this.view.displayNotification("Error: Getting Jbos Requests: " + message);
                GWT.log((String)throwable.toString());
                return true;
            }
        })).getData(this.currentFilter);
    }

    public void addDataDisplay(HasData<RequestSummary> display) {
        this.dataProvider.addDataDisplay(display);
    }

    public AsyncDataProvider<RequestSummary> getDataProvider() {
        return this.dataProvider;
    }

    public void cancelRequest(final Long requestId) {
        ((ExecutorServiceEntryPoint)this.executorServices.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                RequestListPresenter.this.view.displayNotification("Request " + requestId + " cancelled");
                RequestListPresenter.this.requestChangedEvent.fire((Object)new RequestChangedEvent(requestId));
            }
        })).cancelRequest(requestId);
    }

    public void requeueRequest(final Long requestId) {
        ((ExecutorServiceEntryPoint)this.executorServices.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                RequestListPresenter.this.view.displayNotification("Request " + requestId + " cancelled");
                RequestListPresenter.this.requestChangedEvent.fire((Object)new RequestChangedEvent(requestId));
            }
        })).requeueRequest(requestId);
    }

    public static interface RequestListView
    extends AbstractListView.ListView<RequestSummary, RequestListPresenter> {
    }
}

