/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.es.client.editors.requestlist;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.NavLink;
import com.github.gwtbootstrap.client.ui.SplitDropdownButton;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.cell.client.ActionCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CompositeCell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.HasCell;
import com.google.gwt.cell.client.NumberCell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.NoSelectionModel;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jbpm.console.ng.es.client.editors.jobdetails.JobDetailsPopup;
import org.jbpm.console.ng.es.client.editors.quicknewjob.QuickNewJobPopup;
import org.jbpm.console.ng.es.client.editors.requestlist.RequestListPresenter;
import org.jbpm.console.ng.es.client.editors.servicesettings.JobServiceSettingsPopup;
import org.jbpm.console.ng.es.client.i18n.Constants;
import org.jbpm.console.ng.es.model.RequestSummary;
import org.jbpm.console.ng.es.model.events.RequestChangedEvent;
import org.jbpm.console.ng.gc.client.experimental.grid.base.ExtendedPagedTable;
import org.jbpm.console.ng.gc.client.list.base.AbstractListPresenter;
import org.jbpm.console.ng.gc.client.list.base.AbstractMultiGridView;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;
import org.uberfire.ext.widgets.common.client.tables.popup.NewTabFilterPopup;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class RequestListViewImpl
extends AbstractMultiGridView<RequestSummary, RequestListPresenter>
implements RequestListPresenter.RequestListView {
    private Constants constants = (Constants)GWT.create(Constants.class);
    @Inject
    private Event<NotificationEvent> notification;
    private List<RequestSummary> selectedRequestSummary = new ArrayList<RequestSummary>();
    @Inject
    private JobDetailsPopup jobDetailsPopup;
    @Inject
    private QuickNewJobPopup quickNewJobPopup;
    @Inject
    private NewTabFilterPopup newTabFilterPopup;
    @Inject
    private JobServiceSettingsPopup jobServiceSettingsPopup;

    public void init(final RequestListPresenter presenter) {
        final ArrayList<String> bannedColumns = new ArrayList<String>();
        bannedColumns.add(this.constants.Id());
        bannedColumns.add(this.constants.Type());
        final ArrayList<String> initColumns = new ArrayList<String>();
        initColumns.add(this.constants.Id());
        initColumns.add(this.constants.Type());
        initColumns.add(this.constants.Actions());
        final Button button = new Button();
        button.setText("+");
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Command addNewGrid = new Command(){

                    public void execute() {
                        HashMap newTabFormValues = RequestListViewImpl.this.newTabFilterPopup.getFormValues();
                        final String key = RequestListViewImpl.this.getValidKeyForAdditionalListGrid("RequestListGrid_");
                        RequestListViewImpl.this.filterPagedTable.saveNewTabSettings(key, newTabFormValues);
                        final ExtendedPagedTable extendedPagedTable = RequestListViewImpl.this.createGridInstance(new GridGlobalPreferences(key, initColumns, bannedColumns), key);
                        presenter.addDataDisplay((HasData<RequestSummary>)extendedPagedTable);
                        extendedPagedTable.setDataProvider(presenter.getDataProvider());
                        RequestListViewImpl.this.filterPagedTable.createNewTab((PagedTable)extendedPagedTable, key, button, new Command(){

                            public void execute() {
                                RequestListViewImpl.this.currentListGrid = extendedPagedTable;
                                RequestListViewImpl.this.applyFilterOnPresenter(key);
                            }
                        });
                        RequestListViewImpl.this.applyFilterOnPresenter(newTabFormValues);
                    }
                };
                RequestListViewImpl.this.createFilterForm();
                RequestListViewImpl.this.newTabFilterPopup.show(addNewGrid, RequestListViewImpl.this.getMultiGridPreferencesStore());
            }
        });
        super.init((AbstractListPresenter)presenter, new GridGlobalPreferences("RequestListGrid", initColumns, bannedColumns), button);
    }

    public void requestCreated(@Observes RequestChangedEvent event) {
        ((RequestListPresenter)this.presenter).refreshRequests(null);
    }

    public void initColumns(ExtendedPagedTable extendedPagedTable) {
        this.initJobIdColumn(extendedPagedTable);
        this.initJobTypeColumn(extendedPagedTable);
        this.initStatusColumn(extendedPagedTable);
        this.initDueDateColumn(extendedPagedTable);
        this.actionsColumn = this.initActionsColumn();
        extendedPagedTable.addColumn(this.actionsColumn, this.constants.Actions());
    }

    private void createFilterForm() {
        HashMap<String, String> statesListBoxInfo = new HashMap<String, String>();
        statesListBoxInfo.put(String.valueOf("QUEUED"), Constants.INSTANCE.Queued());
        statesListBoxInfo.put(String.valueOf("RUNNING"), Constants.INSTANCE.Running());
        statesListBoxInfo.put(String.valueOf("RETRYING"), Constants.INSTANCE.Retrying());
        statesListBoxInfo.put(String.valueOf("ERROR"), Constants.INSTANCE.Error());
        statesListBoxInfo.put(String.valueOf("DONE"), Constants.INSTANCE.Completed());
        statesListBoxInfo.put(String.valueOf("CANCELLED"), Constants.INSTANCE.Cancelled());
        this.newTabFilterPopup.init();
        this.newTabFilterPopup.addListBoxToFilter(Constants.INSTANCE.Status(), "states", true, statesListBoxInfo);
    }

    public void initSelectionModel() {
        final ExtendedPagedTable extendedPagedTable = this.getListGrid();
        extendedPagedTable.setEmptyTableCaption(this.constants.No_Jobs_Found());
        this.initLeftToolbarActions(extendedPagedTable);
        this.selectionModel = new NoSelectionModel();
        this.selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                boolean close = false;
                if (RequestListViewImpl.this.selectedRow == -1) {
                    extendedPagedTable.setRowStyles(RequestListViewImpl.this.selectedStyles);
                    RequestListViewImpl.this.selectedRow = extendedPagedTable.getKeyboardSelectedRow();
                    extendedPagedTable.redraw();
                } else if (extendedPagedTable.getKeyboardSelectedRow() != RequestListViewImpl.this.selectedRow) {
                    extendedPagedTable.setRowStyles(RequestListViewImpl.this.selectedStyles);
                    RequestListViewImpl.this.selectedRow = extendedPagedTable.getKeyboardSelectedRow();
                    extendedPagedTable.redraw();
                } else {
                    close = true;
                }
            }
        });
        this.initNoActionColumnManager(extendedPagedTable);
        extendedPagedTable.setSelectionModel((SelectionModel)this.selectionModel, (CellPreviewEvent.Handler)this.noActionColumnManager);
        extendedPagedTable.setRowStyles(this.selectedStyles);
    }

    private void initNoActionColumnManager(final ExtendedPagedTable extendedPagedTable) {
        this.noActionColumnManager = DefaultSelectionEventManager.createCustomManager((DefaultSelectionEventManager.EventTranslator)new DefaultSelectionEventManager.EventTranslator<RequestSummary>(){

            public boolean clearCurrentSelection(CellPreviewEvent<RequestSummary> event) {
                return false;
            }

            public DefaultSelectionEventManager.SelectAction translateSelectionEvent(CellPreviewEvent<RequestSummary> event) {
                NativeEvent nativeEvent = event.getNativeEvent();
                if ("click".equals(nativeEvent.getType())) {
                    InputElement input;
                    if (extendedPagedTable.getColumnIndex(RequestListViewImpl.this.actionsColumn) == event.getColumn()) {
                        return DefaultSelectionEventManager.SelectAction.IGNORE;
                    }
                    Element target = (Element)nativeEvent.getEventTarget().cast();
                    if ("input".equals(target.getTagName().toLowerCase()) && "checkbox".equals((input = (InputElement)target.cast()).getType().toLowerCase())) {
                        if (!RequestListViewImpl.this.selectedRequestSummary.contains(event.getValue())) {
                            RequestListViewImpl.this.selectedRequestSummary.add(event.getValue());
                            input.setChecked(true);
                        } else {
                            RequestListViewImpl.this.selectedRequestSummary.remove(event.getValue());
                            input.setChecked(false);
                        }
                        return DefaultSelectionEventManager.SelectAction.IGNORE;
                    }
                }
                return DefaultSelectionEventManager.SelectAction.DEFAULT;
            }
        });
    }

    private void initLeftToolbarActions(ExtendedPagedTable extendedPagedTable) {
        SplitDropdownButton actions = new SplitDropdownButton();
        actions.setText(this.constants.Actions());
        NavLink newJobNavLink = new NavLink(this.constants.New_Job());
        newJobNavLink.setIcon(IconType.PLUS_SIGN);
        newJobNavLink.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                RequestListViewImpl.this.quickNewJobPopup.show();
            }
        });
        NavLink settingsNavLink = new NavLink(this.constants.Settings());
        settingsNavLink.setIcon(IconType.COG);
        settingsNavLink.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                RequestListViewImpl.this.jobServiceSettingsPopup.show();
            }
        });
        actions.add((Widget)newJobNavLink);
        actions.add((Widget)settingsNavLink);
        extendedPagedTable.getRightActionsToolbar().clear();
        extendedPagedTable.getRightActionsToolbar().add((Widget)actions);
    }

    private void initJobIdColumn(ExtendedPagedTable extendedPagedTable) {
        Column<RequestSummary, Number> taskIdColumn = new Column<RequestSummary, Number>((Cell)new NumberCell()){

            public Number getValue(RequestSummary object) {
                return object.getJobId();
            }
        };
        taskIdColumn.setSortable(true);
        extendedPagedTable.addColumn((Column)taskIdColumn, this.constants.Id());
        taskIdColumn.setDataStoreName("Id");
    }

    private void initJobTypeColumn(ExtendedPagedTable extendedPagedTable) {
        Column<RequestSummary, String> jobTypeColumn = new Column<RequestSummary, String>((Cell)new TextCell()){

            public String getValue(RequestSummary object) {
                return object.getCommandName();
            }
        };
        jobTypeColumn.setSortable(true);
        extendedPagedTable.addColumn((Column)jobTypeColumn, this.constants.Type());
        jobTypeColumn.setDataStoreName("CommandName");
    }

    private void initStatusColumn(ExtendedPagedTable extendedPagedTable) {
        Column<RequestSummary, String> statusColumn = new Column<RequestSummary, String>((Cell)new TextCell()){

            public String getValue(RequestSummary object) {
                return object.getStatus();
            }
        };
        statusColumn.setSortable(true);
        extendedPagedTable.addColumn((Column)statusColumn, this.constants.Status());
        statusColumn.setDataStoreName("Status");
    }

    private void initDueDateColumn(ExtendedPagedTable extendedPagedTable) {
        Column<RequestSummary, String> taskNameColumn = new Column<RequestSummary, String>((Cell)new TextCell()){

            public String getValue(RequestSummary object) {
                return object.getTime().toString();
            }
        };
        taskNameColumn.setSortable(true);
        extendedPagedTable.addColumn((Column)taskNameColumn, this.constants.Due_On());
        taskNameColumn.setDataStoreName("Time");
    }

    private Column<RequestSummary, RequestSummary> initActionsColumn() {
        LinkedList<ActionHasCell> cells = new LinkedList<ActionHasCell>();
        ArrayList<String> allStatuses = new ArrayList<String>();
        allStatuses.add("QUEUED");
        allStatuses.add("DONE");
        allStatuses.add("CANCELLED");
        allStatuses.add("ERROR");
        allStatuses.add("RETRYING");
        allStatuses.add("RUNNING");
        cells.add(new ActionHasCell(Constants.INSTANCE.Details(), allStatuses, new ActionCell.Delegate<RequestSummary>(){

            public void execute(RequestSummary job) {
                RequestListViewImpl.this.jobDetailsPopup.show(String.valueOf(job.getJobId()));
            }
        }));
        ArrayList<String> activeStatuses = new ArrayList<String>();
        activeStatuses.add("QUEUED");
        activeStatuses.add("RETRYING");
        activeStatuses.add("RUNNING");
        cells.add(new ActionHasCell(Constants.INSTANCE.Cancel(), activeStatuses, new ActionCell.Delegate<RequestSummary>(){

            public void execute(RequestSummary job) {
                if (Window.confirm((String)"Are you sure you want to cancel this Job?")) {
                    ((RequestListPresenter)RequestListViewImpl.this.presenter).cancelRequest(job.getJobId());
                }
            }
        }));
        ArrayList<String> requeueStatuses = new ArrayList<String>();
        requeueStatuses.add("ERROR");
        requeueStatuses.add("RUNNING");
        cells.add(new ActionHasCell(Constants.INSTANCE.Requeue(), requeueStatuses, new ActionCell.Delegate<RequestSummary>(){

            public void execute(RequestSummary job) {
                if (Window.confirm((String)"Are you sure you want to requeue this Job?")) {
                    ((RequestListPresenter)RequestListViewImpl.this.presenter).requeueRequest(job.getJobId());
                }
            }
        }));
        CompositeCell cell = new CompositeCell(cells);
        Column<RequestSummary, RequestSummary> actionsColumn = new Column<RequestSummary, RequestSummary>((Cell)cell){

            public RequestSummary getValue(RequestSummary object) {
                return object;
            }
        };
        return actionsColumn;
    }

    public void initDefaultFilters(GridGlobalPreferences preferences, Button createTabButton) {
        ArrayList<String> statuses = null;
        this.initTabFilter(preferences, "RequestListGrid_0", Constants.INSTANCE.All(), "Filter " + Constants.INSTANCE.All(), statuses);
        statuses = new ArrayList<String>();
        statuses.add("QUEUED");
        this.initTabFilter(preferences, "RequestListGrid_1", Constants.INSTANCE.Queued(), "Filter " + Constants.INSTANCE.Queued(), statuses);
        statuses = new ArrayList();
        statuses.add("RUNNING");
        this.initTabFilter(preferences, "RequestListGrid_2", Constants.INSTANCE.Running(), "Filter " + Constants.INSTANCE.Running(), statuses);
        statuses = new ArrayList();
        statuses.add("RETRYING");
        this.initTabFilter(preferences, "RequestListGrid_3", Constants.INSTANCE.Retrying(), "Filter " + Constants.INSTANCE.Retrying(), statuses);
        statuses = new ArrayList();
        statuses.add("ERROR");
        this.initTabFilter(preferences, "RequestListGrid_4", Constants.INSTANCE.Error(), "Filter " + Constants.INSTANCE.Error(), statuses);
        statuses = new ArrayList();
        statuses.add("DONE");
        this.initTabFilter(preferences, "RequestListGrid_5", Constants.INSTANCE.Completed(), "Filter " + Constants.INSTANCE.Completed(), statuses);
        statuses = new ArrayList();
        statuses.add("CANCELLED");
        this.initTabFilter(preferences, "RequestListGrid_6", Constants.INSTANCE.Cancelled(), "Filter " + Constants.INSTANCE.Cancelled(), statuses);
        this.filterPagedTable.addAddTableButton(createTabButton);
        this.applyFilterOnPresenter("RequestListGrid_6");
    }

    private void initTabFilter(GridGlobalPreferences preferences, final String key, String tabName, String tabDesc, List<String> statuses) {
        ExtendedPagedTable extendedPagedTable;
        HashMap<String, Object> tabSettingsValues = new HashMap<String, Object>();
        tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_NAME_PARAM, tabName);
        tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_DESC_PARAM, tabDesc);
        tabSettingsValues.put(RequestListPresenter.FILTER_STATUSES_PARAM_NAME, statuses);
        this.filterPagedTable.saveNewTabSettings(key, tabSettingsValues);
        this.currentListGrid = extendedPagedTable = this.createGridInstance(new GridGlobalPreferences(key, preferences.getInitialColumns(), preferences.getBannedColumns()), key);
        ((RequestListPresenter)this.presenter).addDataDisplay((HasData<RequestSummary>)extendedPagedTable);
        extendedPagedTable.setDataProvider(((RequestListPresenter)this.presenter).getDataProvider());
        this.filterPagedTable.addTab((PagedTable)extendedPagedTable, key, new Command(){

            public void execute() {
                RequestListViewImpl.this.currentListGrid = extendedPagedTable;
                RequestListViewImpl.this.applyFilterOnPresenter(key);
            }
        });
    }

    public void applyFilterOnPresenter(HashMap<String, Object> params) {
        List statuses = (List)params.get(RequestListPresenter.FILTER_STATUSES_PARAM_NAME);
        ((RequestListPresenter)this.presenter).refreshRequests(statuses);
    }

    public void applyFilterOnPresenter(String key) {
        this.initSelectionModel();
        this.applyFilterOnPresenter(this.filterPagedTable.getMultiGridPreferencesStore().getGridSettings(key));
    }

    private class ActionHasCell
    implements HasCell<RequestSummary, RequestSummary> {
        private final List<String> availableStatuses;
        private ActionCell<RequestSummary> cell;

        public ActionHasCell(final String text, List<String> availableStatusesList, ActionCell.Delegate<RequestSummary> delegate) {
            this.availableStatuses = availableStatusesList;
            this.cell = new ActionCell<RequestSummary>(text, delegate){

                public void render(Cell.Context context, RequestSummary value, SafeHtmlBuilder sb) {
                    if (ActionHasCell.this.availableStatuses.contains(value.getStatus())) {
                        SafeHtmlBuilder mysb = new SafeHtmlBuilder();
                        mysb.appendHtmlConstant("<a href='javascript:;' class='btn btn-mini' style='margin-right:5px;' title='" + text + "'>" + text + "</a>");
                        sb.append(mysb.toSafeHtml());
                    }
                }
            };
        }

        public Cell<RequestSummary> getCell() {
            return this.cell;
        }

        public FieldUpdater<RequestSummary, RequestSummary> getFieldUpdater() {
            return null;
        }

        public RequestSummary getValue(RequestSummary object) {
            return object;
        }
    }
}

