/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.es.client.editors.servicesettings;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.ControlGroup;
import com.github.gwtbootstrap.client.ui.HelpBlock;
import com.github.gwtbootstrap.client.ui.IntegerBox;
import com.github.gwtbootstrap.client.ui.Label;
import com.github.gwtbootstrap.client.ui.ModalFooter;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.github.gwtbootstrap.client.ui.constants.ButtonType;
import com.github.gwtbootstrap.client.ui.constants.ControlGroupType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.es.client.i18n.Constants;
import org.jbpm.console.ng.es.service.ExecutorServiceEntryPoint;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.GenericModalFooter;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class JobServiceSettingsPopup
extends BaseModal {
    @UiField
    public IntegerBox numberOfExecutorsIntegerText;
    @UiField
    public TextBox frequencyText;
    @UiField
    public Label startedLabel;
    @UiField
    public ControlGroup numberOfExecutorsControlGroup;
    @UiField
    public ControlGroup frequencyControlGroup;
    @UiField
    public ControlGroup startedControlGroup;
    @UiField
    public HelpBlock frequencyHelpInline;
    @UiField
    public HelpBlock numberOfExecutorsHelpInline;
    @UiField
    public HelpBlock errorMessages;
    @UiField
    public ControlGroup errorMessagesGroup;
    @Inject
    private Event<NotificationEvent> notification;
    @Inject
    private Caller<ExecutorServiceEntryPoint> executorServices;
    final GenericModalFooter footer = new GenericModalFooter();
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    private boolean serviceStarted = false;

    public JobServiceSettingsPopup() {
        this.setTitle(Constants.INSTANCE.Job_Service_Settings());
        this.add((Widget)uiBinder.createAndBindUi((Object)this));
        this.footer.addButton(Constants.INSTANCE.Start(), new Command(){

            public void execute() {
                JobServiceSettingsPopup.this.okButton();
            }
        }, null, ButtonType.PRIMARY);
        this.add((Widget)this.footer);
    }

    public void show() {
        this.cleanForm();
        this.cleanErrorMessages();
        super.show();
    }

    private void okButton() {
        if (this.validateForm()) {
            this.startStopService();
        }
    }

    private void cleanErrorMessages() {
        this.numberOfExecutorsHelpInline.setText("");
        this.numberOfExecutorsControlGroup.setType(ControlGroupType.NONE);
        this.frequencyHelpInline.setText("");
        this.frequencyControlGroup.setType(ControlGroupType.NONE);
        this.errorMessages.setText("");
        this.errorMessagesGroup.setType(ControlGroupType.NONE);
    }

    public void closePopup() {
        this.cleanForm();
        this.hide();
        super.hide();
    }

    private boolean validateForm() {
        boolean valid = true;
        this.cleanErrorMessages();
        if (!this.serviceStarted) {
            this.numberOfExecutorsControlGroup.setType(ControlGroupType.SUCCESS);
            this.frequencyControlGroup.setType(ControlGroupType.SUCCESS);
            if (this.numberOfExecutorsIntegerText.getText() == null || this.numberOfExecutorsIntegerText.getText().trim().isEmpty()) {
                this.numberOfExecutorsControlGroup.setType(ControlGroupType.ERROR);
                this.numberOfExecutorsHelpInline.setText(Constants.INSTANCE.Please_Provide_The_Number_Of_Executors());
                valid = false;
            } else if (this.numberOfExecutorsIntegerText.getValue() == null || (Integer)this.numberOfExecutorsIntegerText.getValue() <= 0) {
                this.numberOfExecutorsControlGroup.setType(ControlGroupType.ERROR);
                this.numberOfExecutorsHelpInline.setText(Constants.INSTANCE.Please_Provide_A_Valid_Number_Of_Executors());
                valid = false;
            }
            if (this.frequencyText.getText() == null || this.frequencyText.getText().trim().isEmpty()) {
                this.frequencyControlGroup.setType(ControlGroupType.ERROR);
                this.frequencyHelpInline.setText(Constants.INSTANCE.Please_Provide_A_Valid_Frequency());
                valid = false;
            } else {
                try {
                    if (this.fromFrequencyToInterval(this.frequencyText.getText()) < 0) {
                        throw new NumberFormatException();
                    }
                }
                catch (Exception e) {
                    this.frequencyControlGroup.setType(ControlGroupType.ERROR);
                    this.frequencyHelpInline.setText(Constants.INSTANCE.Please_Provide_A_Valid_Frequency());
                }
            }
        }
        return valid;
    }

    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    public void cleanForm() {
        ((ExecutorServiceEntryPoint)this.executorServices.call((RemoteCallback)new RemoteCallback<Integer>(){

            public void callback(Integer interval) {
                JobServiceSettingsPopup.this.frequencyText.setText(JobServiceSettingsPopup.this.fromIntervalToFrequency(interval));
            }
        })).getInterval();
        ((ExecutorServiceEntryPoint)this.executorServices.call((RemoteCallback)new RemoteCallback<Integer>(){

            public void callback(Integer threadPoolSize) {
                JobServiceSettingsPopup.this.numberOfExecutorsIntegerText.setValue((Object)threadPoolSize);
            }
        })).getThreadPoolSize();
        ((ExecutorServiceEntryPoint)this.executorServices.call((RemoteCallback)new RemoteCallback<Boolean>(){

            public void callback(Boolean started) {
                JobServiceSettingsPopup.this.setStartedLabel(started);
                if (started.booleanValue()) {
                    ((Button)((ModalFooter)JobServiceSettingsPopup.this.footer.getWidget(0)).getWidget(0)).setText(Constants.INSTANCE.Stop());
                    JobServiceSettingsPopup.this.frequencyText.setEnabled(false);
                    JobServiceSettingsPopup.this.numberOfExecutorsIntegerText.setEnabled(false);
                } else {
                    JobServiceSettingsPopup.this.frequencyText.setEnabled(true);
                    JobServiceSettingsPopup.this.numberOfExecutorsIntegerText.setEnabled(true);
                    ((Button)((ModalFooter)JobServiceSettingsPopup.this.footer.getWidget(0)).getWidget(0)).setText(Constants.INSTANCE.Start());
                }
            }
        })).isActive();
    }

    public void startStopService() {
        Integer frequency = this.fromFrequencyToInterval(this.frequencyText.getText());
        Integer numberOfExecutors = (Integer)this.numberOfExecutorsIntegerText.getValue();
        ((ExecutorServiceEntryPoint)this.executorServices.call((RemoteCallback)new RemoteCallback<Boolean>(){

            public void callback(Boolean serviceStatus) {
                JobServiceSettingsPopup.this.displayNotification(serviceStatus != false ? Constants.INSTANCE.ServiceStarted() : Constants.INSTANCE.ServiceStopped());
                JobServiceSettingsPopup.this.closePopup();
            }
        })).startStopService(frequency.intValue(), numberOfExecutors.intValue());
    }

    public String fromIntervalToFrequency(Integer interval) {
        int seconds = interval % 60;
        int minutes = interval / 60 % 60;
        int hours = interval / 3600 % 24;
        int days = interval / 86400;
        StringBuilder frequencyText = new StringBuilder();
        if (days > 0) {
            frequencyText.append(days).append("d ");
        }
        if (hours > 0) {
            frequencyText.append(hours).append("h ");
        }
        if (minutes > 0) {
            frequencyText.append(minutes).append("m ");
        }
        if (seconds > 0) {
            frequencyText.append(seconds).append("s");
        }
        return frequencyText.toString();
    }

    public Integer fromFrequencyToInterval(String frequency) throws NumberFormatException {
        String[] sections = frequency.split(" ");
        int interval = 0;
        for (String section : sections) {
            int value;
            if (section.trim().endsWith("d")) {
                value = Integer.parseInt(section.replace("d", ""));
                interval += value * 86400;
                continue;
            }
            if (section.trim().endsWith("h")) {
                value = Integer.parseInt(section.replace("h", ""));
                interval += value * 3600;
                continue;
            }
            if (section.trim().endsWith("m")) {
                value = Integer.parseInt(section.replace("m", ""));
                interval += value * 60;
                continue;
            }
            if (section.trim().endsWith("s")) {
                value = Integer.parseInt(section.replace("s", ""));
                interval += value;
                continue;
            }
            throw new NumberFormatException();
        }
        return interval;
    }

    public void setStartedLabel(Boolean started) {
        this.startedLabel.setText(started != false ? Constants.INSTANCE.Started() : Constants.INSTANCE.Stopped());
        this.serviceStarted = started;
    }

    static interface Binder
    extends UiBinder<Widget, JobServiceSettingsPopup> {
    }
}

