/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.es.client.util;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.cellview.client.AbstractCellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.client.Event;

public class ResizableHeader<T>
extends Header<String> {
    private Column<T, ?> column = null;
    private AbstractCellTable<T> cellTable;
    private String title = "";
    private static final int width = 20;

    public ResizableHeader(String title, AbstractCellTable<T> cellTable, Column<T, ?> column) {
        super((Cell)new HeaderCell());
        this.title = title;
        this.cellTable = cellTable;
        this.column = column;
    }

    public String getValue() {
        return this.title;
    }

    public void onBrowserEvent(Cell.Context context, Element target, NativeEvent event) {
        String eventType = event.getType();
        if (!eventType.equals("mousemove")) {
            return;
        }
        new ColumnResizeHelper<T>(this.cellTable, this.column, target);
    }

    private void setCursor(Element element, Style.Cursor cursor) {
        element.getStyle().setCursor(cursor);
    }

    static class HeaderCell
    extends AbstractCell<String> {
        public HeaderCell() {
            super(new String[]{"click", "mousedown", "mousemove", "dblclick"});
        }

        public void render(Cell.Context context, String value, SafeHtmlBuilder sb) {
            sb.append(SafeHtmlUtils.fromString((String)value));
        }
    }

    class ColumnResizeHelper<E>
    implements Event.NativePreviewHandler {
        private HandlerRegistration handler;
        private AbstractCellTable<E> table;
        private Column<E, ?> col;
        private Element el;
        private boolean mousedown;
        private Element measuringElement;

        public ColumnResizeHelper(AbstractCellTable<E> table, Column<E, ?> col, Element el) {
            this.el = el;
            this.table = table;
            this.col = col;
            this.handler = Event.addNativePreviewHandler((Event.NativePreviewHandler)this);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onPreviewNativeEvent(Event.NativePreviewEvent event) {
            NativeEvent nativeEvent = event.getNativeEvent();
            nativeEvent.preventDefault();
            nativeEvent.stopPropagation();
            String eventType = nativeEvent.getType();
            int clientX = nativeEvent.getClientX();
            if (eventType.equals("mousemove") && this.mousedown) {
                int absoluteLeft = this.el.getAbsoluteLeft();
                int newWidth = clientX - absoluteLeft;
                newWidth = newWidth < 20 ? 20 : newWidth;
                this.table.setColumnWidth(this.col, newWidth + "px");
                return;
            }
            if (eventType.equals("mousemove") || eventType.equals("mousedown")) {
                int offsetWidth;
                Element eventTargetEl = (Element)nativeEvent.getEventTarget().cast();
                int absoluteLeft = eventTargetEl.getAbsoluteLeft();
                if (clientX <= absoluteLeft + (offsetWidth = eventTargetEl.getOffsetWidth()) - 20) {
                    this.removeHandler();
                    return;
                }
                if (eventType.equals("mousedown")) {
                    this.mousedown = true;
                } else {
                    ResizableHeader.this.setCursor(this.el, Style.Cursor.COL_RESIZE);
                }
            } else if (eventType.equals("mouseup")) {
                this.mousedown = false;
            } else if (eventType.equals("mouseout") && !this.mousedown) {
                this.removeHandler();
                return;
            }
            if (eventType.equals("dblclick")) {
                nativeEvent.preventDefault();
                nativeEvent.stopPropagation();
                double max = 0.0;
                this.startMeasuring();
                for (Object t : this.table.getVisibleItems()) {
                    Object value = this.col.getValue(t);
                    SafeHtmlBuilder sb = new SafeHtmlBuilder();
                    Cell cell = this.col.getCell();
                    cell.render(null, value, sb);
                    max = Math.max(this.measureText(sb.toSafeHtml().asString()), max);
                }
                this.finishMeasuring();
                this.table.setColumnWidth(this.col, max + 20.0 + "px");
                this.removeHandler();
            }
        }

        private void removeHandler() {
            this.handler.removeHandler();
            ResizableHeader.this.setCursor(this.el, Style.Cursor.DEFAULT);
        }

        private void startMeasuring() {
            Document document = Document.get();
            this.measuringElement = document.createElement("div");
            this.measuringElement.getStyle().setPosition(Style.Position.ABSOLUTE);
            this.measuringElement.getStyle().setLeft(-1000.0, Style.Unit.PX);
            this.measuringElement.getStyle().setTop(-1000.0, Style.Unit.PX);
            document.getBody().appendChild((Node)this.measuringElement);
        }

        private double measureText(String text) {
            this.measuringElement.setInnerHTML(text);
            return this.measuringElement.getOffsetWidth();
        }

        private void finishMeasuring() {
            Document.get().getBody().removeChild((Node)this.measuringElement);
        }
    }
}

