/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.es.client.editors.requestlist;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.RadioButton;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.github.gwtbootstrap.client.ui.resources.ButtonSize;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.Range;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.es.client.editors.quicknewjob.QuickNewJobPopup;
import org.jbpm.console.ng.es.client.editors.servicesettings.JobServiceSettingsPopup;
import org.jbpm.console.ng.es.client.i18n.Constants;
import org.jbpm.console.ng.es.model.RequestSummary;
import org.jbpm.console.ng.es.model.events.RequestChangedEvent;
import org.jbpm.console.ng.es.service.ExecutorServiceEntryPoint;
import org.jbpm.console.ng.ga.model.PortableQueryFilter;
import org.jbpm.console.ng.gc.client.list.base.AbstractListView;
import org.jbpm.console.ng.gc.client.list.base.AbstractScreenListPresenter;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberView;
import org.uberfire.mvp.Command;
import org.uberfire.paging.PageResponse;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;
import org.uberfire.workbench.model.menu.impl.BaseMenuCustom;

@Dependent
@WorkbenchScreen(identifier="Requests List")
public class RequestListPresenter
extends AbstractScreenListPresenter<RequestSummary> {
    public static String FILTER_STATUSES_PARAM_NAME = "states";
    private Constants constants = (Constants)GWT.create(Constants.class);
    @Inject
    private RequestListView view;
    @Inject
    private Caller<ExecutorServiceEntryPoint> executorServices;
    @Inject
    private Event<RequestChangedEvent> requestChangedEvent;
    private List<String> currentActiveStates;
    @Inject
    private JobServiceSettingsPopup jobServiceSettingsPopup;
    @Inject
    private QuickNewJobPopup quickNewJobPopup;
    public Button menuActionsButton;
    private PopupPanel popup = new PopupPanel(true);
    public Button menuRefreshButton = new Button();
    public Button menuResetTabsButton = new Button();

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.RequestsListTitle();
    }

    @WorkbenchPartView
    public UberView<RequestListPresenter> getView() {
        return this.view;
    }

    public void refreshRequests(List<String> statuses) {
        this.currentActiveStates = statuses;
        this.refreshGrid();
    }

    public void init() {
        ((ExecutorServiceEntryPoint)this.executorServices.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                RequestListPresenter.this.view.displayNotification("Executor Service Started ...");
            }
        })).init();
    }

    public void createRequest() {
        HashMap<String, String> ctx = new HashMap<String, String>();
        ctx.put("businessKey", "1234");
        ((ExecutorServiceEntryPoint)this.executorServices.call((RemoteCallback)new RemoteCallback<Long>(){

            public void callback(Long requestId) {
                RequestListPresenter.this.view.displayNotification("Request Schedulled: " + requestId);
            }
        })).scheduleRequest("PrintOutCmd", ctx);
    }

    protected AbstractListView.ListView getListView() {
        return this.view;
    }

    public void getData(Range visibleRange) {
        ColumnSortList columnSortList = this.view.getListGrid().getColumnSortList();
        if (this.currentFilter == null) {
            this.currentFilter = new PortableQueryFilter(visibleRange.getStart(), visibleRange.getLength(), false, "", columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "", columnSortList.size() > 0 ? columnSortList.get(0).isAscending() : true);
        }
        if (this.currentFilter.getParams() == null || this.currentFilter.getParams().isEmpty() || this.currentFilter.getParams().get("textSearch") == null || this.currentFilter.getParams().get("textSearch").equals("")) {
            this.currentFilter.setOffset(Integer.valueOf(this.view.getListGrid().getPageStart()));
            this.currentFilter.setCount(Integer.valueOf(this.view.getListGrid().getPageSize()));
        } else {
            this.currentFilter.setOffset(Integer.valueOf(0));
            this.currentFilter.setCount(Integer.valueOf(this.view.getListGrid().getPageSize()));
        }
        if (this.currentFilter.getParams() == null) {
            this.currentFilter.setParams(new HashMap());
        }
        this.currentFilter.getParams().put("states", this.currentActiveStates);
        this.currentFilter.setOrderBy(columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "");
        this.currentFilter.setIsAscending(Boolean.valueOf(columnSortList.size() > 0 ? columnSortList.get(0).isAscending() : true));
        ((ExecutorServiceEntryPoint)this.executorServices.call((RemoteCallback)new RemoteCallback<PageResponse<RequestSummary>>(){

            public void callback(PageResponse<RequestSummary> response) {
                RequestListPresenter.this.updateDataOnCallback(response);
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                RequestListPresenter.this.view.hideBusyIndicator();
                RequestListPresenter.this.view.displayNotification("Error: Getting Jbos Requests: " + message);
                GWT.log((String)throwable.toString());
                return true;
            }
        })).getData(this.currentFilter);
    }

    public void addDataDisplay(HasData<RequestSummary> display) {
        this.dataProvider.addDataDisplay(display);
    }

    public AsyncDataProvider<RequestSummary> getDataProvider() {
        return this.dataProvider;
    }

    public void cancelRequest(final Long requestId) {
        ((ExecutorServiceEntryPoint)this.executorServices.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                RequestListPresenter.this.view.displayNotification("Request " + requestId + " cancelled");
                RequestListPresenter.this.requestChangedEvent.fire((Object)new RequestChangedEvent(requestId));
            }
        })).cancelRequest(requestId);
    }

    public void requeueRequest(final Long requestId) {
        ((ExecutorServiceEntryPoint)this.executorServices.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                RequestListPresenter.this.view.displayNotification("Request " + requestId + " cancelled");
                RequestListPresenter.this.requestChangedEvent.fire((Object)new RequestChangedEvent(requestId));
            }
        })).requeueRequest(requestId);
    }

    @WorkbenchMenu
    public Menus getMenus() {
        this.setupButtons();
        return ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)Constants.INSTANCE.New_Job()).respondsWith(new Command(){

            public void execute() {
                RequestListPresenter.this.quickNewJobPopup.show();
            }
        })).endMenu()).newTopLevelMenu(Constants.INSTANCE.Job_Service_Settings()).respondsWith(new Command(){

            public void execute() {
                RequestListPresenter.this.jobServiceSettingsPopup.show();
            }
        })).endMenu()).newTopLevelCustomMenu(new MenuFactory.CustomMenuBuilder(){

            public void push(MenuFactory.CustomMenuBuilder element) {
            }

            public MenuItem build() {
                return new BaseMenuCustom<IsWidget>(){

                    public IsWidget build() {
                        RequestListPresenter.this.menuRefreshButton.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent clickEvent) {
                                RequestListPresenter.this.refreshGrid();
                            }
                        });
                        return RequestListPresenter.this.menuRefreshButton;
                    }

                    public boolean isEnabled() {
                        return true;
                    }

                    public void setEnabled(boolean enabled) {
                    }

                    public String getSignatureId() {
                        return "org.jbpm.console.ng.es.client.editors.requestlist.RequestListPresenter#menuRefreshButton";
                    }
                };
            }
        }).endMenu()).newTopLevelCustomMenu(new MenuFactory.CustomMenuBuilder(){

            public void push(MenuFactory.CustomMenuBuilder element) {
            }

            public MenuItem build() {
                return new BaseMenuCustom<IsWidget>(){

                    public IsWidget build() {
                        return RequestListPresenter.this.menuActionsButton;
                    }

                    public boolean isEnabled() {
                        return true;
                    }

                    public void setEnabled(boolean enabled) {
                    }

                    public String getSignatureId() {
                        return "org.jbpm.console.ng.es.client.editors.requestlist.RequestListPresenter#menuActionsButton";
                    }
                };
            }
        }).endMenu()).newTopLevelCustomMenu(new MenuFactory.CustomMenuBuilder(){

            public void push(MenuFactory.CustomMenuBuilder element) {
            }

            public MenuItem build() {
                return new BaseMenuCustom<IsWidget>(){

                    public IsWidget build() {
                        RequestListPresenter.this.menuResetTabsButton.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent clickEvent) {
                                RequestListPresenter.this.view.restoreTabs();
                            }
                        });
                        return RequestListPresenter.this.menuResetTabsButton;
                    }

                    public boolean isEnabled() {
                        return true;
                    }

                    public void setEnabled(boolean enabled) {
                    }

                    public String getSignatureId() {
                        return "org.jbpm.console.ng.es.client.editors.requestlist.RequestListPresenter#menuResetTabsButton";
                    }
                };
            }
        }).endMenu()).build();
    }

    public void setupButtons() {
        this.menuActionsButton = new Button();
        this.createRefreshToggleButton(this.menuActionsButton);
        this.menuRefreshButton.setIcon(IconType.REFRESH);
        this.menuRefreshButton.setSize(ButtonSize.MINI);
        this.menuRefreshButton.setTitle(Constants.INSTANCE.Refresh());
        this.menuResetTabsButton.setIcon(IconType.TH_LIST);
        this.menuResetTabsButton.setSize(ButtonSize.MINI);
        this.menuResetTabsButton.setTitle(Constants.INSTANCE.RestoreDefaultFilters());
    }

    public void createRefreshToggleButton(final Button refreshIntervalSelector) {
        refreshIntervalSelector.setToggle(true);
        refreshIntervalSelector.setIcon(IconType.COG);
        refreshIntervalSelector.setTitle(Constants.INSTANCE.AutoRefresh());
        refreshIntervalSelector.setSize(ButtonSize.MINI);
        this.popup.getElement().getStyle().setZIndex(Integer.MAX_VALUE);
        this.popup.addAutoHidePartner((Element)refreshIntervalSelector.getElement());
        this.popup.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

            public void onClose(CloseEvent<PopupPanel> popupPanelCloseEvent) {
                if (popupPanelCloseEvent.isAutoClosed()) {
                    refreshIntervalSelector.setActive(false);
                }
            }
        });
        refreshIntervalSelector.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!refreshIntervalSelector.isActive()) {
                    RequestListPresenter.this.showSelectRefreshIntervalPopup(refreshIntervalSelector.getAbsoluteLeft() + refreshIntervalSelector.getOffsetWidth(), refreshIntervalSelector.getAbsoluteTop() + refreshIntervalSelector.getOffsetHeight(), refreshIntervalSelector);
                } else {
                    RequestListPresenter.this.popup.hide(false);
                }
            }
        });
    }

    private void showSelectRefreshIntervalPopup(int left, int top, final Button refreshIntervalSelector) {
        VerticalPanel popupContent = new VerticalPanel();
        int configuredSeconds = this.view.getRefreshValue();
        if (configuredSeconds > 0) {
            this.updateRefreshInterval(true, configuredSeconds);
        } else {
            this.updateRefreshInterval(false, 0);
        }
        RadioButton oneMinuteRadioButton = this.createTimeSelectorRadioButton(60, "1 Minute", configuredSeconds, refreshIntervalSelector, popupContent);
        RadioButton fiveMinuteRadioButton = this.createTimeSelectorRadioButton(300, "5 Minutes", configuredSeconds, refreshIntervalSelector, popupContent);
        RadioButton tenMinuteRadioButton = this.createTimeSelectorRadioButton(600, "10 Minutes", configuredSeconds, refreshIntervalSelector, popupContent);
        popupContent.add((Widget)oneMinuteRadioButton);
        popupContent.add((Widget)fiveMinuteRadioButton);
        popupContent.add((Widget)tenMinuteRadioButton);
        Button resetButton = new Button(Constants.INSTANCE.Disable());
        resetButton.setSize(ButtonSize.MINI);
        resetButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                RequestListPresenter.this.updateRefreshInterval(false, 0);
                RequestListPresenter.this.view.saveRefreshValue(0);
                refreshIntervalSelector.setActive(false);
                RequestListPresenter.this.popup.hide();
            }
        });
        popupContent.add((Widget)resetButton);
        this.popup.setWidget((Widget)popupContent);
        this.popup.show();
        int finalLeft = left - this.popup.getOffsetWidth();
        this.popup.setPopupPosition(finalLeft, top);
    }

    private RadioButton createTimeSelectorRadioButton(int time, String name, int configuredSeconds, final Button refreshIntervalSelector, VerticalPanel popupContent) {
        RadioButton oneMinuteRadioButton = new RadioButton("refreshInterval", name);
        oneMinuteRadioButton.setText(name);
        final int selectedRefreshTime = time;
        if (configuredSeconds == selectedRefreshTime) {
            oneMinuteRadioButton.setValue(Boolean.valueOf(true));
        }
        oneMinuteRadioButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                RequestListPresenter.this.updateRefreshInterval(true, selectedRefreshTime);
                RequestListPresenter.this.view.saveRefreshValue(selectedRefreshTime);
                refreshIntervalSelector.setActive(false);
                RequestListPresenter.this.popup.hide();
            }
        });
        return oneMinuteRadioButton;
    }

    public static interface RequestListView
    extends AbstractListView.ListView<RequestSummary, RequestListPresenter> {
        public int getRefreshValue();

        public void restoreTabs();

        public void saveRefreshValue(int var1);
    }
}

