/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.es.client.editors.requestlist;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.df.client.filter.FilterSettings;
import org.jbpm.console.ng.df.client.list.base.DataSetQueryHelper;
import org.jbpm.console.ng.es.client.editors.quicknewjob.QuickNewJobPopup;
import org.jbpm.console.ng.es.client.editors.requestlist.RequestListViewImpl;
import org.jbpm.console.ng.es.client.editors.servicesettings.JobServiceSettingsPopup;
import org.jbpm.console.ng.es.client.i18n.Constants;
import org.jbpm.console.ng.es.model.RequestSummary;
import org.jbpm.console.ng.es.model.events.RequestChangedEvent;
import org.jbpm.console.ng.es.service.ExecutorServiceEntryPoint;
import org.jbpm.console.ng.gc.client.list.base.AbstractListPresenter;
import org.jbpm.console.ng.gc.client.list.base.AbstractListView;
import org.jbpm.console.ng.gc.client.list.base.AbstractScreenListPresenter;
import org.jbpm.console.ng.gc.client.list.base.RefreshSelectorMenuBuilder;
import org.jbpm.console.ng.gc.client.list.base.events.SearchEvent;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.mvp.Command;
import org.uberfire.paging.PageResponse;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;
import org.uberfire.workbench.model.menu.impl.BaseMenuCustom;

@Dependent
@WorkbenchScreen(identifier="Requests List")
public class RequestListPresenter
extends AbstractScreenListPresenter<RequestSummary> {
    private Constants constants = (Constants)GWT.create(Constants.class);
    @Inject
    private RequestListView view;
    @Inject
    private Caller<ExecutorServiceEntryPoint> executorServices;
    @Inject
    private Event<RequestChangedEvent> requestChangedEvent;
    @Inject
    DataSetQueryHelper dataSetQueryHelper;
    private List<String> currentActiveStates;
    @Inject
    private JobServiceSettingsPopup jobServiceSettingsPopup;
    @Inject
    private QuickNewJobPopup quickNewJobPopup;
    private RefreshSelectorMenuBuilder refreshSelectorMenuBuilder = new RefreshSelectorMenuBuilder((AbstractListPresenter)this);
    @Inject
    private ErrorPopupPresenter errorPopup;

    public RequestListPresenter() {
    }

    public RequestListPresenter(RequestListViewImpl view, Caller<ExecutorServiceEntryPoint> executorServices, DataSetQueryHelper dataSetQueryHelper, Event<RequestChangedEvent> requestChangedEvent) {
        this.view = view;
        this.executorServices = executorServices;
        this.dataSetQueryHelper = dataSetQueryHelper;
        this.requestChangedEvent = requestChangedEvent;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.RequestsListTitle();
    }

    @WorkbenchPartView
    public UberView<RequestListPresenter> getView() {
        return this.view;
    }

    public void filterGrid(FilterSettings tableSettings) {
        this.dataSetQueryHelper.setCurrentTableSettings(tableSettings);
        this.refreshGrid();
    }

    public void init() {
        ((ExecutorServiceEntryPoint)this.executorServices.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                RequestListPresenter.this.view.displayNotification("Executor Service Started ...");
            }
        })).init();
    }

    public void createRequest() {
        HashMap<String, String> ctx = new HashMap<String, String>();
        ctx.put("businessKey", "1234");
        ((ExecutorServiceEntryPoint)this.executorServices.call((RemoteCallback)new RemoteCallback<Long>(){

            public void callback(Long requestId) {
                RequestListPresenter.this.view.displayNotification("Request Schedulled: " + requestId);
            }
        })).scheduleRequest("PrintOutCmd", ctx);
    }

    protected AbstractListView.ListView getListView() {
        return this.view;
    }

    public void getData(final Range visibleRange) {
        try {
            FilterSettings currentTableSettings;
            if (!this.isAddingDefaultFilters() && (currentTableSettings = this.dataSetQueryHelper.getCurrentTableSettings()) != null) {
                currentTableSettings.setTablePageSize(this.view.getListGrid().getPageSize());
                ColumnSortList columnSortList = this.view.getListGrid().getColumnSortList();
                if (columnSortList != null && columnSortList.size() > 0) {
                    this.dataSetQueryHelper.setLastOrderedColumn(columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "");
                    this.dataSetQueryHelper.setLastSortOrder(columnSortList.size() > 0 && columnSortList.get(0).isAscending() ? SortOrder.ASCENDING : SortOrder.DESCENDING);
                } else {
                    this.dataSetQueryHelper.setLastOrderedColumn("timestamp");
                    this.dataSetQueryHelper.setLastSortOrder(SortOrder.ASCENDING);
                }
                if (this.textSearchStr != null && this.textSearchStr.trim().length() > 0) {
                    DataSetFilter filter = new DataSetFilter();
                    ArrayList<ColumnFilter> filters = new ArrayList<ColumnFilter>();
                    filters.add(FilterFactory.likeTo((String)"commandName", (String)("%" + this.textSearchStr.toLowerCase() + "%"), (boolean)false));
                    filters.add(FilterFactory.likeTo((String)"message", (String)("%" + this.textSearchStr.toLowerCase() + "%"), (boolean)false));
                    filters.add(FilterFactory.likeTo((String)"businessKey", (String)("%" + this.textSearchStr.toLowerCase() + "%"), (boolean)false));
                    filter.addFilterColumn(new ColumnFilter[]{FilterFactory.OR(filters)});
                    if (currentTableSettings.getDataSetLookup().getFirstFilterOp() != null) {
                        currentTableSettings.getDataSetLookup().getFirstFilterOp().addFilterColumn(new ColumnFilter[]{FilterFactory.OR(filters)});
                    } else {
                        currentTableSettings.getDataSetLookup().addOperation(new DataSetOp[]{filter});
                    }
                    this.textSearchStr = "";
                }
                this.dataSetQueryHelper.setDataSetHandler(currentTableSettings);
                this.dataSetQueryHelper.lookupDataSet(Integer.valueOf(visibleRange.getStart()), new DataSetReadyCallback(){

                    public void callback(DataSet dataSet) {
                        if (dataSet != null) {
                            ArrayList<RequestSummary> myRequestSumaryFromDataSet = new ArrayList<RequestSummary>();
                            for (int i = 0; i < dataSet.getRowCount(); ++i) {
                                myRequestSumaryFromDataSet.add(new RequestSummary(RequestListPresenter.this.dataSetQueryHelper.getColumnLongValue(dataSet, "id", i), RequestListPresenter.this.dataSetQueryHelper.getColumnDateValue(dataSet, "timestamp", i), RequestListPresenter.this.dataSetQueryHelper.getColumnStringValue(dataSet, "status", i), RequestListPresenter.this.dataSetQueryHelper.getColumnStringValue(dataSet, "commandName", i), RequestListPresenter.this.dataSetQueryHelper.getColumnStringValue(dataSet, "message", i), RequestListPresenter.this.dataSetQueryHelper.getColumnStringValue(dataSet, "businessKey", i)));
                            }
                            PageResponse requestSummaryPageResponse = new PageResponse();
                            requestSummaryPageResponse.setPageRowList(myRequestSumaryFromDataSet);
                            requestSummaryPageResponse.setStartRowIndex(visibleRange.getStart());
                            requestSummaryPageResponse.setTotalRowSize(dataSet.getRowCountNonTrimmed());
                            requestSummaryPageResponse.setTotalRowSizeExact(true);
                            if (visibleRange.getStart() + dataSet.getRowCount() == dataSet.getRowCountNonTrimmed()) {
                                requestSummaryPageResponse.setLastPage(true);
                            } else {
                                requestSummaryPageResponse.setLastPage(false);
                            }
                            RequestListPresenter.this.updateDataOnCallback(requestSummaryPageResponse);
                        }
                    }

                    public void notFound() {
                        RequestListPresenter.this.errorPopup.showMessage("Not found DataSet with UUID [  jbpmRequestList ] ");
                        GWT.log((String)"DataSet with UUID [  jbpmRequestList ] not found.");
                    }

                    public boolean onError(ClientRuntimeError error) {
                        RequestListPresenter.this.errorPopup.showMessage("DataSet with UUID [  jbpmRequestList ] error: " + error.getThrowable());
                        GWT.log((String)"DataSet with UUID [  jbpmRequestList ] error: ", (Throwable)error.getThrowable());
                        return false;
                    }
                });
                this.view.hideBusyIndicator();
            }
        }
        catch (Exception e) {
            GWT.log((String)"Error looking up dataset with UUID [ jbpmRequestList ]");
        }
    }

    public AsyncDataProvider<RequestSummary> getDataProvider() {
        return this.dataProvider;
    }

    public void cancelRequest(final Long requestId) {
        ((ExecutorServiceEntryPoint)this.executorServices.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                RequestListPresenter.this.view.displayNotification("Request " + requestId + " cancelled");
                RequestListPresenter.this.requestChangedEvent.fire((Object)new RequestChangedEvent(requestId));
            }
        })).cancelRequest(requestId);
    }

    public void requeueRequest(final Long requestId) {
        ((ExecutorServiceEntryPoint)this.executorServices.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                RequestListPresenter.this.view.displayNotification("Request " + requestId + " cancelled");
                RequestListPresenter.this.requestChangedEvent.fire((Object)new RequestChangedEvent(requestId));
            }
        })).requeueRequest(requestId);
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)Constants.INSTANCE.New_Job()).respondsWith(new Command(){

            public void execute() {
                ((ExecutorServiceEntryPoint)RequestListPresenter.this.executorServices.call((RemoteCallback)new RemoteCallback<Boolean>(){

                    public void callback(Boolean isDisabled) {
                        if (isDisabled.booleanValue()) {
                            RequestListPresenter.this.view.displayNotification("Executor service is disabled");
                        } else {
                            RequestListPresenter.this.quickNewJobPopup.show();
                        }
                    }
                })).isExecutorDisabled();
            }
        })).endMenu()).newTopLevelMenu(Constants.INSTANCE.Job_Service_Settings()).respondsWith(new Command(){

            public void execute() {
                ((ExecutorServiceEntryPoint)RequestListPresenter.this.executorServices.call((RemoteCallback)new RemoteCallback<Boolean>(){

                    public void callback(Boolean isDisabled) {
                        if (isDisabled.booleanValue()) {
                            RequestListPresenter.this.view.displayNotification("Executor service is disabled");
                        } else {
                            RequestListPresenter.this.jobServiceSettingsPopup.show();
                        }
                    }
                })).isExecutorDisabled();
            }
        })).endMenu()).newTopLevelCustomMenu(new MenuFactory.CustomMenuBuilder(){

            public void push(MenuFactory.CustomMenuBuilder element) {
            }

            public MenuItem build() {
                return new BaseMenuCustom<IsWidget>(){

                    public IsWidget build() {
                        RequestListPresenter.this.menuRefreshButton.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent clickEvent) {
                                RequestListPresenter.this.refreshGrid();
                            }
                        });
                        return RequestListPresenter.this.menuRefreshButton;
                    }

                    public boolean isEnabled() {
                        return true;
                    }

                    public void setEnabled(boolean enabled) {
                    }

                    public String getSignatureId() {
                        return "org.jbpm.console.ng.es.client.editors.requestlist.RequestListPresenter#menuRefreshButton";
                    }
                };
            }
        }).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)this.refreshSelectorMenuBuilder).endMenu()).newTopLevelCustomMenu(new MenuFactory.CustomMenuBuilder(){

            public void push(MenuFactory.CustomMenuBuilder element) {
            }

            public MenuItem build() {
                return new BaseMenuCustom<IsWidget>(){

                    public IsWidget build() {
                        RequestListPresenter.this.menuResetTabsButton.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent clickEvent) {
                                RequestListPresenter.this.view.restoreTabs();
                            }
                        });
                        return RequestListPresenter.this.menuResetTabsButton;
                    }

                    public boolean isEnabled() {
                        return true;
                    }

                    public void setEnabled(boolean enabled) {
                    }

                    public String getSignatureId() {
                        return "org.jbpm.console.ng.es.client.editors.requestlist.RequestListPresenter#menuResetTabsButton";
                    }
                };
            }
        }).endMenu()).build();
    }

    public void onGridPreferencesStoreLoaded() {
        this.refreshSelectorMenuBuilder.loadOptions(this.view.getRefreshValue());
    }

    protected void onSearchEvent(@Observes SearchEvent searchEvent) {
        this.textSearchStr = searchEvent.getFilter();
        if (this.textSearchStr != null && this.textSearchStr.trim().length() > 0) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("textSearch", this.textSearchStr);
            this.dataSetQueryHelper.getCurrentTableSettings().getKey();
            this.view.applyFilterOnPresenter(this.dataSetQueryHelper.getCurrentTableSettings().getKey());
        }
    }

    protected void updateRefreshInterval(boolean enableAutoRefresh, int newInterval) {
        super.updateRefreshInterval(enableAutoRefresh, newInterval);
        this.view.saveRefreshValue(newInterval);
    }

    public static interface RequestListView
    extends AbstractListView.ListView<RequestSummary, RequestListPresenter> {
        public int getRefreshValue();

        public void restoreTabs();

        public void saveRefreshValue(int var1);

        public void applyFilterOnPresenter(String var1);
    }
}

