/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.backend.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.console.ng.ht.model.fb.events.PaletteItemAddedEvent;
import org.jbpm.console.ng.ht.service.FormServiceEntryPoint;
import org.jbpm.form.builder.services.api.FormBuilderService;
import org.jbpm.form.builder.services.api.FormBuilderServiceException;
import org.jbpm.form.builder.services.api.MenuService;
import org.jbpm.form.builder.services.api.MenuServiceException;
import org.jbpm.form.builder.services.encoders.FormRepresentationDecoderImpl;
import org.jbpm.form.builder.services.encoders.FormRepresentationEncoderImpl;
import org.jbpm.form.builder.services.model.FormItemRepresentation;
import org.jbpm.form.builder.services.model.FormRepresentation;
import org.jbpm.form.builder.services.model.forms.FormEncodingException;
import org.jbpm.form.builder.services.model.forms.FormEncodingFactory;
import org.jbpm.form.builder.services.model.forms.FormRepresentationDecoder;
import org.jbpm.form.builder.services.model.forms.FormRepresentationEncoder;
import org.jbpm.form.builder.services.model.menu.MenuItemDescription;
import org.jbpm.form.builder.services.model.menu.MenuOptionDescription;
import org.jbpm.kie.services.api.FormProviderService;
import org.jbpm.shared.services.api.FileService;

@Service
@ApplicationScoped
@Transactional
public class FormServiceEntryPointImpl
implements FormServiceEntryPoint {
    @Inject
    private MenuService menuService;
    @Inject
    private FileService fileService;
    @Inject
    private FormProviderService displayService;
    @Inject
    private FormBuilderService formService;
    @Inject
    Event<PaletteItemAddedEvent> itemAddedEvents;

    @PostConstruct
    public void init() {
        FormEncodingFactory.register((FormRepresentationEncoder)new FormRepresentationEncoderImpl(), (FormRepresentationDecoder)new FormRepresentationDecoderImpl());
    }

    public List<Map<String, Object>> listOptions() {
        try {
            List options = this.menuService.listOptions();
            ArrayList<Map<String, Object>> retval = new ArrayList<Map<String, Object>>();
            for (MenuOptionDescription option : options) {
                retval.add(option.getDataMap());
            }
            return retval;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Logger.getLogger(FormServiceEntryPointImpl.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public void listMenuItems() {
        try {
            Map listMenuItems = this.menuService.listMenuItems();
            for (String groupName : listMenuItems.keySet()) {
                for (MenuItemDescription itemDesc : (List)listMenuItems.get(groupName)) {
                    Map itemDescMap = itemDesc.getDataMap();
                    this.itemAddedEvents.fire((Object)new PaletteItemAddedEvent(itemDescMap, groupName));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Logger.getLogger(FormServiceEntryPointImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public Map<String, String> getFormBuilderProperties() {
        try {
            return this.menuService.getFormBuilderProperties();
        }
        catch (MenuServiceException ex) {
            ex.printStackTrace();
            Logger.getLogger(FormServiceEntryPointImpl.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public String getFormDisplayTask(long taskId) {
        return this.displayService.getFormDisplayTask(taskId);
    }

    public String saveForm(Map<String, Object> form) {
        try {
            Object obj = FormEncodingFactory.getDecoder().decode(form);
            if (obj != null && obj instanceof FormRepresentation) {
                return this.formService.saveForm((FormRepresentation)form);
            }
        }
        catch (FormBuilderServiceException ex) {
            Logger.getLogger(FormServiceEntryPointImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (FormEncodingException ex) {
            Logger.getLogger(FormServiceEntryPointImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    public void saveFormItem(Map<String, Object> formItem, String formItemName) {
        try {
            Object obj = FormEncodingFactory.getDecoder().decode(formItem);
            if (obj != null && obj instanceof FormItemRepresentation) {
                this.formService.saveFormItem((FormItemRepresentation)obj, formItemName);
            }
        }
        catch (FormBuilderServiceException ex) {
            Logger.getLogger(FormServiceEntryPointImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (FormEncodingException ex) {
            Logger.getLogger(FormServiceEntryPointImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public Map<String, Object> loadForm(String json) {
        FormRepresentation form = this.formService.loadForm(json);
        Map formMap = form == null ? null : form.getDataMap();
        return formMap;
    }

    public String getFormDisplayProcess(String domainId, String processId) {
        return this.displayService.getFormDisplayProcess(domainId, processId);
    }
}

