/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.backend.server;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.console.ng.ga.model.QueryFilter;
import org.jbpm.console.ng.ht.backend.server.TaskEventSummaryHelper;
import org.jbpm.console.ng.ht.model.TaskEventKey;
import org.jbpm.console.ng.ht.model.TaskEventSummary;
import org.jbpm.console.ng.ht.service.TaskAuditService;
import org.jbpm.services.task.query.QueryFilterImpl;
import org.kie.api.task.TaskService;
import org.kie.internal.task.api.InternalTaskService;
import org.uberfire.paging.PageResponse;

@Service
@ApplicationScoped
public class TaskAuditServiceImpl
implements TaskAuditService {
    @Inject
    private org.jbpm.services.task.audit.service.TaskAuditService taskAuditService;
    @Inject
    private InternalTaskService taskService;

    @PostConstruct
    private void init() {
        this.taskAuditService.setTaskService((TaskService)this.taskService);
    }

    public PageResponse<TaskEventSummary> getData(QueryFilter filter) {
        PageResponse response = new PageResponse();
        Long taskId = null;
        if (filter.getParams() != null) {
            taskId = (Long)filter.getParams().get("taskId");
        }
        int filterCount = 0;
        if (filter.getCount() != 0) {
            filterCount = filter.getCount() + 1;
        }
        QueryFilterImpl qf = new QueryFilterImpl(filter.getOffset().intValue(), filterCount, filter.getOrderBy(), filter.isAscending().booleanValue());
        List<TaskEventSummary> taskEventSummaries = TaskEventSummaryHelper.adaptCollection(this.taskAuditService.getAllTaskEvents(taskId.longValue(), (org.kie.internal.query.QueryFilter)qf));
        response.setStartRowIndex(filter.getOffset().intValue());
        if (filter.getCount() != 0) {
            response.setTotalRowSize(taskEventSummaries.size() - 1);
        }
        if (taskEventSummaries.size() > filter.getCount() && filter.getCount() != 0) {
            response.setTotalRowSizeExact(false);
        } else {
            response.setTotalRowSizeExact(true);
        }
        if (!taskEventSummaries.isEmpty() && filter.getCount() != 0 && taskEventSummaries.size() > filter.getCount() + filter.getOffset()) {
            response.setPageRowList(new ArrayList<TaskEventSummary>(taskEventSummaries.subList(filter.getOffset(), filter.getOffset() + filter.getCount())));
            response.setLastPage(false);
        } else {
            response.setPageRowList(new ArrayList<TaskEventSummary>(taskEventSummaries));
            response.setLastPage(true);
        }
        return response;
    }

    public TaskEventSummary getItem(TaskEventKey key) {
        return null;
    }
}

