/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.backend.server;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.console.ng.ga.model.QueryFilter;
import org.jbpm.console.ng.ht.backend.server.TaskEventSummaryHelper;
import org.jbpm.console.ng.ht.model.TaskEventKey;
import org.jbpm.console.ng.ht.model.TaskEventSummary;
import org.jbpm.console.ng.ht.service.TaskAuditService;
import org.jbpm.services.api.RuntimeDataService;
import org.kie.api.task.TaskService;
import org.kie.internal.task.api.InternalTaskService;
import org.uberfire.paging.PageResponse;

@Service
@ApplicationScoped
public class TaskAuditServiceImpl
implements TaskAuditService {
    @Inject
    private org.jbpm.services.task.audit.service.TaskAuditService taskAuditService;
    @Inject
    private RuntimeDataService runtimeDataService;
    @Inject
    private InternalTaskService taskService;

    @PostConstruct
    private void init() {
        this.taskAuditService.setTaskService((TaskService)this.taskService);
    }

    public PageResponse<TaskEventSummary> getData(QueryFilter filter) {
        PageResponse response = new PageResponse();
        List<TaskEventSummary> taskEventSummaries = this.getTaskEvents(filter);
        response.setStartRowIndex(filter.getOffset().intValue());
        if (filter.getCount() != 0) {
            response.setTotalRowSize(taskEventSummaries.size() - 1);
        }
        if (taskEventSummaries.size() > filter.getCount() && filter.getCount() != 0) {
            response.setTotalRowSizeExact(false);
        } else {
            response.setTotalRowSizeExact(true);
        }
        if (!taskEventSummaries.isEmpty() && filter.getCount() != 0 && taskEventSummaries.size() > filter.getCount() + filter.getOffset()) {
            response.setPageRowList(new ArrayList<TaskEventSummary>(taskEventSummaries.subList(filter.getOffset(), filter.getOffset() + filter.getCount())));
            response.setLastPage(false);
        } else {
            response.setPageRowList(new ArrayList<TaskEventSummary>(taskEventSummaries));
            response.setLastPage(true);
        }
        return response;
    }

    private List<TaskEventSummary> getTaskEvents(QueryFilter filter) {
        Long taskId = null;
        if (filter.getParams() != null) {
            taskId = (Long)filter.getParams().get("taskId");
        }
        int filterCount = 0;
        if (filter.getCount() != 0) {
            filterCount = filter.getCount() + 1;
        }
        org.kie.internal.query.QueryFilter qf = new org.kie.internal.query.QueryFilter(filter.getOffset().intValue(), filterCount, filter.getOrderBy(), filter.isAscending().booleanValue());
        List<TaskEventSummary> taskEventSummaries = TaskEventSummaryHelper.adaptCollection(this.runtimeDataService.getTaskEvents(taskId.longValue(), qf));
        return taskEventSummaries;
    }

    public TaskEventSummary getItem(TaskEventKey key) {
        return null;
    }

    public List<TaskEventSummary> getAllTaskEventsByProcessInstanceId(long processInstanceId, String filter) {
        return TaskEventSummaryHelper.adaptCollection(this.taskAuditService.getAllTaskEventsByProcessInstanceId(processInstanceId, new org.kie.internal.query.QueryFilter(0, 0)));
    }

    public List<TaskEventSummary> getAll(QueryFilter filter) {
        return this.getTaskEvents(filter);
    }
}

