/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.backend.server;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.console.ng.ga.model.QueryFilter;
import org.jbpm.console.ng.ht.backend.server.TaskSummaryHelper;
import org.jbpm.console.ng.ht.model.TaskKey;
import org.jbpm.console.ng.ht.model.TaskSummary;
import org.jbpm.console.ng.ht.service.TaskQueryService;
import org.jbpm.services.api.RuntimeDataService;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.InternalTaskService;
import org.uberfire.paging.PageResponse;

@Service
@ApplicationScoped
public class TaskQueryServiceImpl
implements TaskQueryService {
    @Inject
    private InternalTaskService taskService;
    @Inject
    private RuntimeDataService runtimeDataService;

    public PageResponse<TaskSummary> getData(QueryFilter filter) {
        PageResponse response = new PageResponse();
        List<TaskSummary> taskSummaries = this.getTasks(filter);
        response.setStartRowIndex(filter.getOffset().intValue());
        response.setTotalRowSize(taskSummaries.size() - 1);
        if (taskSummaries.size() > filter.getCount()) {
            response.setTotalRowSizeExact(false);
        } else {
            response.setTotalRowSizeExact(true);
        }
        if (!taskSummaries.isEmpty() && taskSummaries.size() > filter.getCount() + filter.getOffset()) {
            response.setPageRowList(new ArrayList<TaskSummary>(taskSummaries.subList(filter.getOffset(), filter.getOffset() + filter.getCount())));
            response.setLastPage(false);
        } else {
            response.setPageRowList(new ArrayList<TaskSummary>(taskSummaries));
            response.setLastPage(true);
        }
        return response;
    }

    private List<TaskSummary> getTasks(QueryFilter filter) {
        List statusesString = null;
        String userId = "";
        String taskRole = "";
        String stringFilter = "";
        if (filter.getParams() != null) {
            userId = (String)filter.getParams().get("userId");
            statusesString = (List)filter.getParams().get("statuses");
            taskRole = (String)filter.getParams().get("taskRole");
            stringFilter = (String)filter.getParams().get("filter");
        }
        ArrayList<Status> statuses = new ArrayList<Status>();
        if (statusesString != null) {
            for (String s : statusesString) {
                statuses.add(Status.valueOf((String)s));
            }
        }
        org.kie.internal.query.QueryFilter qf = new org.kie.internal.query.QueryFilter(filter.getOffset().intValue(), filter.getCount() + 1, filter.getOrderBy(), filter.isAscending().booleanValue());
        qf.setFilterParams(filter.getFilterParams());
        List<TaskSummary> taskSummaries = null;
        if ("Administrator".equals(taskRole)) {
            List allAdminAuditTask = this.runtimeDataService.getAllAdminAuditTask(userId, qf);
            taskSummaries = TaskSummaryHelper.adaptAuditCollection(allAdminAuditTask);
        } else if ("ALL".equals(stringFilter)) {
            if (qf.getOrderBy().equals("t.taskData.expirationTime")) {
                qf.setOrderBy("t.dueDate");
            } else if (qf.getOrderBy().equals("t.taskData.createdOn")) {
                qf.setOrderBy("t.createdOn");
            } else if (qf.getOrderBy().equals("t.taskData.status")) {
                qf.setOrderBy("t.status");
            }
            taskSummaries = TaskSummaryHelper.adaptAuditCollection(this.runtimeDataService.getAllAuditTask(userId, qf));
        } else {
            List allAuditTask = statuses.size() == 1 && ((Status)statuses.get(0)).equals((Object)Status.Ready) ? this.runtimeDataService.getAllGroupAuditTask(userId, qf) : this.runtimeDataService.getAllAuditTask(userId, qf);
            taskSummaries = TaskSummaryHelper.adaptAuditCollection(allAuditTask);
        }
        return taskSummaries;
    }

    public TaskSummary getItem(TaskKey key) {
        Task task = this.taskService.getTaskById(key.getTaskId().longValue());
        if (task != null) {
            List potentialOwners = task.getPeopleAssignments().getPotentialOwners();
            ArrayList<String> potOwnersString = null;
            if (potentialOwners != null) {
                potOwnersString = new ArrayList<String>(potentialOwners.size());
                for (OrganizationalEntity e : potentialOwners) {
                    potOwnersString.add(e.getId());
                }
            }
            return new TaskSummary(task.getId().longValue(), task.getName(), task.getDescription(), task.getTaskData().getStatus().name(), task.getPriority(), task.getTaskData().getActualOwner() != null ? task.getTaskData().getActualOwner().getId() : "", task.getTaskData().getCreatedBy() != null ? task.getTaskData().getCreatedBy().getId() : "", task.getTaskData().getCreatedOn(), task.getTaskData().getActivationTime(), task.getTaskData().getExpirationTime(), task.getTaskData().getProcessId(), task.getTaskData().getProcessSessionId(), task.getTaskData().getProcessInstanceId(), task.getTaskData().getDeploymentId(), (long)((int)task.getTaskData().getParentId()));
        }
        return null;
    }

    public List<TaskSummary> getAll(QueryFilter filter) {
        return this.getTasks(filter);
    }
}

