/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.backend.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.console.ng.ht.model.TaskAssignmentSummary;
import org.jbpm.console.ng.ht.model.TaskSummary;
import org.jbpm.console.ng.ht.service.TaskOperationsService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.UserTaskService;
import org.jbpm.services.task.utils.TaskFluent;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.InternalTaskService;

@Service
@ApplicationScoped
public class TaskOperationsServiceImpl
implements TaskOperationsService {
    @Inject
    private InternalTaskService internalTaskService;
    @Inject
    private UserTaskService taskService;
    @Inject
    private RuntimeDataService runtimeDataService;

    public long addQuickTask(String taskName, int priority, Date dueDate, List<String> users, List<String> groups, String identity, boolean start, boolean claim, String taskformName, String deploymentId, Long processInstanceId) {
        TaskFluent taskFluent = new TaskFluent().setName(taskName).setPriority(priority).setDueDate(dueDate).setFormName(taskformName);
        if (deploymentId != null && !deploymentId.equals("")) {
            taskFluent.setDeploymentID(deploymentId);
        } else {
            taskFluent.setDeploymentID(null);
        }
        if (processInstanceId > 0L) {
            taskFluent.setProcessInstanceId(processInstanceId.longValue());
        }
        for (String user : users) {
            taskFluent.addPotentialUser(user);
        }
        for (String group : groups) {
            taskFluent.addPotentialGroup(group);
        }
        taskFluent.setAdminUser("Administrator");
        taskFluent.setAdminGroup("Administrators");
        long taskId = this.internalTaskService.addTask(taskFluent.getTask(), new HashMap());
        if (start) {
            this.taskService.start(Long.valueOf(taskId), identity);
        }
        if (claim) {
            this.taskService.claim(Long.valueOf(taskId), identity);
        }
        return taskId;
    }

    public void updateTask(long taskId, int priority, List<String> taskDescription, Date dueDate) {
        this.taskService.setPriority(Long.valueOf(taskId), priority);
        if (taskDescription != null) {
            this.taskService.setDescription(Long.valueOf(taskId), taskDescription.get(0));
        }
        if (dueDate != null) {
            this.taskService.setExpirationDate(Long.valueOf(taskId), dueDate);
        }
    }

    public TaskSummary getTaskDetails(long taskId) {
        Task task = this.taskService.getTask(Long.valueOf(taskId));
        if (task != null) {
            List potentialOwners = task.getPeopleAssignments().getPotentialOwners();
            List<String> potOwnersString = this.getPotentialOwnersForTaskIds(potentialOwners);
            return new TaskSummary(task.getId().longValue(), task.getName(), task.getDescription(), task.getTaskData().getStatus().name(), task.getPriority(), task.getTaskData().getActualOwner() != null ? task.getTaskData().getActualOwner().getId() : "", task.getTaskData().getCreatedBy() != null ? task.getTaskData().getCreatedBy().getId() : "", task.getTaskData().getCreatedOn(), task.getTaskData().getActivationTime(), task.getTaskData().getExpirationTime(), task.getTaskData().getProcessId(), task.getTaskData().getProcessSessionId(), task.getTaskData().getProcessInstanceId(), task.getTaskData().getDeploymentId(), (long)((int)task.getTaskData().getParentId()), false, potOwnersString);
        }
        return null;
    }

    public long saveContent(long taskId, Map<String, Object> values) {
        return this.taskService.saveContent(Long.valueOf(taskId), values);
    }

    public boolean existInDatabase(long taskId) {
        return this.runtimeDataService.getTaskById(Long.valueOf(taskId)) != null;
    }

    private List<String> getPotentialOwnersForTaskIds(List<OrganizationalEntity> potentialOwners) {
        ArrayList<String> orgEntitiesSimple = new ArrayList<String>(potentialOwners.size());
        for (OrganizationalEntity entity : potentialOwners) {
            if (entity instanceof Group) {
                orgEntitiesSimple.add("Group:" + entity.getId());
                continue;
            }
            if (!(entity instanceof User)) continue;
            orgEntitiesSimple.add("User:" + entity.getId());
        }
        return orgEntitiesSimple;
    }

    public TaskAssignmentSummary getTaskAssignmentDetails(long taskId) {
        Task task = this.taskService.getTask(Long.valueOf(taskId));
        if (task != null) {
            List potentialOwners = task.getPeopleAssignments().getPotentialOwners();
            List<Object> potOwnersString = null;
            if (potentialOwners != null) {
                potOwnersString = new ArrayList(potentialOwners.size());
                potOwnersString = this.getPotentialOwnersByTaskId(potentialOwners);
            }
            return new TaskAssignmentSummary(task.getId(), task.getName(), task.getTaskData().getActualOwner() != null ? task.getTaskData().getActualOwner().getId() : "", potOwnersString);
        }
        return null;
    }

    private List<String> getPotentialOwnersByTaskId(List<OrganizationalEntity> potentialOwners) {
        ArrayList<String> orgEntitiesSimple = new ArrayList<String>(potentialOwners.size());
        for (OrganizationalEntity entity : potentialOwners) {
            if (entity instanceof Group) {
                orgEntitiesSimple.add("Group:" + entity.getId());
                continue;
            }
            if (!(entity instanceof User)) continue;
            orgEntitiesSimple.add("User:" + entity.getId());
        }
        return orgEntitiesSimple;
    }

    public void executeReminderForTask(long taskId, String fromUser) {
        this.internalTaskService.executeReminderForTask(taskId, fromUser);
    }
}

