/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.forms.backend.server;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.console.ng.bd.integration.AbstractKieServerService;
import org.jbpm.console.ng.ga.forms.service.FormServiceEntryPoint;
import org.jbpm.document.Document;
import org.jbpm.formModeler.kie.services.form.FormManagerService;
import org.jbpm.formModeler.kie.services.form.FormProvider;
import org.jbpm.formModeler.kie.services.form.ProcessDefinition;
import org.jbpm.formModeler.kie.services.form.TaskDefinition;
import org.kie.internal.task.api.ContentMarshallerContext;
import org.kie.server.api.model.instance.TaskInstance;
import org.kie.server.client.DocumentServicesClient;
import org.kie.server.client.KieServicesException;
import org.kie.server.client.ProcessServicesClient;
import org.kie.server.client.UIServicesClient;
import org.kie.server.client.UserTaskServicesClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@ApplicationScoped
public class FormServiceEntryPointImpl
extends AbstractKieServerService
implements FormServiceEntryPoint {
    private static final Logger logger = LoggerFactory.getLogger(FormServiceEntryPointImpl.class);
    @Inject
    private FormManagerService formManagerService;
    private Set<FormProvider> providers;
    @Inject
    @Any
    private Instance<FormProvider> providersInjected;

    @PostConstruct
    public void prepare() {
        TreeSet<FormProvider> providers = new TreeSet<FormProvider>(new Comparator<FormProvider>(){

            @Override
            public int compare(FormProvider o1, FormProvider o2) {
                return o1.getPriority() - o2.getPriority();
            }
        });
        for (FormProvider p : this.providersInjected) {
            providers.add(p);
        }
        this.providers = providers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFormDisplayTask(String serverTemplateId, String domainId, long taskId) {
        Map<String, Object> outputs;
        String registrationKey = serverTemplateId + "@" + domainId + "@" + System.currentTimeMillis();
        DocumentServicesClient documentClient = (DocumentServicesClient)this.getClient(serverTemplateId, domainId, DocumentServicesClient.class);
        UIServicesClient uiServicesClient = (UIServicesClient)this.getClient(serverTemplateId, domainId, UIServicesClient.class);
        UserTaskServicesClient taskClient = (UserTaskServicesClient)this.getClient(serverTemplateId, domainId, UserTaskServicesClient.class);
        TaskInstance task = taskClient.getTaskInstance(domainId, Long.valueOf(taskId), true, true, false);
        if (task == null) {
            throw new RuntimeException("No task found for id " + taskId);
        }
        TaskDefinition taskInstance = new TaskDefinition();
        taskInstance.setId(task.getId());
        taskInstance.setName(task.getName());
        taskInstance.setDescription(task.getDescription());
        taskInstance.setFormName(task.getFormName());
        taskInstance.setDeploymentId(registrationKey);
        taskInstance.setProcessId(task.getProcessId());
        taskInstance.setStatus(task.getStatus());
        HashMap<String, Object> renderContext = new HashMap<String, Object>();
        renderContext.put("task", taskInstance);
        renderContext.put("marshallerContext", new ContentMarshallerContext(null, this.getKieServicesClient(serverTemplateId, domainId).getClassLoader()));
        Map<String, Object> inputs = this.processData(documentClient, task.getInputData());
        if (inputs != null && !inputs.isEmpty()) {
            renderContext.put("inputs", inputs);
            renderContext.putAll(inputs);
        }
        if ((outputs = this.processData(documentClient, task.getOutputData())) != null && !outputs.isEmpty()) {
            renderContext.put("outputs", outputs);
            renderContext.putAll(outputs);
            taskInstance.setOutputIncluded(true);
        }
        try {
            String formContent = uiServicesClient.getTaskForm(domainId, Long.valueOf(taskId));
            if (formContent != null) {
                this.formManagerService.registerForm(registrationKey, task.getFormName() + "-taskform.form", formContent);
            }
        }
        catch (KieServicesException e) {
            logger.debug("Unable to find process form in remote server due to {}", (Object)e.getMessage());
        }
        try {
            for (FormProvider provider : this.providers) {
                String template = provider.render(task.getName(), taskInstance, null, renderContext);
                if (template == null || template.trim().isEmpty()) continue;
                String string = template;
                return string;
            }
        }
        finally {
            this.formManagerService.unRegisterForms(registrationKey);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFormDisplayProcess(String serverTemplateId, String domainId, String processId) {
        ProcessServicesClient processClient = (ProcessServicesClient)this.getClient(serverTemplateId, domainId, ProcessServicesClient.class);
        org.kie.server.api.model.definition.ProcessDefinition processDefinition = processClient.getProcessDefinition(domainId, processId);
        ProcessDefinition processDesc = new ProcessDefinition();
        processDesc.setId(processDefinition.getId());
        processDesc.setName(processDefinition.getName());
        processDesc.setPackageName(processDefinition.getPackageName());
        processDesc.setDeploymentId(serverTemplateId + "@" + processDefinition.getContainerId() + "@" + System.currentTimeMillis());
        HashMap processData = processDefinition.getProcessVariables();
        if (processData == null) {
            processData = new HashMap();
        }
        HashMap<String, Object> renderContext = new HashMap<String, Object>();
        renderContext.put("process", processDesc);
        renderContext.put("outputs", processData);
        renderContext.put("marshallerContext", new ContentMarshallerContext(null, this.getKieServicesClient(serverTemplateId, domainId).getClassLoader()));
        UIServicesClient uiServicesClient = (UIServicesClient)this.getClient(serverTemplateId, domainId, UIServicesClient.class);
        try {
            String formContent = uiServicesClient.getProcessForm(domainId, processId);
            if (formContent != null) {
                this.formManagerService.registerForm(processDesc.getDeploymentId(), processDesc.getId() + "-taskform.form", formContent);
            }
        }
        catch (KieServicesException e) {
            logger.debug("Unable to find process form in remote server due to {}", (Object)e.getMessage());
        }
        try {
            for (FormProvider provider : this.providers) {
                String template = provider.render(processDesc.getName(), processDesc, renderContext);
                if (template == null || template.trim().isEmpty()) continue;
                String string = template;
                return string;
            }
        }
        finally {
            this.formManagerService.unRegisterForms(processDesc.getDeploymentId());
        }
        logger.warn("Unable to find form to render for process '{}'", (Object)processDesc.getName());
        return "";
    }

    protected Map<String, Object> processData(DocumentServicesClient documentClient, Map<String, Object> data) {
        if (data == null || data.isEmpty()) {
            return data;
        }
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            if (!(entry.getValue() instanceof Document)) continue;
            Document document = (Document)entry.getValue();
            document.setLink(documentClient.getDocumentLink(document.getIdentifier()));
        }
        return data;
    }
}

