/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.forms.modeler.client.editors.taskform.displayers;

import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.ht.forms.client.display.displayers.task.AbstractHumanTaskFormDisplayer;
import org.jbpm.console.ng.ht.forms.modeler.service.FormModelerProcessStarterEntryPoint;
import org.jbpm.formModeler.api.events.FormSubmittedEvent;
import org.jbpm.formModeler.api.events.ResizeFormcontainerEvent;
import org.jbpm.formModeler.renderer.client.FormRendererWidget;

@Dependent
public class FormModellerTaskDisplayerImpl
extends AbstractHumanTaskFormDisplayer {
    @Inject
    private FormRendererWidget formRenderer;
    @Inject
    private Caller<FormModelerProcessStarterEntryPoint> renderContextServices;
    private static final String ACTION_SAVE_TASK = "saveTask";
    private static final String ACTION_COMPLETE_TASK = "completeTask";
    private String action;

    protected void initDisplayer() {
        this.formRenderer.loadContext(this.formContent);
        this.formRenderer.setVisible(true);
        this.formContainer.add(this.formRenderer.asWidget());
    }

    public boolean supportsContent(String content) {
        return content.startsWith("formRenderCtx_");
    }

    protected void completeFromDisplayer() {
        this.submitForm(ACTION_COMPLETE_TASK);
    }

    protected void saveStateFromDisplayer() {
        this.submitForm(ACTION_SAVE_TASK);
    }

    protected void startFromDisplayer() {
        ((FormModelerProcessStarterEntryPoint)this.renderContextServices.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void response) {
                FormModellerTaskDisplayerImpl.this.start();
            }
        })).clearContext(this.formContent);
    }

    protected void claimFromDisplayer() {
        ((FormModelerProcessStarterEntryPoint)this.renderContextServices.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void response) {
                FormModellerTaskDisplayerImpl.this.claim();
            }
        })).clearContext(this.formContent);
    }

    protected void releaseFromDisplayer() {
        ((FormModelerProcessStarterEntryPoint)this.renderContextServices.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void response) {
                FormModellerTaskDisplayerImpl.this.release();
            }
        })).clearContext(this.formContent);
    }

    protected void submitForm(String action) {
        this.action = action;
        this.formRenderer.submitFormAndPersist();
    }

    public void onFormSubmitted(@Observes FormSubmittedEvent event) {
        if (event.isMine(this.formContent) && event.getContext().getErrors() == 0) {
            if (ACTION_SAVE_TASK.equals(this.action)) {
                ((FormModelerProcessStarterEntryPoint)this.renderContextServices.call(this.getSaveTaskStateCallback(), this.getUnexpectedErrorCallback())).saveTaskStateFromRenderContext(this.formContent, Long.valueOf(this.taskId));
            } else if (ACTION_COMPLETE_TASK.equals(this.action)) {
                ((FormModelerProcessStarterEntryPoint)this.renderContextServices.call(this.getCompleteTaskRemoteCallback(), this.getUnexpectedErrorCallback())).completeTaskFromContext(this.formContent, Long.valueOf(this.taskId), this.identity.getIdentifier());
            }
        }
    }

    public int getPriority() {
        return 1;
    }

    public void onFormResized(@Observes ResizeFormcontainerEvent event) {
        if (event.isMine(this.formContent)) {
            this.formRenderer.resize(event.getWidth(), event.getHeight());
            if (this.resizeListener != null) {
                this.resizeListener.resize(event.getWidth(), event.getHeight());
            }
        }
    }
}

