/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.backend.server;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.console.ng.ga.model.QueryFilter;
import org.jbpm.console.ng.pr.backend.server.VariableHelper;
import org.jbpm.console.ng.pr.model.DocumentKey;
import org.jbpm.console.ng.pr.model.DocumentSummary;
import org.jbpm.console.ng.pr.model.ProcessVariableSummary;
import org.jbpm.console.ng.pr.service.DocumentsService;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.RuntimeDataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.paging.PageResponse;

@Service
@ApplicationScoped
public class DocumentsServiceImpl
implements DocumentsService {
    private static final Logger logger = LoggerFactory.getLogger(DocumentsServiceImpl.class);
    @Inject
    private RuntimeDataService dataService;
    @Inject
    private DefinitionService bpmn2Service;
    @Inject
    private ProcessService processService;

    public PageResponse<DocumentSummary> getData(QueryFilter filter) {
        PageResponse response = new PageResponse();
        List<DocumentSummary> documents = this.getDocuments(filter);
        response.setStartRowIndex(filter.getOffset().intValue());
        response.setTotalRowSize(documents.size() - 1);
        response.setTotalRowSizeExact(true);
        response.setTotalRowSize(documents.size());
        if (!documents.isEmpty()) {
            if (documents.size() > filter.getCount() + filter.getOffset()) {
                response.setPageRowList(new ArrayList<DocumentSummary>(documents.subList(filter.getOffset(), filter.getOffset() + filter.getCount())));
                response.setLastPage(false);
            } else {
                response.setPageRowList(new ArrayList<DocumentSummary>(documents.subList(filter.getOffset(), documents.size())));
                response.setLastPage(true);
            }
        } else {
            response.setPageRowList(new ArrayList<DocumentSummary>(documents));
            response.setLastPage(true);
        }
        return response;
    }

    private List<DocumentSummary> getDocuments(QueryFilter filter) throws NumberFormatException {
        Long processInstanceId = null;
        String processId = "";
        String deploymentId = "";
        if (filter.getParams() != null) {
            processInstanceId = Long.valueOf((String)filter.getParams().get("processInstanceId"));
            processId = (String)filter.getParams().get("processDefId");
            deploymentId = (String)filter.getParams().get("deploymentId");
        }
        org.kie.internal.query.QueryFilter qf = new org.kie.internal.query.QueryFilter(filter.getOffset().intValue(), filter.getCount() + 1, filter.getOrderBy(), filter.isAscending().booleanValue());
        HashMap<String, String> properties = new HashMap<String, String>(this.bpmn2Service.getProcessVariables(deploymentId, processId));
        Collection<ProcessVariableSummary> processVariables = VariableHelper.adaptCollection(this.dataService.getVariablesCurrentState(processInstanceId.longValue()), properties, processInstanceId);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList<DocumentSummary> documents = new ArrayList<DocumentSummary>();
        for (ProcessVariableSummary pv : processVariables) {
            String[] values;
            if (!"org.jbpm.document.Document".equals(pv.getType()) || pv.getNewValue() == null || pv.getNewValue().isEmpty() || (values = pv.getNewValue().split("####")).length != 4) continue;
            Date lastModified = null;
            try {
                lastModified = sdf.parse(values[2]);
            }
            catch (ParseException ex) {
                logger.error("Can not parse last modified date!", (Throwable)ex);
            }
            documents.add(new DocumentSummary(values[0], lastModified, Long.valueOf(values[1]), values[3]));
        }
        return documents;
    }

    public DocumentSummary getItem(DocumentKey key) {
        return null;
    }

    public List<DocumentSummary> getAll(QueryFilter filter) {
        return this.getDocuments(filter);
    }
}

