/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.backend.server.listener;

import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.internal.identity.IdentityProvider;

public class InitiatorProviderProcessListener
implements ProcessEventListener {
    private KieSession ksession;
    private IdentityProvider identityProvider;

    public InitiatorProviderProcessListener(KieSession ksession) {
        this.ksession = ksession;
    }

    private void resolveIdentityProvider() {
        if (this.identityProvider != null) {
            return;
        }
        Object identityProvider = this.ksession.getEnvironment().get("IdentityProvider");
        Environment env = this.ksession.getEnvironment();
        if (identityProvider instanceof IdentityProvider) {
            this.identityProvider = (IdentityProvider)identityProvider;
        }
    }

    public void beforeProcessStarted(ProcessStartedEvent event) {
        this.resolveIdentityProvider();
        if (this.identityProvider != null) {
            WorkflowProcessInstance wpi = (WorkflowProcessInstance)event.getProcessInstance();
            wpi.setVariable("initiator", (Object)this.identityProvider.getName());
        }
    }

    public void afterProcessStarted(ProcessStartedEvent event) {
    }

    public void beforeProcessCompleted(ProcessCompletedEvent event) {
    }

    public void afterProcessCompleted(ProcessCompletedEvent event) {
    }

    public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
    }

    public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
    }

    public void beforeNodeLeft(ProcessNodeLeftEvent event) {
    }

    public void afterNodeLeft(ProcessNodeLeftEvent event) {
    }

    public void beforeVariableChanged(ProcessVariableChangedEvent event) {
    }

    public void afterVariableChanged(ProcessVariableChangedEvent event) {
    }
}

