/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.backend.server;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.console.ng.ga.model.QueryFilter;
import org.jbpm.console.ng.ks.integration.AbstractKieServerService;
import org.jbpm.console.ng.pr.model.DocumentSummary;
import org.jbpm.console.ng.pr.model.ProcessVariableSummary;
import org.jbpm.console.ng.pr.service.ProcessDocumentsService;
import org.jbpm.console.ng.pr.service.ProcessVariablesService;
import org.kie.server.client.DocumentServicesClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.paging.PageResponse;

@Service
@ApplicationScoped
public class RemoteProcessDocumentsServiceImpl
extends AbstractKieServerService
implements ProcessDocumentsService {
    private static final Logger logger = LoggerFactory.getLogger(RemoteProcessDocumentsServiceImpl.class);
    @Inject
    private ProcessVariablesService processVariablesService;

    public PageResponse<DocumentSummary> getData(QueryFilter filter) {
        PageResponse response = new PageResponse();
        List<DocumentSummary> documents = this.getDocuments(filter);
        response.setStartRowIndex(filter.getOffset().intValue());
        response.setTotalRowSize(documents.size() - 1);
        response.setTotalRowSizeExact(true);
        response.setTotalRowSize(documents.size());
        if (!documents.isEmpty()) {
            if (documents.size() > filter.getCount() + filter.getOffset()) {
                response.setPageRowList(new ArrayList<DocumentSummary>(documents.subList(filter.getOffset(), filter.getOffset() + filter.getCount())));
                response.setLastPage(false);
            } else {
                response.setPageRowList(new ArrayList<DocumentSummary>(documents.subList(filter.getOffset(), documents.size())));
                response.setLastPage(true);
            }
        } else {
            response.setPageRowList(new ArrayList<DocumentSummary>(documents));
            response.setLastPage(true);
        }
        return response;
    }

    private List<DocumentSummary> getDocuments(QueryFilter filter) throws NumberFormatException {
        String serverTemplateId = (String)filter.getParams().get("serverTemplateId");
        List processVariables = this.processVariablesService.getData(filter).getPageRowList();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList<DocumentSummary> documents = new ArrayList<DocumentSummary>();
        for (ProcessVariableSummary pv : processVariables) {
            String[] values;
            if (!"org.jbpm.document.Document".equals(pv.getType()) || pv.getNewValue() == null || pv.getNewValue().isEmpty() || (values = pv.getNewValue().split("####")).length != 4) continue;
            Date lastModified = null;
            try {
                lastModified = sdf.parse(values[2]);
            }
            catch (ParseException ex) {
                logger.error("Can not parse last modified date!", (Throwable)ex);
            }
            documents.add(new DocumentSummary(values[0], lastModified, Long.valueOf(values[1]), this.getDocumentLink(serverTemplateId, values[3])));
        }
        return documents;
    }

    public String getDocumentLink(String serverTemplateId, String documentIdentifier) {
        DocumentServicesClient documentClient = (DocumentServicesClient)this.getClient(serverTemplateId, DocumentServicesClient.class);
        return documentClient.getDocumentLink(documentIdentifier);
    }
}

