/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.client.editors.definition.details.basic;

import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.ga.model.process.DummyProcessPath;
import org.jbpm.console.ng.ga.service.ItemKey;
import org.jbpm.console.ng.pr.client.editors.definition.details.BaseProcessDefDetailsPresenter;
import org.jbpm.console.ng.pr.model.ProcessDefinitionKey;
import org.jbpm.console.ng.pr.model.ProcessSummary;
import org.jbpm.console.ng.pr.service.ProcessDefinitionService;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.VFSService;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;

@Dependent
public class BasicProcessDefDetailsPresenter
extends BaseProcessDefDetailsPresenter {
    @Inject
    private BasicProcessDefDetailsView view;
    @Inject
    private Caller<ProcessDefinitionService> processDefService;
    @Inject
    private Caller<VFSService> fileServices;

    @Override
    public IsWidget getWidget() {
        return this.view;
    }

    @Override
    protected void refreshView(String currentProcessDefId, String currentDeploymentId) {
        this.view.getProcessIdText().setText(currentProcessDefId);
        this.view.getDeploymentIdText().setText(currentDeploymentId);
    }

    private void refreshProcessItems(String deploymentId, String processId) {
        ((ProcessDefinitionService)this.processDefService.call((RemoteCallback)new RemoteCallback<ProcessSummary>(){

            public void callback(ProcessSummary process) {
                if (process != null) {
                    BasicProcessDefDetailsPresenter.this.view.setEncodedProcessSource(process.getEncodedProcessSource());
                    BasicProcessDefDetailsPresenter.this.view.getProcessNameText().setText(process.getName());
                    if (process.getOriginalPath() != null) {
                        ((VFSService)BasicProcessDefDetailsPresenter.this.fileServices.call((RemoteCallback)new RemoteCallback<Path>(){

                            public void callback(Path processPath) {
                                BasicProcessDefDetailsPresenter.this.view.setProcessAssetPath(processPath);
                            }
                        })).get(process.getOriginalPath());
                    } else {
                        BasicProcessDefDetailsPresenter.this.view.setProcessAssetPath((Path)new DummyProcessPath(process.getProcessDefId()));
                    }
                    BasicProcessDefDetailsPresenter.this.changeStyleRow(process.getName(), process.getVersion());
                } else {
                    BasicProcessDefDetailsPresenter.this.view.setEncodedProcessSource(null);
                    BasicProcessDefDetailsPresenter.this.view.setProcessAssetPath(null);
                }
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)("Unexpected error encountered : " + throwable.getMessage()));
                return true;
            }
        })).getItem((ItemKey)new ProcessDefinitionKey(deploymentId, processId));
    }

    @Override
    protected void refreshProcessDef(String deploymentId, String processId) {
        this.refreshProcessItems(deploymentId, processId);
    }

    public static interface BasicProcessDefDetailsView
    extends BaseProcessDefDetailsPresenter.BaseProcessDefDetailsView {
    }
}

