/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.client.editors.instance.list.variables.dash;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.RadioButton;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.github.gwtbootstrap.client.ui.resources.ButtonSize;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.bd.service.KieSessionEntryPoint;
import org.jbpm.console.ng.df.client.filter.FilterSettings;
import org.jbpm.console.ng.df.client.list.base.DataSetQueryHelper;
import org.jbpm.console.ng.gc.client.list.base.AbstractListView;
import org.jbpm.console.ng.gc.client.list.base.AbstractScreenListPresenter;
import org.jbpm.console.ng.gc.client.list.base.events.SearchEvent;
import org.jbpm.console.ng.pr.client.i18n.Constants;
import org.jbpm.console.ng.pr.forms.client.editors.quicknewinstance.QuickNewProcessInstancePopup;
import org.jbpm.console.ng.pr.model.ProcessInstanceVariableSummary;
import org.jbpm.console.ng.pr.model.events.NewProcessInstanceEvent;
import org.jbpm.console.ng.pr.model.events.ProcessInstancesUpdateEvent;
import org.jbpm.console.ng.pr.service.ProcessInstanceService;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;
import org.uberfire.lifecycle.OnFocus;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.paging.PageResponse;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;
import org.uberfire.workbench.model.menu.impl.BaseMenuCustom;

@Dependent
@WorkbenchScreen(identifier="DataSet Process Instance Variable List")
public class DataSetProcessInstanceVariableListPresenter
extends AbstractScreenListPresenter<ProcessInstanceVariableSummary> {
    @Inject
    private DataSetProcessInstanceVariableListView view;
    @Inject
    private Caller<ProcessInstanceService> processInstanceService;
    @Inject
    private Caller<KieSessionEntryPoint> kieSessionServices;
    @Inject
    DataSetQueryHelper dataSetQueryHelper;
    @Inject
    private ErrorPopupPresenter errorPopup;
    public Button menuActionsButton;
    private PopupPanel popup = new PopupPanel(true);
    public Button menuRefreshButton = new Button();
    public Button menuResetTabsButton = new Button();
    @Inject
    private QuickNewProcessInstancePopup newProcessInstancePopup;
    private Constants constants = (Constants)GWT.create(Constants.class);

    public void filterGrid(FilterSettings tableSettings) {
        this.dataSetQueryHelper.setCurrentTableSettings(tableSettings);
        this.refreshGrid();
    }

    protected AbstractListView.ListView getListView() {
        return this.view;
    }

    public void getData(final Range visibleRange) {
        try {
            FilterSettings currentTableSettings = this.dataSetQueryHelper.getCurrentTableSettings();
            if (currentTableSettings != null) {
                currentTableSettings.setTablePageSize(this.view.getListGrid().getPageSize());
                ColumnSortList columnSortList = this.view.getListGrid().getColumnSortList();
                if (columnSortList != null && columnSortList.size() > 0) {
                    this.dataSetQueryHelper.setLastOrderedColumn(columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "");
                    this.dataSetQueryHelper.setLastSortOrder(columnSortList.size() > 0 && columnSortList.get(0).isAscending() ? SortOrder.ASCENDING : SortOrder.DESCENDING);
                } else {
                    this.dataSetQueryHelper.setLastOrderedColumn("varname");
                    this.dataSetQueryHelper.setLastSortOrder(SortOrder.ASCENDING);
                }
                this.dataSetQueryHelper.setDataSetHandler(currentTableSettings);
                if (this.textSearchStr != null && this.textSearchStr.trim().length() > 0) {
                    DataSetFilter filter = new DataSetFilter();
                    ArrayList<ColumnFilter> filters = new ArrayList<ColumnFilter>();
                    filters.add(FilterFactory.likeTo((String)"pname", (String)this.textSearchStr.toLowerCase(), (boolean)false));
                    filters.add(FilterFactory.likeTo((String)"pid", (String)this.textSearchStr.toLowerCase(), (boolean)false));
                    filters.add(FilterFactory.likeTo((String)"varvalue", (String)this.textSearchStr.toLowerCase(), (boolean)false));
                    filter.addFilterColumn(new ColumnFilter[]{FilterFactory.OR(filters)});
                    if (currentTableSettings.getDataSetLookup().getFirstFilterOp() != null) {
                        currentTableSettings.getDataSetLookup().getFirstFilterOp().addFilterColumn(new ColumnFilter[]{FilterFactory.OR(filters)});
                    } else {
                        currentTableSettings.getDataSetLookup().addOperation(new DataSetOp[]{filter});
                    }
                    this.textSearchStr = "";
                }
                this.dataSetQueryHelper.lookupDataSet(Integer.valueOf(visibleRange.getStart()), new DataSetReadyCallback(){

                    public void callback(DataSet dataSet) {
                        if (dataSet != null) {
                            ArrayList<ProcessInstanceVariableSummary> myProcessInstancesFromDataSet = new ArrayList<ProcessInstanceVariableSummary>();
                            for (int i = 0; i < dataSet.getRowCount(); ++i) {
                                myProcessInstancesFromDataSet.add(new ProcessInstanceVariableSummary(DataSetProcessInstanceVariableListPresenter.this.dataSetQueryHelper.getColumnLongValue(dataSet, "pid", i).longValue(), DataSetProcessInstanceVariableListPresenter.this.dataSetQueryHelper.getColumnStringValue(dataSet, "pname", i), DataSetProcessInstanceVariableListPresenter.this.dataSetQueryHelper.getColumnLongValue(dataSet, "varid", i).longValue(), DataSetProcessInstanceVariableListPresenter.this.dataSetQueryHelper.getColumnStringValue(dataSet, "varname", i), DataSetProcessInstanceVariableListPresenter.this.dataSetQueryHelper.getColumnStringValue(dataSet, "varvalue", i)));
                            }
                            PageResponse processInstanceSummaryPageResponse = new PageResponse();
                            processInstanceSummaryPageResponse.setPageRowList(myProcessInstancesFromDataSet);
                            processInstanceSummaryPageResponse.setStartRowIndex(visibleRange.getStart());
                            processInstanceSummaryPageResponse.setTotalRowSize(dataSet.getRowCountNonTrimmed());
                            processInstanceSummaryPageResponse.setTotalRowSizeExact(true);
                            if (visibleRange.getStart() + dataSet.getRowCount() == dataSet.getRowCountNonTrimmed()) {
                                processInstanceSummaryPageResponse.setLastPage(true);
                            } else {
                                processInstanceSummaryPageResponse.setLastPage(false);
                            }
                            DataSetProcessInstanceVariableListPresenter.this.updateDataOnCallback(processInstanceSummaryPageResponse);
                        }
                        DataSetProcessInstanceVariableListPresenter.this.view.hideBusyIndicator();
                    }

                    public void notFound() {
                        DataSetProcessInstanceVariableListPresenter.this.view.hideBusyIndicator();
                        DataSetProcessInstanceVariableListPresenter.this.errorPopup.showMessage("Not found DataSet with UUID [  jbpmProcessInstancesWithVariables ] ");
                        GWT.log((String)"DataSet with UUID [  jbpmProcessInstancesWithVariables ] not found.");
                    }

                    public boolean onError(ClientRuntimeError error) {
                        DataSetProcessInstanceVariableListPresenter.this.view.hideBusyIndicator();
                        DataSetProcessInstanceVariableListPresenter.this.errorPopup.showMessage("DataSet with UUID [  jbpmProcessInstancesWithVariables ] error: " + error.getThrowable());
                        GWT.log((String)"DataSet with UUID [  jbpmProcessInstancesWithVariables ] error: ", (Throwable)error.getThrowable());
                        return false;
                    }
                });
            } else {
                this.view.hideBusyIndicator();
            }
        }
        catch (Exception e) {
            GWT.log((String)"Error looking up dataset with UUID [ jbpmProcessInstancesWithVariables ]");
        }
    }

    public void newInstanceCreated(@Observes NewProcessInstanceEvent pi) {
        this.refreshGrid();
    }

    public void newInstanceCreated(@Observes ProcessInstancesUpdateEvent pis) {
        this.refreshGrid();
    }

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.place = place;
    }

    @OnFocus
    public void onFocus() {
        this.refreshGrid();
    }

    @OnOpen
    public void onOpen() {
        this.refreshGrid();
    }

    public void abortProcessInstance(long processInstanceId) {
        ((KieSessionEntryPoint)this.kieSessionServices.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void v) {
                DataSetProcessInstanceVariableListPresenter.this.refreshGrid();
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)("Unexpected error encountered : " + throwable.getMessage()));
                return true;
            }
        })).abortProcessInstance(processInstanceId);
    }

    public void abortProcessInstance(List<Long> processInstanceIds) {
        ((KieSessionEntryPoint)this.kieSessionServices.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void v) {
                DataSetProcessInstanceVariableListPresenter.this.refreshGrid();
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)("Unexpected error encountered : " + throwable.getMessage()));
                return true;
            }
        })).abortProcessInstances(processInstanceIds);
    }

    public void suspendProcessInstance(String processDefId, long processInstanceId) {
        ((KieSessionEntryPoint)this.kieSessionServices.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void v) {
                DataSetProcessInstanceVariableListPresenter.this.refreshGrid();
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)("Unexpected error encountered : " + throwable.getMessage()));
                return true;
            }
        })).suspendProcessInstance(processInstanceId);
    }

    public void bulkSignal(List<ProcessInstanceVariableSummary> processInstances) {
        StringBuilder processIdsParam = new StringBuilder();
        if (processInstances != null) {
            for (ProcessInstanceVariableSummary selected : processInstances) {
            }
            if (processIdsParam.length() > 0) {
                processIdsParam.deleteCharAt(processIdsParam.length() - 1);
            }
        } else {
            processIdsParam.append("-1");
        }
        DefaultPlaceRequest placeRequestImpl = new DefaultPlaceRequest("Signal Process Popup");
        placeRequestImpl.addParameter("processInstanceId", processIdsParam.toString());
        this.placeManager.goTo((PlaceRequest)placeRequestImpl);
        this.view.displayNotification(this.constants.Signaling_Process_Instance());
    }

    public void bulkAbort(List<ProcessInstanceVariableSummary> processInstances) {
        if (processInstances != null && Window.confirm((String)"Are you sure that you want to abort the selected process instances?")) {
            ArrayList<Long> ids = new ArrayList<Long>();
            for (ProcessInstanceVariableSummary selected : processInstances) {
                ids.add(selected.getProcessInstanceId());
                this.view.displayNotification(this.constants.Aborting_Process_Instance() + "(id=" + selected.getId() + ")");
            }
            this.abortProcessInstance(ids);
        }
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return "Process Instances And Variables";
    }

    @WorkbenchPartView
    public UberView<DataSetProcessInstanceVariableListPresenter> getView() {
        return this.view;
    }

    @WorkbenchMenu
    public Menus getMenus() {
        this.setupButtons();
        return ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)Constants.INSTANCE.New_Process_Instance()).respondsWith(new Command(){

            public void execute() {
                DataSetProcessInstanceVariableListPresenter.this.newProcessInstancePopup.show();
            }
        })).endMenu()).newTopLevelCustomMenu(new MenuFactory.CustomMenuBuilder(){

            public void push(MenuFactory.CustomMenuBuilder element) {
            }

            public MenuItem build() {
                return new BaseMenuCustom<IsWidget>(){

                    public IsWidget build() {
                        DataSetProcessInstanceVariableListPresenter.this.menuRefreshButton.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent clickEvent) {
                                DataSetProcessInstanceVariableListPresenter.this.refreshGrid();
                            }
                        });
                        return DataSetProcessInstanceVariableListPresenter.this.menuRefreshButton;
                    }

                    public boolean isEnabled() {
                        return true;
                    }

                    public void setEnabled(boolean enabled) {
                    }

                    public String getSignatureId() {
                        return "org.jbpm.console.ng.pr.client.editors.instance.list.ProcessInstanceListPresenter#menuRefreshButton";
                    }
                };
            }
        }).endMenu()).newTopLevelCustomMenu(new MenuFactory.CustomMenuBuilder(){

            public void push(MenuFactory.CustomMenuBuilder element) {
            }

            public MenuItem build() {
                return new BaseMenuCustom<IsWidget>(){

                    public IsWidget build() {
                        return DataSetProcessInstanceVariableListPresenter.this.menuActionsButton;
                    }

                    public boolean isEnabled() {
                        return true;
                    }

                    public void setEnabled(boolean enabled) {
                    }

                    public String getSignatureId() {
                        return "org.jbpm.console.ng.pr.client.editors.instance.list.ProcessInstanceList#menuActionsButton";
                    }
                };
            }
        }).endMenu()).newTopLevelCustomMenu(new MenuFactory.CustomMenuBuilder(){

            public void push(MenuFactory.CustomMenuBuilder element) {
            }

            public MenuItem build() {
                return new BaseMenuCustom<IsWidget>(){

                    public IsWidget build() {
                        DataSetProcessInstanceVariableListPresenter.this.menuResetTabsButton.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent clickEvent) {
                                DataSetProcessInstanceVariableListPresenter.this.view.restoreTabs();
                            }
                        });
                        return DataSetProcessInstanceVariableListPresenter.this.menuResetTabsButton;
                    }

                    public boolean isEnabled() {
                        return true;
                    }

                    public void setEnabled(boolean enabled) {
                    }

                    public String getSignatureId() {
                        return "org.jbpm.console.ng.pr.client.editors.instance.list.ProcessInstanceList#menuResetTabsButton";
                    }
                };
            }
        }).endMenu()).build();
    }

    public void setupButtons() {
        this.menuActionsButton = new Button();
        this.createRefreshToggleButton(this.menuActionsButton);
        this.menuRefreshButton.setIcon(IconType.REFRESH);
        this.menuRefreshButton.setSize(ButtonSize.MINI);
        this.menuRefreshButton.setTitle(Constants.INSTANCE.Refresh());
        this.menuResetTabsButton.setIcon(IconType.TH_LIST);
        this.menuResetTabsButton.setSize(ButtonSize.MINI);
        this.menuResetTabsButton.setTitle(Constants.INSTANCE.RestoreDefaultFilters());
    }

    public void createRefreshToggleButton(final Button refreshIntervalSelector) {
        refreshIntervalSelector.setToggle(true);
        refreshIntervalSelector.setIcon(IconType.COG);
        refreshIntervalSelector.setTitle(Constants.INSTANCE.AutoRefresh());
        refreshIntervalSelector.setSize(ButtonSize.MINI);
        this.popup.getElement().getStyle().setZIndex(Integer.MAX_VALUE);
        this.popup.addAutoHidePartner((Element)refreshIntervalSelector.getElement());
        this.popup.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

            public void onClose(CloseEvent<PopupPanel> popupPanelCloseEvent) {
                if (popupPanelCloseEvent.isAutoClosed()) {
                    refreshIntervalSelector.setActive(false);
                }
            }
        });
        refreshIntervalSelector.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!refreshIntervalSelector.isActive()) {
                    DataSetProcessInstanceVariableListPresenter.this.showSelectRefreshIntervalPopup(refreshIntervalSelector.getAbsoluteLeft() + refreshIntervalSelector.getOffsetWidth(), refreshIntervalSelector.getAbsoluteTop() + refreshIntervalSelector.getOffsetHeight(), refreshIntervalSelector);
                } else {
                    DataSetProcessInstanceVariableListPresenter.this.popup.hide(false);
                }
            }
        });
    }

    private void showSelectRefreshIntervalPopup(int left, int top, final Button refreshIntervalSelector) {
        VerticalPanel popupContent = new VerticalPanel();
        final Button resetButton = new Button(Constants.INSTANCE.Disable_autorefresh());
        int configuredSeconds = this.view.getRefreshValue();
        if (configuredSeconds > 10) {
            this.updateRefreshInterval(true, configuredSeconds);
            resetButton.setActive(false);
            resetButton.setEnabled(true);
        } else {
            this.updateRefreshInterval(false, 0);
            resetButton.setActive(true);
            resetButton.setEnabled(false);
            resetButton.setText(Constants.INSTANCE.Autorefresh_Disabled());
        }
        RadioButton oneMinuteRadioButton = this.createTimeSelectorRadioButton(60, "1 " + Constants.INSTANCE.Minute(), configuredSeconds, refreshIntervalSelector, popupContent, resetButton);
        RadioButton fiveMinuteRadioButton = this.createTimeSelectorRadioButton(300, "5 " + Constants.INSTANCE.Minutes(), configuredSeconds, refreshIntervalSelector, popupContent, resetButton);
        RadioButton tenMinuteRadioButton = this.createTimeSelectorRadioButton(600, "10 " + Constants.INSTANCE.Minutes(), configuredSeconds, refreshIntervalSelector, popupContent, resetButton);
        popupContent.add((Widget)oneMinuteRadioButton);
        popupContent.add((Widget)fiveMinuteRadioButton);
        popupContent.add((Widget)tenMinuteRadioButton);
        resetButton.setSize(ButtonSize.MINI);
        resetButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                DataSetProcessInstanceVariableListPresenter.this.updateRefreshInterval(false, 0);
                DataSetProcessInstanceVariableListPresenter.this.view.saveRefreshValue(0);
                refreshIntervalSelector.setActive(false);
                resetButton.setActive(false);
                resetButton.setEnabled(false);
                resetButton.setText(Constants.INSTANCE.Autorefresh_Disabled());
                DataSetProcessInstanceVariableListPresenter.this.popup.hide();
            }
        });
        popupContent.add((Widget)resetButton);
        this.popup.setWidget((Widget)popupContent);
        this.popup.show();
        int finalLeft = left - this.popup.getOffsetWidth();
        this.popup.setPopupPosition(finalLeft, top);
    }

    private RadioButton createTimeSelectorRadioButton(int time, String name, int configuredSeconds, final Button refreshIntervalSelector, VerticalPanel popupContent, final Button refreshDisableButton) {
        RadioButton oneMinuteRadioButton = new RadioButton("refreshInterval", name);
        oneMinuteRadioButton.setText(name);
        final int selectedRefreshTime = time;
        if (configuredSeconds == selectedRefreshTime) {
            oneMinuteRadioButton.setValue(Boolean.valueOf(true));
        }
        oneMinuteRadioButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                DataSetProcessInstanceVariableListPresenter.this.updateRefreshInterval(true, selectedRefreshTime);
                DataSetProcessInstanceVariableListPresenter.this.view.saveRefreshValue(selectedRefreshTime);
                refreshIntervalSelector.setActive(false);
                refreshDisableButton.setActive(false);
                refreshDisableButton.setEnabled(true);
                refreshDisableButton.setText(Constants.INSTANCE.Disable_autorefresh());
                DataSetProcessInstanceVariableListPresenter.this.popup.hide();
            }
        });
        return oneMinuteRadioButton;
    }

    protected void onSearchEvent(@Observes SearchEvent searchEvent) {
        this.textSearchStr = searchEvent.getFilter();
        if (this.textSearchStr != null && this.textSearchStr.trim().length() > 0) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("textSearch", this.textSearchStr);
            this.dataSetQueryHelper.getCurrentTableSettings().getKey();
            this.view.applyFilterOnPresenter(this.dataSetQueryHelper.getCurrentTableSettings().getKey());
        }
    }

    public static interface DataSetProcessInstanceVariableListView
    extends AbstractListView.ListView<ProcessInstanceVariableSummary, DataSetProcessInstanceVariableListPresenter> {
        public int getRefreshValue();

        public void restoreTabs();

        public void saveRefreshValue(int var1);

        public void applyFilterOnPresenter(String var1);
    }
}

