/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.client.editors.instance.signal;

import com.github.gwtbootstrap.client.ui.Label;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.MultiWordSuggestOracle;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.TextBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.console.ng.pr.client.editors.instance.signal.ProcessInstanceSignalPresenter;
import org.jbpm.console.ng.pr.client.i18n.Constants;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
@Templated(value="ProcessInstanceSignalViewImpl.html")
public class ProcessInstanceSignalViewImpl
extends Composite
implements ProcessInstanceSignalPresenter.PopupView {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private ProcessInstanceSignalPresenter presenter;
    @Inject
    @DataField
    public Button signalButton;
    @Inject
    @DataField
    public Button clearButton;
    @Inject
    @DataField
    public Label signalRefLabel;
    @Inject
    @DataField
    public Label eventLabel;
    @Inject
    @DataField
    public TextBox eventText;
    @DataField
    public SuggestBox signalRefText;
    @Inject
    private Event<NotificationEvent> notification;
    public List<Long> processInstanceIds = new ArrayList<Long>();
    private MultiWordSuggestOracle oracle = new MultiWordSuggestOracle();

    public ProcessInstanceSignalViewImpl() {
        this.signalRefText = new SuggestBox((SuggestOracle)this.oracle);
    }

    public void init(ProcessInstanceSignalPresenter presenter) {
        this.presenter = presenter;
        this.clearButton.setText(this.constants.Clear());
        this.signalButton.setText(this.constants.Signal());
        this.signalRefLabel.setText(this.constants.Signal_Name());
        this.eventLabel.setText(this.constants.Signal_Data());
    }

    @Override
    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    @EventHandler(value={"signalButton"})
    public void signalButton(ClickEvent e) {
        for (Long processInstanceId : this.processInstanceIds) {
            this.displayNotification(this.constants.Signalling_Process_Instance() + processInstanceId + " " + this.constants.Signal() + " = " + this.signalRefText.getText() + " - " + this.constants.Signal_Data() + " = " + this.eventText.getText());
        }
        this.presenter.signalProcessInstances(this.processInstanceIds);
    }

    @EventHandler(value={"clearButton"})
    public void clearButton(ClickEvent e) {
        this.signalRefText.setValue("");
        this.eventText.setValue((Object)"");
    }

    @Override
    public void addProcessInstanceId(long processInstanceId) {
        this.processInstanceIds.add(processInstanceId);
    }

    @Override
    public String getSignalRefText() {
        return this.signalRefText.getText();
    }

    @Override
    public String getEventText() {
        return this.eventText.getText();
    }

    @Override
    public void setAvailableSignals(Collection<String> signals) {
        this.oracle.addAll(signals);
    }
}

