/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.client.editors.variables.edit;

import com.github.gwtbootstrap.client.ui.ControlGroup;
import com.github.gwtbootstrap.client.ui.HelpBlock;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.github.gwtbootstrap.client.ui.constants.ButtonType;
import com.github.gwtbootstrap.client.ui.constants.ControlGroupType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.bd.service.KieSessionEntryPoint;
import org.jbpm.console.ng.pr.client.i18n.Constants;
import org.jbpm.console.ng.pr.model.events.ProcessInstancesUpdateEvent;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.GenericModalFooter;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class VariableEditPopup
extends BaseModal {
    @UiField
    public TextBox variableNameTextBox;
    @UiField
    public TextBox variableValueTextBox;
    @UiField
    public HelpBlock errorMessages;
    @UiField
    public ControlGroup errorMessagesGroup;
    @Inject
    private Event<NotificationEvent> notification;
    @Inject
    private Caller<KieSessionEntryPoint> kieSessionServices;
    @Inject
    private Event<ProcessInstancesUpdateEvent> processInstancesUpdateEvent;
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    private long processInstanceId;

    public VariableEditPopup() {
        this.setTitle(Constants.INSTANCE.Edit());
        this.add((Widget)uiBinder.createAndBindUi((Object)this));
        GenericModalFooter footer = new GenericModalFooter();
        footer.addButton(Constants.INSTANCE.Clear(), new Command(){

            public void execute() {
                VariableEditPopup.this.variableValueTextBox.setText("");
            }
        }, null, ButtonType.PRIMARY);
        footer.addButton(Constants.INSTANCE.Save(), new Command(){

            public void execute() {
                VariableEditPopup.this.setProcessVariable();
            }
        }, null, ButtonType.PRIMARY);
        this.add((Widget)footer);
    }

    public void show(long processInstanceId, String variableId, String variableValue) {
        this.processInstanceId = processInstanceId;
        this.variableNameTextBox.setText(variableId);
        this.variableValueTextBox.setText(variableValue);
        this.cleanErrorMessages();
        super.show();
    }

    private void cleanErrorMessages() {
        this.errorMessages.setText("");
        this.errorMessagesGroup.setType(ControlGroupType.NONE);
    }

    public void closePopup() {
        this.hide();
        super.hide();
        this.processInstancesUpdateEvent.fire((Object)new ProcessInstancesUpdateEvent());
    }

    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    public void setProcessVariable() {
        ((KieSessionEntryPoint)this.kieSessionServices.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void v) {
                VariableEditPopup.this.displayNotification(Constants.INSTANCE.VariableValueUpdated(VariableEditPopup.this.variableNameTextBox.getValue()));
                VariableEditPopup.this.closePopup();
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                VariableEditPopup.this.errorMessages.setText(throwable.getMessage());
                VariableEditPopup.this.errorMessagesGroup.setType(ControlGroupType.ERROR);
                return true;
            }
        })).setProcessVariable(this.processInstanceId, this.variableNameTextBox.getValue(), (Object)this.variableValueTextBox.getValue());
    }

    static interface Binder
    extends UiBinder<Widget, VariableEditPopup> {
    }
}

