/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.client.editors.instance.details.multi;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.bd.service.DataServiceEntryPoint;
import org.jbpm.console.ng.bd.service.KieSessionEntryPoint;
import org.jbpm.console.ng.pr.client.editors.diagram.ProcessDiagramUtil;
import org.jbpm.console.ng.pr.client.editors.documents.list.ProcessDocumentListPresenter;
import org.jbpm.console.ng.pr.client.editors.instance.details.ProcessInstanceDetailsPresenter;
import org.jbpm.console.ng.pr.client.editors.instance.log.RuntimeLogPresenter;
import org.jbpm.console.ng.pr.client.editors.variables.list.ProcessVariableListPresenter;
import org.jbpm.console.ng.pr.client.i18n.Constants;
import org.jbpm.console.ng.pr.model.NodeInstanceSummary;
import org.jbpm.console.ng.pr.model.ProcessInstanceSummary;
import org.jbpm.console.ng.pr.model.events.ProcessInstanceSelectionEvent;
import org.jbpm.console.ng.pr.model.events.ProcessInstancesUpdateEvent;
import org.uberfire.client.annotations.DefaultPosition;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.Position;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;
import org.uberfire.workbench.model.menu.impl.BaseMenuCustom;

@Dependent
@WorkbenchScreen(identifier="Process Instance Details Multi", preferredWidth=500)
public class ProcessInstanceDetailsMultiPresenter {
    @Inject
    public ProcessInstanceDetailsMultiView view;
    private Constants constants = (Constants)GWT.create(Constants.class);
    @Inject
    private PlaceManager placeManager;
    @Inject
    private Caller<KieSessionEntryPoint> kieSessionServices;
    @Inject
    private Caller<DataServiceEntryPoint> dataServices;
    @Inject
    private Event<ProcessInstanceSelectionEvent> processInstanceSelected;
    @Inject
    private Event<ProcessInstancesUpdateEvent> processInstancesUpdatedEvent;
    @Inject
    private Event<ChangeTitleWidgetEvent> changeTitleWidgetEvent;
    @Inject
    private ProcessInstanceDetailsPresenter detailsPresenter;
    @Inject
    private ProcessVariableListPresenter variableListPresenter;
    @Inject
    private ProcessDocumentListPresenter documentListPresenter;
    @Inject
    private RuntimeLogPresenter runtimeLogPresenter;
    private String selectedDeploymentId = "";
    private int selectedProcessInstanceStatus = 0;
    private String selectedProcessDefName = "";
    private PlaceRequest place;
    private String deploymentId = "";
    private String processId = "";

    @WorkbenchPartView
    public UberView<ProcessInstanceDetailsMultiPresenter> getView() {
        return this.view;
    }

    @DefaultPosition
    public Position getPosition() {
        return CompassPosition.EAST;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.Details();
    }

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.place = place;
    }

    public void onProcessSelectionEvent(@Observes ProcessInstanceSelectionEvent event) {
        this.deploymentId = String.valueOf(event.getProcessInstanceId());
        this.processId = event.getProcessDefId();
        this.selectedDeploymentId = event.getDeploymentId();
        this.selectedProcessInstanceStatus = event.getProcessInstanceStatus();
        this.selectedProcessDefName = event.getProcessDefName();
        this.changeTitleWidgetEvent.fire((Object)new ChangeTitleWidgetEvent(this.place, String.valueOf(this.deploymentId) + " - " + this.selectedProcessDefName));
        this.view.selectInstanceDetailsTab();
    }

    public void refresh() {
        this.processInstanceSelected.fire((Object)new ProcessInstanceSelectionEvent(this.selectedDeploymentId, Long.valueOf(this.deploymentId), this.processId, this.selectedProcessDefName, Integer.valueOf(this.selectedProcessInstanceStatus)));
    }

    public void signalProcessInstance() {
        DefaultPlaceRequest placeRequestImpl = new DefaultPlaceRequest("Signal Process Popup");
        placeRequestImpl.addParameter("processInstanceId", this.deploymentId);
        this.placeManager.goTo((PlaceRequest)placeRequestImpl);
    }

    public void abortProcessInstance() {
        ((DataServiceEntryPoint)this.dataServices.call((RemoteCallback)new RemoteCallback<ProcessInstanceSummary>(){

            public void callback(ProcessInstanceSummary processInstance) {
                if (processInstance.getState() == 1 || processInstance.getState() == 0) {
                    if (Window.confirm((String)"Are you sure that you want to abort the process instance?")) {
                        long processInstanceId = Long.parseLong(ProcessInstanceDetailsMultiPresenter.this.deploymentId);
                        ((KieSessionEntryPoint)ProcessInstanceDetailsMultiPresenter.this.kieSessionServices.call((RemoteCallback)new RemoteCallback<Void>(){

                            public void callback(Void v) {
                                ProcessInstanceDetailsMultiPresenter.this.processInstancesUpdatedEvent.fire((Object)new ProcessInstancesUpdateEvent(Long.valueOf(0L)));
                            }
                        }, (ErrorCallback)new ErrorCallback<Message>(){

                            public boolean error(Message message, Throwable throwable) {
                                ErrorPopup.showMessage((String)("Unexpected error encountered : " + throwable.getMessage()));
                                return true;
                            }
                        })).abortProcessInstance(processInstanceId);
                    }
                } else {
                    Window.alert((String)"Process instance needs to be active in order to be aborted");
                }
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)("Unexpected error encountered : " + throwable.getMessage()));
                return true;
            }
        })).getProcessInstanceById(Long.parseLong(this.deploymentId));
    }

    public void goToProcessInstanceModelPopup() {
        if (this.place != null && !this.deploymentId.equals("")) {
            ((DataServiceEntryPoint)this.dataServices.call((RemoteCallback)new RemoteCallback<List<NodeInstanceSummary>>(){

                public void callback(List<NodeInstanceSummary> activeNodes) {
                    final StringBuffer nodeParam = new StringBuffer();
                    for (NodeInstanceSummary activeNode : activeNodes) {
                        nodeParam.append(activeNode.getNodeUniqueName() + ",");
                    }
                    if (nodeParam.length() > 0) {
                        nodeParam.deleteCharAt(nodeParam.length() - 1);
                    }
                    ((DataServiceEntryPoint)ProcessInstanceDetailsMultiPresenter.this.dataServices.call((RemoteCallback)new RemoteCallback<List<NodeInstanceSummary>>(){

                        public void callback(List<NodeInstanceSummary> completedNodes) {
                            StringBuffer completedNodeParam = new StringBuffer();
                            for (NodeInstanceSummary completedNode : completedNodes) {
                                if (completedNode.isCompleted()) {
                                    completedNodeParam.append(completedNode.getNodeUniqueName() + ",");
                                    completedNodeParam.append(completedNode.getConnection() + ",");
                                    continue;
                                }
                                if (completedNode.getConnection() == null) continue;
                                completedNodeParam.append(completedNode.getConnection() + ",");
                            }
                            completedNodeParam.deleteCharAt(completedNodeParam.length() - 1);
                            ProcessInstanceDetailsMultiPresenter.this.placeManager.goTo(ProcessDiagramUtil.buildPlaceRequest(new DefaultPlaceRequest("").addParameter("activeNodes", nodeParam.toString()).addParameter("completedNodes", completedNodeParam.toString()).addParameter("readOnly", "true").addParameter("processId", ProcessInstanceDetailsMultiPresenter.this.processId).addParameter("deploymentId", ProcessInstanceDetailsMultiPresenter.this.selectedDeploymentId)));
                        }
                    }, (ErrorCallback)new ErrorCallback<Message>(){

                        public boolean error(Message message, Throwable throwable) {
                            ErrorPopup.showMessage((String)("Unexpected error encountered : " + throwable.getMessage()));
                            return true;
                        }
                    })).getProcessInstanceCompletedNodes(Long.parseLong(ProcessInstanceDetailsMultiPresenter.this.deploymentId));
                }
            }, (ErrorCallback)new ErrorCallback<Message>(){

                public boolean error(Message message, Throwable throwable) {
                    ErrorPopup.showMessage((String)("Unexpected error encountered : " + throwable.getMessage()));
                    return true;
                }
            })).getProcessInstanceActiveNodes(Long.parseLong(this.deploymentId));
        }
    }

    @WorkbenchMenu
    public Menus buildMenu() {
        return ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)MenuFactory.newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new MenuFactory.CustomMenuBuilder(){

            public void push(MenuFactory.CustomMenuBuilder element) {
            }

            public MenuItem build() {
                return new BaseMenuCustom<IsWidget>(){

                    public IsWidget build() {
                        return ProcessInstanceDetailsMultiPresenter.this.view.getOptionsButton();
                    }
                };
            }
        }).endMenu()).newTopLevelCustomMenu(new MenuFactory.CustomMenuBuilder(){

            public void push(MenuFactory.CustomMenuBuilder element) {
            }

            public MenuItem build() {
                return new BaseMenuCustom<IsWidget>(){

                    public IsWidget build() {
                        return ProcessInstanceDetailsMultiPresenter.this.view.getRefreshButton();
                    }
                };
            }
        }).endMenu()).build();
    }

    public void closeDetails() {
        this.placeManager.closePlace(this.place);
    }

    public void variableListRefreshGrid() {
        this.variableListPresenter.refreshGrid();
    }

    public void documentListRefreshGrid() {
        this.documentListPresenter.refreshGrid();
    }

    public IsWidget getProcessIntanceView() {
        return this.detailsPresenter.getWidget();
    }

    public IsWidget getProcessVariablesView() {
        return this.variableListPresenter.getWidget();
    }

    public IsWidget getDocumentView() {
        return this.documentListPresenter.getWidget();
    }

    public IsWidget getLogsView() {
        return this.runtimeLogPresenter.getWidget();
    }

    public static interface ProcessInstanceDetailsMultiView
    extends UberView<ProcessInstanceDetailsMultiPresenter> {
        public IsWidget getOptionsButton();

        public IsWidget getRefreshButton();

        public IsWidget getCloseButton();

        public void selectInstanceDetailsTab();
    }
}

