/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.client.editors.instance.list;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.user.client.Window;
import com.google.gwt.view.client.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.bd.service.KieSessionEntryPoint;
import org.jbpm.console.ng.ga.model.PortableQueryFilter;
import org.jbpm.console.ng.gc.client.list.base.AbstractListView;
import org.jbpm.console.ng.gc.client.list.base.AbstractScreenListPresenter;
import org.jbpm.console.ng.pr.client.i18n.Constants;
import org.jbpm.console.ng.pr.model.ProcessInstanceSummary;
import org.jbpm.console.ng.pr.model.events.NewProcessInstanceEvent;
import org.jbpm.console.ng.pr.model.events.ProcessInstancesUpdateEvent;
import org.jbpm.console.ng.pr.service.ProcessInstanceService;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;
import org.uberfire.lifecycle.OnFocus;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.paging.PageResponse;

@Dependent
@WorkbenchScreen(identifier="Process Instance List")
public class ProcessInstanceListPresenter
extends AbstractScreenListPresenter<ProcessInstanceSummary> {
    public static String FILTER_STATE_PARAM_NAME = "states";
    public static String FILTER_PROCESS_DEFINITION_PARAM_NAME = "currentProcessDefinition";
    public static String FILTER_INITIATOR_PARAM_NAME = "initiator";
    @Inject
    private ProcessInstanceListView view;
    @Inject
    private Caller<ProcessInstanceService> processInstanceService;
    @Inject
    private Caller<KieSessionEntryPoint> kieSessionServices;
    private String currentProcessDefinition;
    private List<Integer> currentActiveStates;
    private String initiator;
    private Constants constants = (Constants)GWT.create(Constants.class);

    public void filterGrid(ArrayList<Integer> states, String currentProcessDefinition, String initiator) {
        this.currentActiveStates = states;
        this.currentProcessDefinition = currentProcessDefinition;
        this.initiator = initiator;
        this.refreshGrid();
    }

    protected AbstractListView.ListView getListView() {
        return this.view;
    }

    public void getData(Range visibleRange) {
        if (!this.isAddingDefaultFilters()) {
            ColumnSortList columnSortList = this.view.getListGrid().getColumnSortList();
            if (this.currentFilter == null) {
                this.currentFilter = new PortableQueryFilter(visibleRange.getStart(), visibleRange.getLength(), false, "", columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "", columnSortList.size() > 0 ? columnSortList.get(0).isAscending() : true);
            }
            if (this.currentFilter.getParams() == null || this.currentFilter.getParams().isEmpty() || this.currentFilter.getParams().get("textSearch") == null || this.currentFilter.getParams().get("textSearch").equals("")) {
                this.currentFilter.setOffset(Integer.valueOf(visibleRange.getStart()));
                this.currentFilter.setCount(Integer.valueOf(visibleRange.getLength()));
            } else {
                this.currentFilter.setOffset(Integer.valueOf(0));
                this.currentFilter.setCount(Integer.valueOf(this.view.getListGrid().getPageSize()));
            }
            if (this.currentFilter.getParams() == null) {
                this.currentFilter.setParams(new HashMap());
            }
            if (this.initiator != null && this.initiator.trim().length() > 0) {
                this.currentFilter.getParams().put(FILTER_INITIATOR_PARAM_NAME, this.initiator);
            } else {
                this.currentFilter.getParams().remove(FILTER_INITIATOR_PARAM_NAME);
            }
            this.currentFilter.getParams().put(FILTER_STATE_PARAM_NAME, this.currentActiveStates);
            this.currentFilter.getParams().put(FILTER_PROCESS_DEFINITION_PARAM_NAME, this.currentProcessDefinition);
            this.currentFilter.setOrderBy(columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "");
            this.currentFilter.setIsAscending(Boolean.valueOf(columnSortList.size() > 0 ? columnSortList.get(0).isAscending() : true));
            ((ProcessInstanceService)this.processInstanceService.call((RemoteCallback)new RemoteCallback<PageResponse<ProcessInstanceSummary>>(){

                public void callback(PageResponse<ProcessInstanceSummary> response) {
                    ProcessInstanceListPresenter.this.updateDataOnCallback(response);
                }
            }, (ErrorCallback)new ErrorCallback<Message>(){

                public boolean error(Message message, Throwable throwable) {
                    ProcessInstanceListPresenter.this.view.hideBusyIndicator();
                    ProcessInstanceListPresenter.this.view.displayNotification("Error: Getting Process Definitions: " + message);
                    GWT.log((String)throwable.toString());
                    return true;
                }
            })).getData(this.currentFilter);
        }
    }

    public void newInstanceCreated(@Observes NewProcessInstanceEvent pi) {
        this.refreshGrid();
    }

    public void newInstanceCreated(@Observes ProcessInstancesUpdateEvent pis) {
        this.refreshGrid();
    }

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.place = place;
    }

    @OnFocus
    public void onFocus() {
        this.refreshGrid();
    }

    @OnOpen
    public void onOpen() {
        this.currentProcessDefinition = this.place.getParameter("processName", "");
        this.refreshGrid();
    }

    public void abortProcessInstance(long processInstanceId) {
        ((KieSessionEntryPoint)this.kieSessionServices.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void v) {
                ProcessInstanceListPresenter.this.refreshGrid();
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)("Unexpected error encountered : " + throwable.getMessage()));
                return true;
            }
        })).abortProcessInstance(processInstanceId);
    }

    public void abortProcessInstance(List<Long> processInstanceIds) {
        ((KieSessionEntryPoint)this.kieSessionServices.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void v) {
                ProcessInstanceListPresenter.this.refreshGrid();
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)("Unexpected error encountered : " + throwable.getMessage()));
                return true;
            }
        })).abortProcessInstances(processInstanceIds);
    }

    public void suspendProcessInstance(String processDefId, long processInstanceId) {
        ((KieSessionEntryPoint)this.kieSessionServices.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void v) {
                ProcessInstanceListPresenter.this.refreshGrid();
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)("Unexpected error encountered : " + throwable.getMessage()));
                return true;
            }
        })).suspendProcessInstance(processInstanceId);
    }

    public void bulkSignal(List<ProcessInstanceSummary> processInstances) {
        StringBuilder processIdsParam = new StringBuilder();
        if (processInstances != null) {
            for (ProcessInstanceSummary selected : processInstances) {
                if (selected.getState() != 1) {
                    this.view.displayNotification(this.constants.Signaling_Process_Instance_Not_Allowed() + "(id=" + selected.getId() + ")");
                    continue;
                }
                processIdsParam.append(selected.getId() + ",");
            }
            if (processIdsParam.length() > 0) {
                processIdsParam.deleteCharAt(processIdsParam.length() - 1);
            }
        } else {
            processIdsParam.append("-1");
        }
        DefaultPlaceRequest placeRequestImpl = new DefaultPlaceRequest("Signal Process Popup");
        placeRequestImpl.addParameter("processInstanceId", processIdsParam.toString());
        this.placeManager.goTo((PlaceRequest)placeRequestImpl);
        this.view.displayNotification(this.constants.Signaling_Process_Instance());
    }

    public void bulkAbort(List<ProcessInstanceSummary> processInstances) {
        if (processInstances != null && Window.confirm((String)"Are you sure that you want to abort the selected process instances?")) {
            ArrayList<Long> ids = new ArrayList<Long>();
            for (ProcessInstanceSummary selected : processInstances) {
                if (selected.getState() != 1) {
                    this.view.displayNotification(this.constants.Aborting_Process_Instance_Not_Allowed() + "(id=" + selected.getId() + ")");
                    continue;
                }
                ids.add(selected.getProcessInstanceId());
                this.view.displayNotification(this.constants.Aborting_Process_Instance() + "(id=" + selected.getId() + ")");
            }
            this.abortProcessInstance(ids);
        }
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.Process_Instances();
    }

    @WorkbenchPartView
    public UberView<ProcessInstanceListPresenter> getView() {
        return this.view;
    }

    public static interface ProcessInstanceListView
    extends AbstractListView.ListView<ProcessInstanceSummary, ProcessInstanceListPresenter> {
    }
}

